/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.network;

import igentuman.blockbooster.tile.ITileBooster;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class BoosterPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = ResourceLocation.parse((String)"blockbooster:booster_packet");
    public static final CustomPacketPayload.Type<BoosterPacket> TYPE = new CustomPacketPayload.Type(ID);
    private BlockPos pos;
    private long posKey;
    private boolean val;

    public BoosterPacket(BlockPos pos, long posKey, boolean val) {
        this.pos = pos;
        this.posKey = posKey;
        this.val = val;
    }

    public BoosterPacket(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.posKey = buf.readLong();
        this.val = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeLong(this.posKey);
        buf.writeBoolean(this.val);
    }

    public static void handle(BoosterPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player;
            BlockEntity be;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && (be = (player = (ServerPlayer)patt0$temp).level().getBlockEntity(packet.pos)) instanceof ITileBooster) {
                ((ITileBooster)be).setIndexStatus(packet.posKey, packet.val);
            }
        });
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

