/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.tile;

import igentuman.blockbooster.config.CommonConfig;
import igentuman.blockbooster.tile.ITileBooster;
import igentuman.blockbooster.util.BoosterUtil;
import igentuman.blockbooster.util.TPSTracker;
import igentuman.blockbooster.util.WorldUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractBooster
extends BlockEntity
implements BlockEntityTicker,
ITileBooster {
    protected LinkedList<String> whiteList;
    protected LinkedList<String> blackList;
    protected HashMap<Long, BlockEntity> attachedBlocks = new HashMap();
    protected HashMap<Long, Long> boostTimes = new HashMap();
    protected HashMap<Long, Boolean> boostFlags = new HashMap();
    public boolean isDisabled = false;
    public boolean isLagging = false;
    protected long tick = 0L;
    public boolean preventSlowBlocks;
    public long slowBlockThreshold;

    public AbstractBooster(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.preventSlowBlocks = (Boolean)CommonConfig.GENERAL.prevent_slow_blocks.get();
        this.slowBlockThreshold = (Long)CommonConfig.GENERAL.slow_block_threshold_ns.get();
    }

    protected LinkedList<String> getWhiteList() {
        if (this.whiteList == null) {
            this.whiteList = this.loadList((List)CommonConfig.GENERAL.white_list.get());
        }
        return this.whiteList;
    }

    protected LinkedList<String> getBlackList() {
        if (this.blackList == null) {
            this.blackList = this.loadList((List)CommonConfig.GENERAL.black_list.get());
        }
        return this.blackList;
    }

    private LinkedList<String> loadList(List<? extends String> configList) {
        LinkedList<String> list = new LinkedList<String>();
        for (String string : configList) {
            if (string.contains("#")) {
                try {
                    String tagKey = string.replace("#", "");
                    HashSet<Block> blocks = BoosterUtil.getBlocksByTagKey(tagKey);
                    if (blocks == null || blocks.isEmpty()) continue;
                    list.addAll(blocks.stream().map(b -> BuiltInRegistries.BLOCK.getKey(b).toString()).toList());
                }
                catch (Exception e) {
                    System.err.println("BlockBooster: Failed to load tag '" + string + "': " + e.getMessage());
                }
                continue;
            }
            list.add(string);
        }
        return list;
    }

    public String getBlockName(BlockEntity be) {
        return BuiltInRegistries.BLOCK.getKey((Object)be.getBlockState().getBlock()).toString();
    }

    protected void updateRedstoneControl() {
        if (this.level.hasNeighborSignal(this.worldPosition) && ((Boolean)CommonConfig.GENERAL.deactivate_with_redstone.get()).booleanValue()) {
            if (((Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
                this.setChanged();
                this.level.setBlock(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)), 3);
            }
            this.isDisabled = true;
            return;
        }
        this.isDisabled = false;
    }

    public void updateAttachedBlocks() {
        boolean changed = false;
        for (Direction direction : Direction.values()) {
            if (this.shouldSkipDirection(direction)) continue;
            BlockPos checkPos = this.getBlockPos().relative(direction, 1);
            long posKey = checkPos.asLong();
            BlockEntity be = WorldUtil.getBlockEntity(checkPos, (ServerLevel)this.level);
            boolean contains = this.attachedBlocks.containsKey(posKey);
            if (be == null) {
                if (!contains) continue;
                changed = true;
                this.attachedBlocks.remove(posKey);
                continue;
            }
            if (be instanceof AbstractBooster) {
                if (!contains) continue;
                changed = true;
                this.attachedBlocks.remove(posKey);
                continue;
            }
            if (contains && this.attachedBlocks.get(posKey).equals(be) || (this.getWhiteList().isEmpty() ? this.getBlackList().contains(this.getBlockName(be)) : !this.getWhiteList().contains(this.getBlockName(be)))) continue;
            if (contains) {
                this.attachedBlocks.remove(posKey);
            }
            changed = true;
            this.attachedBlocks.put(posKey, be);
        }
        if (changed) {
            for (Long key2 : this.attachedBlocks.keySet()) {
                if (!this.boostFlags.containsKey(key2)) {
                    this.boostFlags.put(key2, false);
                }
                if (this.boostTimes.containsKey(key2)) continue;
                this.boostTimes.put(key2, 0L);
            }
            this.boostFlags.keySet().removeIf(key -> !this.attachedBlocks.containsKey(key));
            this.boostTimes.keySet().removeIf(key -> !this.attachedBlocks.containsKey(key));
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected boolean shouldSkipDirection(Direction direction) {
        return false;
    }

    protected boolean checkTPS() {
        if (!((Boolean)CommonConfig.GENERAL.enable_tps_protection.get()).booleanValue()) {
            return true;
        }
        return TPSTracker.isTpsAcceptable((Double)CommonConfig.GENERAL.min_tps_threshold.get());
    }

    @Override
    public void tickServer() {
        if (this.level == null) {
            return;
        }
        ++this.tick;
        if (this.tick % 20L == 0L) {
            if (!this.level.isClientSide()) {
                boolean lastState = this.isDisabled;
                boolean lastLagState = this.isLagging;
                this.updateRedstoneControl();
                boolean bl = this.isLagging = !this.checkTPS();
                if (lastState != this.isDisabled || lastLagState != this.isLagging) {
                    this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
                }
                if (this.isDisabled || this.isLagging) {
                    return;
                }
            }
            this.updateAttachedBlocks();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
        if (this.isLagging) {
            return;
        }
        this.processBoostingLogic();
    }

    protected void processBoostingLogic() {
        for (Long posKey : this.attachedBlocks.keySet()) {
            Long lastBoostTime;
            BlockEntity be;
            if (!this.boostFlags.getOrDefault(posKey, false).booleanValue() || (be = this.attachedBlocks.get(posKey)) == null || be.isRemoved() || !this.canBoost() || this.preventSlowBlocks && (lastBoostTime = this.boostTimes.get(posKey)) != null && lastBoostTime > this.slowBlockThreshold) continue;
            BoosterUtil.BoostResult result = BoosterUtil.BoostBlockEntityWithTiming(this.level, be.getBlockPos(), be, this.getBoostRate());
            if (!result.success) continue;
            this.boostTimes.put(posKey, result.timeNanos);
            this.consumeResource();
        }
    }

    protected abstract boolean canBoost();

    protected abstract int getBoostRate();

    protected abstract void consumeResource();

    protected abstract void saveBoosterData(CompoundTag var1);

    protected abstract void loadBoosterData(CompoundTag var1);

    @Override
    public void tickClient() {
        for (Long key : this.attachedBlocks.keySet()) {
            BlockEntity be = this.attachedBlocks.get(key);
            if (be != null) continue;
            this.attachedBlocks.put(key, this.level.getBlockEntity(BlockPos.of((long)key)));
        }
    }

    public void tick(Level world, BlockPos pos, BlockState state, BlockEntity be) {
    }

    public HashMap<Long, BlockEntity> getAttachedBlocks() {
        return this.attachedBlocks;
    }

    public HashMap<Long, Boolean> getBoostFlags() {
        return this.boostFlags;
    }

    public boolean isIndexEnabled(long i) {
        return this.boostFlags.getOrDefault(i, false);
    }

    @Override
    public void setIndexStatus(long posKey, boolean status) {
        this.boostFlags.put(posKey, status);
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.isDisabled = tag.getBoolean("isDisabled");
        this.isLagging = tag.getBoolean("isLagging");
        this.loadBoosterData(tag);
        if (this.attachedBlocks.size() != this.boostFlags.size()) {
            this.attachedBlocks.clear();
            for (Long key : this.boostFlags.keySet()) {
                this.attachedBlocks.put(key, this.level.getBlockEntity(BlockPos.of((long)key)));
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("isDisabled", this.isDisabled);
        tag.putBoolean("isLagging", this.isLagging);
        this.saveBoosterData(tag);
    }

    public boolean isLagging() {
        return this.isLagging;
    }

    public double getCurrentTPS() {
        return TPSTracker.getCurrentTPS();
    }
}

