/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.tile;

import igentuman.blockbooster.config.CommonConfig;
import igentuman.blockbooster.setup.Registration;
import igentuman.blockbooster.tile.AbstractBooster;
import igentuman.blockbooster.util.CustomEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileBoosterT2
extends AbstractBooster {
    public final CustomEnergyStorage energy = this.createEnergyStorage();
    public int fePerTick;

    public TileBoosterT2(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.BLOCKBOOSTER_T2_BE.get(), pos, state);
        this.fePerTick = (Integer)CommonConfig.GENERAL.t2_fe_per_tick.get();
    }

    @Override
    protected boolean canBoost() {
        return this.getEnergy() >= this.fePerTick;
    }

    @Override
    protected int getBoostRate() {
        return (Integer)CommonConfig.GENERAL.t2_boost_rate.get();
    }

    @Override
    protected void consumeResource() {
        this.consumeEnergy(this.fePerTick);
    }

    @Override
    protected void saveBoosterData(CompoundTag tag) {
        tag.putInt("Energy", this.energy.getEnergyStored());
        CompoundTag flagsTag = new CompoundTag();
        for (Long key : this.boostFlags.keySet()) {
            flagsTag.putBoolean(String.valueOf(key), ((Boolean)this.boostFlags.get(key)).booleanValue());
        }
        tag.put("boostFlags", (Tag)flagsTag);
    }

    @Override
    protected void loadBoosterData(CompoundTag tag) {
        if (tag.contains("Energy")) {
            this.energy.setEnergy(tag.getInt("Energy"));
        }
        if (tag.contains("boostFlags")) {
            this.boostFlags.clear();
            CompoundTag flagsTag = tag.getCompound("boostFlags");
            for (String key : flagsTag.getAllKeys()) {
                this.boostFlags.put(Long.parseLong(key), flagsTag.getBoolean(key));
            }
        }
    }

    public int getEnergy() {
        return this.energy.getEnergyStored();
    }

    public void consumeEnergy(int amount) {
        this.energy.consumeEnergy(amount);
    }

    public int getMaxEnergy() {
        return (Integer)CommonConfig.GENERAL.t2_fe_per_tick.get() * 100;
    }

    private CustomEnergyStorage createEnergyStorage() {
        return new CustomEnergyStorage(this.getMaxEnergy(), this.getMaxEnergy()){

            @Override
            public int receiveEnergy(int maxReceive, boolean simulate) {
                int rc = super.receiveEnergy(maxReceive, simulate);
                if (rc > 0 && !simulate) {
                    TileBoosterT2.this.setChanged();
                }
                return rc;
            }
        };
    }
}

