/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.tile;

import igentuman.blockbooster.config.CommonConfig;
import igentuman.blockbooster.setup.Registration;
import igentuman.blockbooster.tile.AbstractBooster;
import igentuman.blockbooster.util.CustomEnergyStorage;
import igentuman.blockbooster.util.WorldUtil;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileBoosterT3
extends AbstractBooster {
    public final CustomEnergyStorage energy = this.createEnergyStorage();
    public int fePerTick;

    public TileBoosterT3(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.BLOCKBOOSTER_T3_BE.get(), pos, state);
        this.fePerTick = (Integer)CommonConfig.GENERAL.t3_fe_per_tick.get();
    }

    @Override
    public void updateAttachedBlocks() {
        boolean changed = false;
        HashMap<Long, BlockEntity> newAttachedBlocks = new HashMap<Long, BlockEntity>();
        int radius = (Integer)CommonConfig.GENERAL.t3_scan_radius.get();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos checkPos;
                    BlockEntity be;
                    if (x == 0 && y == 0 && z == 0 || (be = WorldUtil.getBlockEntity(checkPos = this.getBlockPos().offset(x, y, z), (ServerLevel)this.level)) == null || (!this.getWhiteList().isEmpty() ? !this.getWhiteList().contains(this.getBlockName(be)) : this.getBlackList().contains(this.getBlockName(be)))) continue;
                    long posKey = checkPos.asLong();
                    newAttachedBlocks.put(posKey, be);
                    if (this.boostFlags.containsKey(posKey)) continue;
                    this.boostFlags.put(posKey, false);
                }
            }
        }
        if (newAttachedBlocks.size() != this.attachedBlocks.size()) {
            changed = true;
        } else {
            for (Long key2 : newAttachedBlocks.keySet()) {
                if (this.attachedBlocks.containsKey(key2) && ((BlockEntity)this.attachedBlocks.get(key2)).equals(newAttachedBlocks.get(key2))) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.attachedBlocks = newAttachedBlocks;
            for (Long key3 : this.attachedBlocks.keySet()) {
                if (!this.boostFlags.containsKey(key3)) {
                    this.boostFlags.put(key3, false);
                }
                if (this.boostTimes.containsKey(key3)) continue;
                this.boostTimes.put(key3, 0L);
            }
            this.boostFlags.keySet().removeIf(key -> !this.attachedBlocks.containsKey(key));
            this.boostTimes.keySet().removeIf(key -> !this.attachedBlocks.containsKey(key));
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Override
    protected boolean canBoost() {
        return this.getEnergy() >= this.fePerTick;
    }

    @Override
    protected int getBoostRate() {
        return (Integer)CommonConfig.GENERAL.t3_boost_rate.get();
    }

    @Override
    protected void consumeResource() {
        this.consumeEnergy(this.fePerTick);
    }

    @Override
    protected void saveBoosterData(CompoundTag tag) {
        tag.putInt("Energy", this.energy.getEnergyStored());
        ListTag flagsList = new ListTag();
        for (Long key : this.boostFlags.keySet()) {
            CompoundTag flagTag = new CompoundTag();
            flagTag.putLong("posKey", key.longValue());
            flagTag.putBoolean("enabled", ((Boolean)this.boostFlags.get(key)).booleanValue());
            flagsList.add((Object)flagTag);
        }
        tag.put("boostFlags", (Tag)flagsList);
        ListTag timesList = new ListTag();
        for (Long key : this.boostTimes.keySet()) {
            CompoundTag timeTag = new CompoundTag();
            timeTag.putLong("posKey", key.longValue());
            timeTag.putLong("time", ((Long)this.boostTimes.get(key)).longValue());
            timesList.add((Object)timeTag);
        }
        tag.put("boostTimes", (Tag)timesList);
    }

    @Override
    protected void loadBoosterData(CompoundTag tag) {
        long key;
        int i;
        if (tag.contains("Energy")) {
            this.energy.setEnergy(tag.getInt("Energy"));
        }
        if (tag.contains("boostFlags")) {
            this.boostFlags.clear();
            ListTag flagsList = tag.getList("boostFlags", 10);
            for (i = 0; i < flagsList.size(); ++i) {
                CompoundTag flagTag = flagsList.getCompound(i);
                key = flagTag.contains("posKey") ? flagTag.getLong("posKey") : (long)flagTag.getInt("index");
                this.boostFlags.put(key, flagTag.getBoolean("enabled"));
            }
        }
        if (tag.contains("boostTimes")) {
            this.boostTimes.clear();
            ListTag timesList = tag.getList("boostTimes", 10);
            for (i = 0; i < timesList.size(); ++i) {
                CompoundTag timeTag = timesList.getCompound(i);
                key = timeTag.contains("posKey") ? timeTag.getLong("posKey") : (long)timeTag.getInt("index");
                this.boostTimes.put(key, timeTag.getLong("time"));
            }
        }
    }

    public int getEnergy() {
        return this.energy.getEnergyStored();
    }

    public void consumeEnergy(int amount) {
        this.energy.consumeEnergy(amount);
    }

    public int getMaxEnergy() {
        return (Integer)CommonConfig.GENERAL.t3_fe_per_tick.get() * 100;
    }

    private CustomEnergyStorage createEnergyStorage() {
        return new CustomEnergyStorage(this.getMaxEnergy(), this.getMaxEnergy()){

            @Override
            public int receiveEnergy(int maxReceive, boolean simulate) {
                int rc = super.receiveEnergy(maxReceive, simulate);
                if (rc > 0 && !simulate) {
                    TileBoosterT3.this.setChanged();
                }
                return rc;
            }
        };
    }

    @Override
    public boolean isIndexEnabled(long posKey) {
        return this.boostFlags.getOrDefault(posKey, false);
    }

    @Override
    public void setIndexStatus(long posKey, boolean status) {
        this.boostFlags.put(posKey, status);
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public HashMap<Long, Long> getBoostTimes() {
        return this.boostTimes;
    }

    public boolean isSlowBlock(long posKey) {
        Long boostTime = (Long)this.boostTimes.get(posKey);
        if (boostTime == null) {
            return false;
        }
        return boostTime > (Long)CommonConfig.GENERAL.slow_block_threshold_ns.get();
    }
}

