/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.util;

import igentuman.blockbooster.config.CommonConfig;
import igentuman.blockbooster.util.BlockEntityTickDataAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlockEntityLookTracker {
    private static final Map<UUID, BlockPos> playerLastLookedAt = new HashMap<UUID, BlockPos>();
    private static final double SLOW_BLOCK_ENTITY_THRESHOLD = (double)((Long)CommonConfig.GENERAL.slow_block_threshold_ns.get()).longValue() / 1000000.0;
    private static final double MAX_REACH_DISTANCE = 20.0;

    public static void updatePlayerLook(ServerPlayer player) {
        if (player == null || player.level() == null) {
            return;
        }
        UUID playerId = player.getUUID();
        BlockPos lookedAtPos = BlockEntityLookTracker.getBlockEntityPlayerIsLookingAt(player);
        BlockPos lastLookedAt = playerLastLookedAt.get(playerId);
        if (lookedAtPos != null && !lookedAtPos.equals((Object)lastLookedAt)) {
            playerLastLookedAt.put(playerId, lookedAtPos);
            BlockEntity blockEntity = player.level().getBlockEntity(lookedAtPos);
            if (blockEntity != null) {
                BlockEntityLookTracker.checkAndDisplayBlockEntityInfo(player, blockEntity, lookedAtPos);
            }
        } else if (lookedAtPos == null && lastLookedAt != null) {
            playerLastLookedAt.remove(playerId);
            BlockEntityLookTracker.clearPlayerTitle(player);
        }
    }

    private static BlockPos getBlockEntityPlayerIsLookingAt(ServerPlayer player) {
        Vec3 eyePosition = player.getEyePosition(1.0f);
        Vec3 lookVector = player.getViewVector(1.0f);
        Vec3 reachVector = eyePosition.add(lookVector.scale(20.0));
        BlockHitResult hitResult = player.level().clip(new ClipContext(eyePosition, reachVector, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            BlockPos pos = hitResult.getBlockPos();
            if (player.level().getBlockEntity(pos) != null) {
                return pos;
            }
        }
        return null;
    }

    private static void checkAndDisplayBlockEntityInfo(ServerPlayer player, BlockEntity blockEntity, BlockPos pos) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        try {
            LevelChunk chunk = serverLevel.getChunkAt(pos);
            BlockEntityTickDataAccessor tickData = BlockEntityLookTracker.findTickingBlockEntityData(chunk, blockEntity);
            if (tickData != null) {
                double avgTickTime = tickData.world_balance$getAvgTickTime();
                long tickCount = tickData.world_balance$getTickCount();
                if (tickCount > 0L) {
                    boolean isSlow = avgTickTime > SLOW_BLOCK_ENTITY_THRESHOLD;
                    BlockEntityLookTracker.displayBlockEntityInfo(player, blockEntity, avgTickTime, tickCount, isSlow);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static BlockEntityTickDataAccessor findTickingBlockEntityData(LevelChunk chunk, BlockEntity targetBlockEntity) {
        return null;
    }

    private static void displayBlockEntityInfo(ServerPlayer player, BlockEntity blockEntity, double avgTickTime, long tickCount, boolean isSlow) {
        String blockName = blockEntity.getBlockState().getBlock().asItem().toString();
        if (blockName.contains(":")) {
            blockName = blockName.substring(blockName.lastIndexOf(":") + 1);
        }
        if (isSlow) {
            MutableComponent message = Component.literal((String)String.format("\u00a7c\u26a0 %s \u00a77- \u00a7c%.2fms", blockName, avgTickTime));
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    private static void clearPlayerTitle(ServerPlayer player) {
        player.connection.send((Packet)new ClientboundClearTitlesPacket(false));
    }

    public static void removePlayer(UUID playerId) {
        playerLastLookedAt.remove(playerId);
    }

    public static void clear() {
        playerLastLookedAt.clear();
    }
}

