/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.util;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;

public class BoosterUtil {
    public static HashSet<Block> getBlocksByTagKey(String key) {
        HashSet<Block> tmp = new HashSet<Block>();
        TagKey tag = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.tryParse((String)key));
        BuiltInRegistries.BLOCK.getTag(tag).ifPresent(holders -> {
            for (Holder holder : holders) {
                tmp.add((Block)holder.value());
            }
        });
        return tmp;
    }

    public static boolean BoostBlockEntity(Level level, BlockPos pos, BlockEntity be, int boostRate) {
        if (level == null || be == null || be.isRemoved()) {
            return false;
        }
        BlockEntityTicker ticker = be.getBlockState().getTicker(level, be.getType());
        if (ticker != null) {
            for (int i = 0; i < boostRate; ++i) {
                ticker.tick(level, be.getBlockPos(), be.getBlockState(), be);
            }
            return true;
        }
        return false;
    }

    public static BoostResult BoostBlockEntityWithTiming(Level level, BlockPos pos, BlockEntity be, int boostRate) {
        if (level == null || be == null || be.isRemoved()) {
            return new BoostResult(false, 0L);
        }
        BlockEntityTicker ticker = be.getBlockState().getTicker(level, be.getType());
        if (ticker != null) {
            long startTime = System.nanoTime();
            for (int i = 0; i < boostRate; ++i) {
                ticker.tick(level, be.getBlockPos(), be.getBlockState(), be);
            }
            long endTime = System.nanoTime();
            return new BoostResult(true, endTime - startTime);
        }
        return new BoostResult(false, 0L);
    }

    public static class BoostResult {
        public final boolean success;
        public final long timeNanos;

        public BoostResult(boolean success, long timeNanos) {
            this.success = success;
            this.timeNanos = timeNanos;
        }
    }
}

