/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.util;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber
public class TPSTracker {
    private static final int SAMPLE_SIZE = 20;
    private static long[] tickTimes = new long[20];
    private static int currentIndex = 0;
    private static long lastTickTime = 0L;
    private static double currentTPS = 20.0;

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        long currentTime = System.currentTimeMillis();
        if (lastTickTime > 0L) {
            long tickTime;
            TPSTracker.tickTimes[TPSTracker.currentIndex] = tickTime = currentTime - lastTickTime;
            currentIndex = (currentIndex + 1) % 20;
            long totalTime = 0L;
            for (long time : tickTimes) {
                totalTime += time;
            }
            double averageTickTime = (double)totalTime / 20.0;
            if (averageTickTime > 0.0) {
                currentTPS = Math.min(20.0, 1000.0 / averageTickTime);
            }
        }
        lastTickTime = currentTime;
    }

    public static double getCurrentTPS() {
        return currentTPS;
    }

    public static boolean isTpsAcceptable(double threshold) {
        return currentTPS >= threshold;
    }

    public static void reset() {
        tickTimes = new long[20];
        currentIndex = 0;
        lastTickTime = 0L;
        currentTPS = 20.0;
    }
}

