/*
 * Decompiled with CFR 0.152.
 */
package igentuman.blockbooster.util;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class WorldUtil {
    public static BlockState getBlockState(BlockPos pos, ServerLevel level) {
        int chunkZ;
        if (level == null) {
            return Blocks.AIR.defaultBlockState();
        }
        int chunkX = pos.getX() >> 4;
        ChunkAccess chunk = WorldUtil.getChunk(chunkX, chunkZ = pos.getZ() >> 4, level);
        if (chunk == null) {
            return Blocks.AIR.defaultBlockState();
        }
        int sectionIndex = level.getSectionIndex(pos.getY());
        if (sectionIndex < 0 || sectionIndex >= chunk.getSections().length) {
            return Blocks.AIR.defaultBlockState();
        }
        LevelChunkSection section = chunk.getSections()[sectionIndex];
        if (section == null || section.hasOnlyAir()) {
            return Blocks.AIR.defaultBlockState();
        }
        int localX = pos.getX() & 0xF;
        int localY = pos.getY() & 0xF;
        int localZ = pos.getZ() & 0xF;
        return section.getBlockState(localX, localY, localZ);
    }

    public static BlockEntity getBlockEntity(BlockPos pos, ServerLevel level) {
        int chunkZ;
        if (level == null) {
            return null;
        }
        int chunkX = pos.getX() >> 4;
        ChunkAccess chunk = WorldUtil.getChunk(chunkX, chunkZ = pos.getZ() >> 4, level);
        if (chunk == null) {
            return null;
        }
        return chunk.getBlockEntity(pos);
    }

    public static ChunkAccess getChunk(int chunkX, int chunkZ, ServerLevel level) {
        return level.getChunkSource().getChunk(chunkX, chunkZ, true);
    }
}

