/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.midnightmadness.network;

import java.util.function.Supplier;
import net.mcreator.midnightmadness.MidnightMadnessMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MidnightMadnessModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MidnightMadnessMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        MidnightMadnessMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.souls_left = message.data.souls_left;
                    variables.awakened_dark_crown_curse = message.data.awakened_dark_crown_curse;
                    variables.eternal_devourer_passive = message.data.eternal_devourer_passive;
                    variables.demons_kill_count_player = message.data.demons_kill_count_player;
                    variables.reaper_sences_prey = message.data.reaper_sences_prey;
                    variables.corrupted_gift_received = message.data.corrupted_gift_received;
                    variables.strange_note_given = message.data.strange_note_given;
                    variables.full_moon_demons_kill_count_player = message.data.full_moon_demons_kill_count_player;
                    variables.souls_drop_chance = message.data.souls_drop_chance;
                    variables.awakened_eternal_devourer_active = message.data.awakened_eternal_devourer_active;
                    variables.strange_note2_given = message.data.strange_note2_given;
                    variables.welcoming_msg_cd = message.data.welcoming_msg_cd;
                    variables.strange_note1_given = message.data.strange_note1_given;
                    variables.dreamcatcher_spawned = message.data.dreamcatcher_spawned;
                    variables.corrupted_gift2_received = message.data.corrupted_gift2_received;
                    variables.anniversary_corrupted_gift_received2026 = message.data.anniversary_corrupted_gift_received2026;
                    variables.anniversary_corrupted_gift_received2027 = message.data.anniversary_corrupted_gift_received2027;
                    variables.anniversary_corrupted_gift_received2028 = message.data.anniversary_corrupted_gift_received2028;
                    variables.anniversary_corrupted_gift_received2029 = message.data.anniversary_corrupted_gift_received2029;
                    variables.anniversary_corrupted_gift_received2030 = message.data.anniversary_corrupted_gift_received2030;
                    variables.reaper_activated_message_sent = message.data.reaper_activated_message_sent;
                    variables.dreamcatcher_activated_message_sent = message.data.dreamcatcher_activated_message_sent;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double souls_left = 0.0;
        public boolean awakened_dark_crown_curse = false;
        public boolean eternal_devourer_passive = false;
        public double demons_kill_count_player = 0.0;
        public boolean reaper_sences_prey = false;
        public boolean corrupted_gift_received = false;
        public boolean strange_note_given = false;
        public double full_moon_demons_kill_count_player = 0.0;
        public double souls_drop_chance = 0.06;
        public boolean awakened_eternal_devourer_active = false;
        public boolean strange_note2_given = false;
        public double welcoming_msg_cd = 0.0;
        public boolean strange_note1_given = false;
        public boolean dreamcatcher_spawned = false;
        public boolean corrupted_gift2_received = false;
        public boolean anniversary_corrupted_gift_received2026 = false;
        public boolean anniversary_corrupted_gift_received2027 = false;
        public boolean anniversary_corrupted_gift_received2028 = false;
        public boolean anniversary_corrupted_gift_received2029 = false;
        public boolean anniversary_corrupted_gift_received2030 = false;
        public boolean reaper_activated_message_sent = false;
        public boolean dreamcatcher_activated_message_sent = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MidnightMadnessMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("souls_left", this.souls_left);
            nbt.m_128379_("awakened_dark_crown_curse", this.awakened_dark_crown_curse);
            nbt.m_128379_("eternal_devourer_passive", this.eternal_devourer_passive);
            nbt.m_128347_("demons_kill_count_player", this.demons_kill_count_player);
            nbt.m_128379_("reaper_sences_prey", this.reaper_sences_prey);
            nbt.m_128379_("corrupted_gift_received", this.corrupted_gift_received);
            nbt.m_128379_("strange_note_given", this.strange_note_given);
            nbt.m_128347_("full_moon_demons_kill_count_player", this.full_moon_demons_kill_count_player);
            nbt.m_128347_("souls_drop_chance", this.souls_drop_chance);
            nbt.m_128379_("awakened_eternal_devourer_active", this.awakened_eternal_devourer_active);
            nbt.m_128379_("strange_note2_given", this.strange_note2_given);
            nbt.m_128347_("welcoming_msg_cd", this.welcoming_msg_cd);
            nbt.m_128379_("strange_note1_given", this.strange_note1_given);
            nbt.m_128379_("dreamcatcher_spawned", this.dreamcatcher_spawned);
            nbt.m_128379_("corrupted_gift2_received", this.corrupted_gift2_received);
            nbt.m_128379_("anniversary_corrupted_gift_received2026", this.anniversary_corrupted_gift_received2026);
            nbt.m_128379_("anniversary_corrupted_gift_received2027", this.anniversary_corrupted_gift_received2027);
            nbt.m_128379_("anniversary_corrupted_gift_received2028", this.anniversary_corrupted_gift_received2028);
            nbt.m_128379_("anniversary_corrupted_gift_received2029", this.anniversary_corrupted_gift_received2029);
            nbt.m_128379_("anniversary_corrupted_gift_received2030", this.anniversary_corrupted_gift_received2030);
            nbt.m_128379_("reaper_activated_message_sent", this.reaper_activated_message_sent);
            nbt.m_128379_("dreamcatcher_activated_message_sent", this.dreamcatcher_activated_message_sent);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.souls_left = nbt.m_128459_("souls_left");
            this.awakened_dark_crown_curse = nbt.m_128471_("awakened_dark_crown_curse");
            this.eternal_devourer_passive = nbt.m_128471_("eternal_devourer_passive");
            this.demons_kill_count_player = nbt.m_128459_("demons_kill_count_player");
            this.reaper_sences_prey = nbt.m_128471_("reaper_sences_prey");
            this.corrupted_gift_received = nbt.m_128471_("corrupted_gift_received");
            this.strange_note_given = nbt.m_128471_("strange_note_given");
            this.full_moon_demons_kill_count_player = nbt.m_128459_("full_moon_demons_kill_count_player");
            this.souls_drop_chance = nbt.m_128459_("souls_drop_chance");
            this.awakened_eternal_devourer_active = nbt.m_128471_("awakened_eternal_devourer_active");
            this.strange_note2_given = nbt.m_128471_("strange_note2_given");
            this.welcoming_msg_cd = nbt.m_128459_("welcoming_msg_cd");
            this.strange_note1_given = nbt.m_128471_("strange_note1_given");
            this.dreamcatcher_spawned = nbt.m_128471_("dreamcatcher_spawned");
            this.corrupted_gift2_received = nbt.m_128471_("corrupted_gift2_received");
            this.anniversary_corrupted_gift_received2026 = nbt.m_128471_("anniversary_corrupted_gift_received2026");
            this.anniversary_corrupted_gift_received2027 = nbt.m_128471_("anniversary_corrupted_gift_received2027");
            this.anniversary_corrupted_gift_received2028 = nbt.m_128471_("anniversary_corrupted_gift_received2028");
            this.anniversary_corrupted_gift_received2029 = nbt.m_128471_("anniversary_corrupted_gift_received2029");
            this.anniversary_corrupted_gift_received2030 = nbt.m_128471_("anniversary_corrupted_gift_received2030");
            this.reaper_activated_message_sent = nbt.m_128471_("reaper_activated_message_sent");
            this.dreamcatcher_activated_message_sent = nbt.m_128471_("dreamcatcher_activated_message_sent");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("midnight_madness", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "midnight_madness_mapvars";
        public double demons_kill_count = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.demons_kill_count = nbt.m_128459_("demons_kill_count");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("demons_kill_count", this.demons_kill_count);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                MidnightMadnessMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "midnight_madness_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                MidnightMadnessMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.souls_left = original.souls_left;
            clone.awakened_dark_crown_curse = original.awakened_dark_crown_curse;
            clone.demons_kill_count_player = original.demons_kill_count_player;
            clone.corrupted_gift_received = original.corrupted_gift_received;
            clone.strange_note_given = original.strange_note_given;
            clone.full_moon_demons_kill_count_player = original.full_moon_demons_kill_count_player;
            clone.strange_note2_given = original.strange_note2_given;
            clone.welcoming_msg_cd = original.welcoming_msg_cd;
            clone.strange_note1_given = original.strange_note1_given;
            clone.dreamcatcher_spawned = original.dreamcatcher_spawned;
            clone.corrupted_gift2_received = original.corrupted_gift2_received;
            clone.anniversary_corrupted_gift_received2026 = original.anniversary_corrupted_gift_received2026;
            clone.anniversary_corrupted_gift_received2027 = original.anniversary_corrupted_gift_received2027;
            clone.anniversary_corrupted_gift_received2028 = original.anniversary_corrupted_gift_received2028;
            clone.anniversary_corrupted_gift_received2029 = original.anniversary_corrupted_gift_received2029;
            clone.anniversary_corrupted_gift_received2030 = original.anniversary_corrupted_gift_received2030;
            clone.reaper_activated_message_sent = original.reaper_activated_message_sent;
            clone.dreamcatcher_activated_message_sent = original.dreamcatcher_activated_message_sent;
            if (!event.isWasDeath()) {
                clone.eternal_devourer_passive = original.eternal_devourer_passive;
                clone.reaper_sences_prey = original.reaper_sences_prey;
                clone.souls_drop_chance = original.souls_drop_chance;
                clone.awakened_eternal_devourer_active = original.awakened_eternal_devourer_active;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    MidnightMadnessMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    MidnightMadnessMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                MidnightMadnessMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

