/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.replay.processor;

import com.mojang.authlib.GameProfile;
import java.nio.file.Path;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.senseiwells.replay.ServerReplay;
import me.senseiwells.replay.config.chunk.ChunkAreaConfig;
import me.senseiwells.replay.config.predicates.ReplayPlayerContext;
import net.casual.arcade.events.GlobalEventHandler;
import net.casual.arcade.events.ListenerRegistry;
import net.casual.arcade.events.server.ServerStartEvent;
import net.casual.arcade.events.server.player.PlayerLoginEvent;
import net.casual.arcade.events.threading.ThreadingStrategy;
import net.casual.arcade.events.threading.ThreadingTarget;
import net.casual.arcade.replay.io.ReplayFormat;
import net.casual.arcade.replay.recorder.ReplayRecorder;
import net.casual.arcade.replay.recorder.chunk.ChunkArea;
import net.casual.arcade.replay.recorder.chunk.ReplayChunkRecorder;
import net.casual.arcade.replay.recorder.chunk.ReplayChunkRecorders;
import net.casual.arcade.replay.recorder.player.ReplayPlayerRecorder;
import net.casual.arcade.replay.recorder.player.ReplayPlayerRecorders;
import net.casual.arcade.replay.recorder.settings.RecorderSettings;
import net.casual.arcade.replay.recorder.settings.SimpleRecorderSettings;
import net.casual.arcade.utils.RegistryUtilsKt;
import net.minecraft.class_1923;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lme/senseiwells/replay/processor/AutomaticRecorders;", "", "<init>", "()V", "", "registerEvents$ServerReplay", "registerEvents", "Lnet/minecraft/server/MinecraftServer;", "server", "startChunks", "(Lnet/minecraft/server/MinecraftServer;)V", "Lcom/mojang/authlib/GameProfile;", "profile", "startPlayer", "(Lnet/minecraft/server/MinecraftServer;Lcom/mojang/authlib/GameProfile;)V", "ServerReplay"})
@SourceDebugExtension(value={"SMAP\nAutomaticRecorders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutomaticRecorders.kt\nme/senseiwells/replay/processor/AutomaticRecorders\n+ 2 ListenerRegistry.kt\nnet/casual/arcade/events/ListenerRegistry$Companion\n*L\n1#1,67:1\n104#2,2:68\n104#2,2:70\n*S KotlinDebug\n*F\n+ 1 AutomaticRecorders.kt\nme/senseiwells/replay/processor/AutomaticRecorders\n*L\n20#1:68,2\n25#1:70,2\n*E\n"})
public final class AutomaticRecorders {
    @NotNull
    public static final AutomaticRecorders INSTANCE = new AutomaticRecorders();

    private AutomaticRecorders() {
    }

    public final void registerEvents$ServerReplay() {
        ListenerRegistry $this$register$iv;
        ListenerRegistry.Companion companion = ListenerRegistry.Companion;
        ListenerRegistry listenerRegistry = (ListenerRegistry)GlobalEventHandler.Server;
        Consumer<ServerStartEvent> listener$iv = AutomaticRecorders::registerEvents$lambda$0;
        boolean $i$f$register = false;
        $this$register$iv.register(ServerStartEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv);
        ListenerRegistry.Companion this_$iv = ListenerRegistry.Companion;
        $this$register$iv = (ListenerRegistry)GlobalEventHandler.Server;
        listener$iv = AutomaticRecorders::registerEvents$lambda$1;
        $i$f$register = false;
        $this$register$iv.register(PlayerLoginEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv);
    }

    private final void startChunks(MinecraftServer server) {
        for (ChunkAreaConfig chunks : ServerReplay.getConfig().getChunks()) {
            class_2960 class_29602 = chunks.getDimension();
            class_5321 class_53212 = class_7924.field_41223;
            Intrinsics.checkNotNullExpressionValue((Object)class_53212, (String)"DIMENSION");
            class_5321 dimension = RegistryUtilsKt.toKey((class_2960)class_29602, (class_5321)class_53212);
            class_3218 level = server.method_3847(dimension);
            if (level == null) {
                ServerReplay.logger.warn("Unable to find dimension " + chunks.getDimension() + " for chunk recording");
                continue;
            }
            ChunkArea area = new ChunkArea(level, new class_1923(chunks.getFromX(), chunks.getFromZ()), new class_1923(chunks.getToX(), chunks.getToZ()));
            if (ReplayChunkRecorders.has((String)chunks.getName())) {
                ServerReplay.logger.error("Failed to start chunk recording '" + chunks.getName() + "', it already exists!");
                continue;
            }
            Path path = ServerReplay.getConfig().getChunkRecordingPath().resolve(chunks.getName());
            ReplayFormat format = ServerReplay.getConfig().getDefaultReplayFormat();
            SimpleRecorderSettings settings = ServerReplay.getConfig().createSettings();
            Intrinsics.checkNotNull((Object)path);
            ReplayChunkRecorder recorder = ReplayChunkRecorders.create((ChunkArea)area, (Path)path, (ReplayFormat)format, (RecorderSettings)((RecorderSettings)settings), (String)chunks.getName());
            ReplayRecorder.start$default((ReplayRecorder)((ReplayRecorder)recorder), null, (int)1, null);
        }
    }

    private final void startPlayer(MinecraftServer server, GameProfile profile) {
        ReplayPlayerContext context = new ReplayPlayerContext(server, profile, null, 4, null);
        if (ServerReplay.getConfig().getPlayerPredicate().shouldRecord(context)) {
            Path path = ServerReplay.getConfig().getPlayerRecordingLocation(profile);
            ReplayFormat format = ServerReplay.getConfig().getDefaultReplayFormat();
            SimpleRecorderSettings settings = ServerReplay.getConfig().createSettings();
            ReplayPlayerRecorder recorder = ReplayPlayerRecorders.create((MinecraftServer)server, (GameProfile)profile, (Path)path, (ReplayFormat)format, (RecorderSettings)((RecorderSettings)settings));
            ReplayRecorder.onStart$default((ReplayRecorder)((ReplayRecorder)recorder), null, (int)1, null);
            recorder.afterLogin();
        }
    }

    private static final void registerEvents$lambda$0(ServerStartEvent serverStartEvent) {
        Intrinsics.checkNotNullParameter((Object)serverStartEvent, (String)"<destruct>");
        MinecraftServer server = serverStartEvent.component1();
        if (ServerReplay.getConfig().getAutomaticallyRecord()) {
            INSTANCE.startChunks(server);
        }
    }

    private static final void registerEvents$lambda$1(PlayerLoginEvent playerLoginEvent) {
        Intrinsics.checkNotNullParameter((Object)playerLoginEvent, (String)"<destruct>");
        MinecraftServer server = playerLoginEvent.component1();
        GameProfile profile = playerLoginEvent.component2();
        if (ServerReplay.getConfig().getAutomaticallyRecord()) {
            INSTANCE.startPlayer(server, profile);
        }
    }
}

