/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.replay.processor;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import me.senseiwells.replay.ServerReplay;
import net.casual.arcade.commands.CommandUtilsKt;
import net.casual.arcade.commands.hidden.HiddenCommandContext;
import net.casual.arcade.events.GlobalEventHandler;
import net.casual.arcade.events.ListenerRegistry;
import net.casual.arcade.events.threading.ThreadingStrategy;
import net.casual.arcade.events.threading.ThreadingTarget;
import net.casual.arcade.replay.events.ReplayRecorderCloseEvent;
import net.casual.arcade.replay.events.ReplayRecorderDurationLimitEvent;
import net.casual.arcade.replay.events.ReplayRecorderSaveEvent;
import net.casual.arcade.replay.events.ReplayRecorderStartEvent;
import net.casual.arcade.replay.events.chunk.ReplayChunkRecorderLoadedResumeEvent;
import net.casual.arcade.replay.events.chunk.ReplayChunkRecorderUnloadedPauseEvent;
import net.casual.arcade.replay.events.player.ReplayRecorderFileSizeLimitEvent;
import net.casual.arcade.replay.io.ReplayFormat;
import net.casual.arcade.replay.recorder.ReplayRecorder;
import net.casual.arcade.replay.recorder.chunk.ReplayChunkRecorder;
import net.casual.arcade.replay.util.FileUtils;
import net.casual.arcade.replay.util.io.FileSize;
import net.casual.arcade.replay.viewer.ReplayViewers;
import net.casual.arcade.utils.PlayerUtils;
import net.casual.arcade.utils.component.ComponentStylingUtilsKt;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\"\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u001b\u0010'\u001a\u00020\u0004*\u00020$2\u0006\u0010&\u001a\u00020%H\u0002\u00a2\u0006\u0004\b'\u0010(J\u001b\u0010)\u001a\u00020\u0004*\u00020$2\u0006\u0010&\u001a\u00020%H\u0002\u00a2\u0006\u0004\b)\u0010(J\u001b\u0010)\u001a\u00020\u0004*\u00020$2\u0006\u0010&\u001a\u00020*H\u0002\u00a2\u0006\u0004\b)\u0010+\u00a8\u0006,"}, d2={"Lme/senseiwells/replay/processor/RecorderNotifier;", "", "<init>", "()V", "", "registerEvents$ServerReplay", "registerEvents", "Lnet/casual/arcade/replay/events/ReplayRecorderStartEvent;", "event", "onReplayRecorderStart", "(Lnet/casual/arcade/replay/events/ReplayRecorderStartEvent;)V", "Lnet/casual/arcade/replay/events/chunk/ReplayChunkRecorderLoadedResumeEvent;", "onChunkRecorderLoaded", "(Lnet/casual/arcade/replay/events/chunk/ReplayChunkRecorderLoadedResumeEvent;)V", "Lnet/casual/arcade/replay/events/chunk/ReplayChunkRecorderUnloadedPauseEvent;", "onChunkRecorderUnloaded", "(Lnet/casual/arcade/replay/events/chunk/ReplayChunkRecorderUnloadedPauseEvent;)V", "Lnet/casual/arcade/replay/events/ReplayRecorderSaveEvent;", "onReplayRecorderSaving", "(Lnet/casual/arcade/replay/events/ReplayRecorderSaveEvent;)V", "onReplayRecorderSaved", "Lnet/casual/arcade/replay/events/ReplayRecorderCloseEvent;", "onReplayRecorderClose", "(Lnet/casual/arcade/replay/events/ReplayRecorderCloseEvent;)V", "Lnet/casual/arcade/replay/events/ReplayRecorderDurationLimitEvent;", "onReplayRecorderDurationLimit", "(Lnet/casual/arcade/replay/events/ReplayRecorderDurationLimitEvent;)V", "Lnet/casual/arcade/replay/events/player/ReplayRecorderFileSizeLimitEvent;", "onReplayRecorderFileSizeLimit", "(Lnet/casual/arcade/replay/events/player/ReplayRecorderFileSizeLimitEvent;)V", "Lnet/minecraft/class_3222;", "player", "Ljava/nio/file/Path;", "path", "tryViewReplay", "(Lnet/minecraft/class_3222;Ljava/nio/file/Path;)V", "Lnet/minecraft/server/MinecraftServer;", "Lnet/minecraft/class_2561;", "message", "broadcastToOps", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_2561;)V", "broadcastToOpsAndConsole", "", "(Lnet/minecraft/server/MinecraftServer;Ljava/lang/String;)V", "ServerReplay"})
@SourceDebugExtension(value={"SMAP\nRecorderNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecorderNotifier.kt\nme/senseiwells/replay/processor/RecorderNotifier\n+ 2 ListenerRegistry.kt\nnet/casual/arcade/events/ListenerRegistry$Companion\n*L\n1#1,137:1\n104#2,2:138\n104#2,2:140\n104#2,2:142\n84#2,8:144\n84#2,8:152\n104#2,2:160\n104#2,2:162\n104#2,2:164\n*S KotlinDebug\n*F\n+ 1 RecorderNotifier.kt\nme/senseiwells/replay/processor/RecorderNotifier\n*L\n29#1:138,2\n30#1:140,2\n31#1:142,2\n32#1:144,8\n33#1:152,8\n34#1:160,2\n35#1:162,2\n36#1:164,2\n*E\n"})
public final class RecorderNotifier {
    @NotNull
    public static final RecorderNotifier INSTANCE = new RecorderNotifier();

    private RecorderNotifier() {
    }

    public final void registerEvents$ServerReplay() {
        String phase$iv;
        ListenerRegistry $receiver$iv;
        ListenerRegistry $this$register$iv;
        ListenerRegistry.Companion companion = ListenerRegistry.Companion;
        ListenerRegistry listenerRegistry = (ListenerRegistry)GlobalEventHandler.Server;
        Consumer<ReplayRecorderStartEvent> listener$iv = this::onReplayRecorderStart;
        boolean $i$f$register = false;
        $this$register$iv.register(ReplayRecorderStartEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv);
        ListenerRegistry.Companion this_$iv = ListenerRegistry.Companion;
        $this$register$iv = (ListenerRegistry)GlobalEventHandler.Server;
        listener$iv = this::onChunkRecorderLoaded;
        $i$f$register = false;
        $this$register$iv.register(ReplayChunkRecorderLoadedResumeEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv);
        this_$iv = ListenerRegistry.Companion;
        $this$register$iv = (ListenerRegistry)GlobalEventHandler.Server;
        listener$iv = this::onChunkRecorderUnloaded;
        $i$f$register = false;
        $this$register$iv.register(ReplayChunkRecorderUnloadedPauseEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv);
        this_$iv = ListenerRegistry.Companion;
        $this$register$iv = (ListenerRegistry)GlobalEventHandler.Server;
        String $i$f$register2 = "pre";
        Consumer<ReplayRecorderSaveEvent> listener$iv2 = this::onReplayRecorderSaving;
        int priority$iv = 1000;
        ThreadingStrategy strategy$iv = (ThreadingStrategy)ThreadingTarget.Default;
        boolean $i$f$register3 = false;
        $receiver$iv.register(ReplayRecorderSaveEvent.class, priority$iv, phase$iv, strategy$iv, listener$iv2);
        ListenerRegistry.Companion $this$iv = ListenerRegistry.Companion;
        $receiver$iv = (ListenerRegistry)GlobalEventHandler.Server;
        phase$iv = "post";
        listener$iv2 = this::onReplayRecorderSaved;
        priority$iv = 1000;
        strategy$iv = (ThreadingStrategy)ThreadingTarget.Default;
        $i$f$register3 = false;
        $receiver$iv.register(ReplayRecorderSaveEvent.class, priority$iv, phase$iv, strategy$iv, listener$iv2);
        $this$iv = ListenerRegistry.Companion;
        $receiver$iv = (ListenerRegistry)GlobalEventHandler.Server;
        Consumer<ReplayRecorderCloseEvent> listener$iv22 = this::onReplayRecorderClose;
        $i$f$register = false;
        $this$register$iv.register(ReplayRecorderCloseEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv22);
        this_$iv = ListenerRegistry.Companion;
        $this$register$iv = (ListenerRegistry)GlobalEventHandler.Server;
        listener$iv22 = this::onReplayRecorderDurationLimit;
        $i$f$register = false;
        $this$register$iv.register(ReplayRecorderDurationLimitEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv22);
        this_$iv = ListenerRegistry.Companion;
        $this$register$iv = (ListenerRegistry)GlobalEventHandler.Server;
        listener$iv22 = this::onReplayRecorderFileSizeLimit;
        $i$f$register = false;
        $this$register$iv.register(ReplayRecorderFileSizeLimitEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv22);
    }

    private final void onReplayRecorderStart(ReplayRecorderStartEvent event) {
        ReplayRecorder recorder = event.component1();
        ReplayRecorder.StartingMode mode = event.component2();
        this.broadcastToOpsAndConsole(recorder.getServer(), mode.getContinuousVerb() + " replay for " + recorder.getName());
    }

    private final void onChunkRecorderLoaded(ReplayChunkRecorderLoadedResumeEvent event) {
        ReplayChunkRecorder recorder = event.getRecorder();
        if (ServerReplay.getConfig().getNotifyPlayersLoadingChunks()) {
            recorder.ignore(() -> RecorderNotifier.onChunkRecorderLoaded$lambda$0(recorder));
        }
    }

    private final void onChunkRecorderUnloaded(ReplayChunkRecorderUnloadedPauseEvent event) {
        ReplayChunkRecorder recorder = event.getRecorder();
        if (ServerReplay.getConfig().getNotifyPlayersLoadingChunks()) {
            recorder.ignore(() -> RecorderNotifier.onChunkRecorderUnloaded$lambda$1(recorder));
        }
    }

    private final void onReplayRecorderSaving(ReplayRecorderSaveEvent event) {
        ReplayRecorder recorder = event.getRecorder();
        this.broadcastToOpsAndConsole(recorder.getServer(), "Starting to save replay " + recorder.getName() + ", please do not stop the server!");
    }

    private final void onReplayRecorderSaved(ReplayRecorderSaveEvent event) {
        ReplayRecorder recorder = event.getRecorder();
        Path output = event.getOutput();
        class_5250 class_52502 = class_2561.method_43470((String)String.valueOf(output));
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
        class_5250 class_52503 = ComponentStylingUtilsKt.lime((class_5250)class_52502);
        class_5250 class_52504 = class_2561.method_43470((String)"Click to view replay");
        Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"literal(...)");
        class_5250 clickable = CommandUtilsKt.singleUseFunction((class_5250)ComponentStylingUtilsKt.hover((class_5250)class_52503, (class_2561)((class_2561)class_52504)), arg_0 -> RecorderNotifier.onReplayRecorderSaved$lambda$2(output, arg_0));
        class_5250 message = class_2561.method_43473().method_27693("Successfully saved replay " + recorder.getName() + " to ").method_10852((class_2561)clickable).method_27693(", compressed to " + FileUtils.INSTANCE.formatSize(Files.size(event.getOutput())));
        MinecraftServer minecraftServer = recorder.getServer();
        Intrinsics.checkNotNull((Object)message);
        this.broadcastToOpsAndConsole(minecraftServer, (class_2561)message);
    }

    private final void onReplayRecorderClose(ReplayRecorderCloseEvent event) {
        ReplayRecorder recorder = event.getRecorder();
        this.broadcastToOpsAndConsole(recorder.getServer(), "Successfully closed replay " + recorder.getName());
    }

    private final void onReplayRecorderDurationLimit(ReplayRecorderDurationLimitEvent event) {
        ReplayRecorder recorder = event.getRecorder();
        long limit = recorder.getSettings().getLimits().getMaxDuration-UwyO8pc();
        this.broadcastToOpsAndConsole(recorder.getServer(), "Stopped recording replay " + recorder.getName() + ", past duration limit " + Duration.toString-impl((long)limit));
    }

    private final void onReplayRecorderFileSizeLimit(ReplayRecorderFileSizeLimitEvent event) {
        ReplayRecorder recorder = event.getRecorder();
        FileSize limit = recorder.getSettings().getLimits().getMaxRawSize();
        this.broadcastToOpsAndConsole(recorder.getServer(), "Stopped recording replay " + recorder.getName() + ", past raw file size limit " + limit);
    }

    private final void tryViewReplay(class_3222 player, Path path) {
        ReplayFormat format = ReplayFormat.Companion.formatOf(path);
        if (format == null || !Files.isReadable(path)) {
            player.method_64398((class_2561)class_2561.method_43470((String)"Replay is no longer valid for viewing!"));
            return;
        }
        try {
            ReplayViewers.create((Path)path, (class_3222)player).start();
        }
        catch (Exception exception) {
            ServerReplay.logger.error("Failed to start viewing replay at " + path, (Throwable)exception);
        }
    }

    private final void broadcastToOps(MinecraftServer $this$broadcastToOps, class_2561 message) {
        if (ServerReplay.getConfig().getNotifyAdminsOfStatus()) {
            $this$broadcastToOps.execute(() -> RecorderNotifier.broadcastToOps$lambda$3($this$broadcastToOps, message));
        }
    }

    private final void broadcastToOpsAndConsole(MinecraftServer $this$broadcastToOpsAndConsole, class_2561 message) {
        this.broadcastToOps($this$broadcastToOpsAndConsole, message);
        ServerReplay.logger.info(message.getString());
    }

    private final void broadcastToOpsAndConsole(MinecraftServer $this$broadcastToOpsAndConsole, String message) {
        class_5250 class_52502 = class_2561.method_43470((String)message);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
        this.broadcastToOps($this$broadcastToOpsAndConsole, (class_2561)class_52502);
        ServerReplay.logger.info(message);
    }

    private static final Unit onChunkRecorderLoaded$lambda$0(ReplayChunkRecorder $recorder) {
        $recorder.getServer().method_3760().method_43514((class_2561)class_2561.method_43470((String)("Resumed recording for " + $recorder.getName())), false);
        return Unit.INSTANCE;
    }

    private static final Unit onChunkRecorderUnloaded$lambda$1(ReplayChunkRecorder $recorder) {
        $recorder.getServer().method_3760().method_43514((class_2561)class_2561.method_43470((String)("Paused recording for " + $recorder.getName())), false);
        return Unit.INSTANCE;
    }

    private static final void onReplayRecorderSaved$lambda$2(Path $output, HiddenCommandContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.tryViewReplay(it.getPlayer(), $output);
    }

    private static final void broadcastToOps$lambda$3(MinecraftServer $this_broadcastToOps, class_2561 $message) {
        List list = $this_broadcastToOps.method_3760().method_14571();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        PlayerUtils.broadcastToOps$default((Iterable)list, (class_2561)$message, (int)0, (int)2, null);
    }
}

