/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.replay;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.senseiwells.replay.commands.PackCommand;
import me.senseiwells.replay.commands.ReplayCommand;
import me.senseiwells.replay.config.ReplayConfig;
import me.senseiwells.replay.http.DownloadReplaysHttpInjector;
import me.senseiwells.replay.processor.AutomaticRecorders;
import me.senseiwells.replay.processor.RecorderNotifier;
import me.senseiwells.replay.processor.RecorderRecoverer;
import me.senseiwells.replay.processor.RecorderWarner;
import me.senseiwells.replay.processor.ReplayCleanerUpper;
import net.casual.arcade.commands.CommandTree;
import net.casual.arcade.commands.CommandUtilsKt;
import net.casual.arcade.events.GlobalEventHandler;
import net.casual.arcade.events.ListenerRegistry;
import net.casual.arcade.events.server.ServerRegisterCommandEvent;
import net.casual.arcade.events.threading.ThreadingStrategy;
import net.casual.arcade.events.threading.ThreadingTarget;
import net.casual.arcade.replay.events.ReplayRecorderStartEvent;
import net.casual.arcade.replay.recorder.ReplayRecorder;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.mcbrawls.inject.api.Injector;
import net.mcbrawls.inject.fabric.InjectFabric;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\u0003J!\u0010\u000f\u001a\u00020\u00042\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001b\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0016\u001a\u0004\b \u0010!R*\u0010#\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r8\u0006@BX\u0087\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u0012\u0004\b'\u0010\u0003\u001a\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lme/senseiwells/replay/ServerReplay;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "Lnet/minecraft/server/MinecraftServer;", "server", "", "getIp", "(Lnet/minecraft/server/MinecraftServer;)Ljava/lang/String;", "reload", "Lkotlin/Function1;", "Lme/senseiwells/replay/config/ReplayConfig;", "mutator", "updateConfig", "(Lkotlin/jvm/functions/Function1;)V", "Lcom/google/gson/JsonObject;", "data", "addMetadata", "(Lcom/google/gson/JsonObject;)V", "MOD_ID", "Ljava/lang/String;", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "Lnet/fabricmc/loader/api/ModContainer;", "container", "Lnet/fabricmc/loader/api/ModContainer;", "getContainer", "()Lnet/fabricmc/loader/api/ModContainer;", "version", "getVersion", "()Ljava/lang/String;", "value", "config", "Lme/senseiwells/replay/config/ReplayConfig;", "getConfig", "()Lme/senseiwells/replay/config/ReplayConfig;", "getConfig$annotations", "ServerReplay"})
@SourceDebugExtension(value={"SMAP\nServerReplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerReplay.kt\nme/senseiwells/replay/ServerReplay\n+ 2 ListenerRegistry.kt\nnet/casual/arcade/events/ListenerRegistry$Companion\n*L\n1#1,77:1\n104#2,2:78\n104#2,2:80\n*S KotlinDebug\n*F\n+ 1 ServerReplay.kt\nme/senseiwells/replay/ServerReplay\n*L\n46#1:78,2\n52#1:80,2\n*E\n"})
public final class ServerReplay
implements ModInitializer {
    @NotNull
    public static final ServerReplay INSTANCE = new ServerReplay();
    @NotNull
    public static final String MOD_ID = "server-replay";
    @JvmField
    @NotNull
    public static final Logger logger;
    @NotNull
    private static final ModContainer container;
    @NotNull
    private static final String version;
    @NotNull
    private static ReplayConfig config;

    private ServerReplay() {
    }

    @NotNull
    public final ModContainer getContainer() {
        return container;
    }

    @NotNull
    public final String getVersion() {
        return version;
    }

    @NotNull
    public static final ReplayConfig getConfig() {
        return config;
    }

    @JvmStatic
    public static /* synthetic */ void getConfig$annotations() {
    }

    public void onInitialize() {
        ListenerRegistry $this$register$iv;
        ReplayConfig.Companion.migrateOldConfigs$ServerReplay();
        config = ReplayConfig.Companion.read();
        InjectFabric.INSTANCE.registerInjector((Injector)DownloadReplaysHttpInjector.INSTANCE);
        AutomaticRecorders.INSTANCE.registerEvents$ServerReplay();
        RecorderNotifier.INSTANCE.registerEvents$ServerReplay();
        RecorderRecoverer.INSTANCE.registerEvents$ServerReplay();
        ListenerRegistry.Companion companion = ListenerRegistry.Companion;
        ListenerRegistry listenerRegistry = (ListenerRegistry)GlobalEventHandler.Server;
        Consumer<ServerRegisterCommandEvent> listener$iv = ServerReplay::onInitialize$lambda$0;
        boolean $i$f$register = false;
        $this$register$iv.register(ServerRegisterCommandEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv);
        ListenerRegistry.Companion this_$iv = ListenerRegistry.Companion;
        $this$register$iv = (ListenerRegistry)GlobalEventHandler.Server;
        listener$iv = ServerReplay::onInitialize$lambda$1;
        $i$f$register = false;
        $this$register$iv.register(ReplayRecorderStartEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv);
        ReplayCleanerUpper.INSTANCE.run$ServerReplay();
        RecorderWarner.INSTANCE.output$ServerReplay((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)logger){

            public final void invoke(String p0) {
                ((Logger)this.receiver).warn(p0);
            }
        }));
    }

    @NotNull
    public final String getIp(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        String string = config.getReplayServerIp();
        if (string == null) {
            string = "127.0.0.1";
        }
        String ip = string;
        return ip + ":" + server.method_3756();
    }

    public final void reload() {
        config = ReplayConfig.Companion.read();
    }

    public final void updateConfig(@NotNull Function1<? super ReplayConfig, ReplayConfig> mutator) {
        Intrinsics.checkNotNullParameter(mutator, (String)"mutator");
        config = (ReplayConfig)mutator.invoke((Object)config);
        ReplayConfig.Companion.write(config);
    }

    private final void addMetadata(JsonObject data) {
        data.addProperty("server_replay_version", version);
    }

    private static final void onInitialize$lambda$0(ServerRegisterCommandEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CommandTree[] commandTreeArray = new CommandTree[]{ReplayCommand.INSTANCE};
        CommandUtilsKt.register((ServerRegisterCommandEvent)it, (CommandTree[])commandTreeArray);
        if (config.getDebug()) {
            commandTreeArray = new CommandTree[]{PackCommand.INSTANCE};
            CommandUtilsKt.register((ServerRegisterCommandEvent)it, (CommandTree[])commandTreeArray);
        }
    }

    private static final void onInitialize$lambda$1(ReplayRecorderStartEvent replayRecorderStartEvent) {
        Intrinsics.checkNotNullParameter((Object)replayRecorderStartEvent, (String)"<destruct>");
        ReplayRecorder recorder = replayRecorderStartEvent.component1();
        recorder.addMetadataProvider(INSTANCE::addMetadata);
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)MOD_ID);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        ServerReplay.logger = logger;
        Object t = FabricLoader.getInstance().getModContainer(MOD_ID).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        container = (ModContainer)t;
        String string = container.getMetadata().getVersion().getFriendlyString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFriendlyString(...)");
        version = string;
        config = new ReplayConfig(false, null, null, null, null, null, null, null, false, 0L, false, false, 0L, false, 0L, 0, null, false, false, false, false, false, false, false, false, false, false, false, false, false, null, false, false, null, null, -1, 7, null);
    }
}

