/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.replay.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.util.concurrent.Future;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.senseiwells.replay.ServerReplay;
import net.casual.arcade.replay.io.FlashbackIO;
import net.casual.arcade.replay.io.ReplayFormat;
import net.casual.arcade.replay.io.ReplayModIO;
import net.mcbrawls.inject.api.InjectorContext;
import net.mcbrawls.inject.http.HttpByteBuf;
import net.mcbrawls.inject.http.HttpInjector;
import net.mcbrawls.inject.http.HttpRequest;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b \u0010\u001f\u00a8\u0006!"}, d2={"Lme/senseiwells/replay/http/DownloadReplaysHttpInjector;", "Lnet/mcbrawls/inject/http/HttpInjector;", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "path", "createUrl", "(Lnet/minecraft/server/MinecraftServer;Ljava/lang/String;)Ljava/lang/String;", "Lnet/mcbrawls/inject/api/InjectorContext;", "ctx", "Lnet/mcbrawls/inject/http/HttpRequest;", "request", "", "isRelevant", "(Lnet/mcbrawls/inject/api/InjectorContext;Lnet/mcbrawls/inject/http/HttpRequest;)Z", "Lio/netty/channel/ChannelHandlerContext;", "Lio/netty/buffer/ByteBuf;", "buf", "onRead", "(Lio/netty/channel/ChannelHandlerContext;Lio/netty/buffer/ByteBuf;)Z", "Lnet/mcbrawls/inject/http/HttpByteBuf;", "intercept", "(Lio/netty/channel/ChannelHandlerContext;Lnet/mcbrawls/inject/http/HttpRequest;)Lnet/mcbrawls/inject/http/HttpByteBuf;", "prefix", "Ljava/nio/file/Path;", "recordings", "download", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;)Z", "PLAYER", "Ljava/lang/String;", "CHUNK", "ServerReplay"})
public final class DownloadReplaysHttpInjector
extends HttpInjector {
    @NotNull
    public static final DownloadReplaysHttpInjector INSTANCE = new DownloadReplaysHttpInjector();
    @NotNull
    private static final String PLAYER = "/player/";
    @NotNull
    private static final String CHUNK = "/chunk/";

    private DownloadReplaysHttpInjector() {
    }

    @NotNull
    public final String createUrl(@NotNull MinecraftServer server, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return "http://" + ServerReplay.INSTANCE.getIp(server) + "/replay/download/" + path;
    }

    public boolean isRelevant(@NotNull InjectorContext ctx, @NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = request.getRequestURI();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
        return StringsKt.startsWith$default((String)string, (String)"/replay/download/", (boolean)false, (int)2, null);
    }

    public boolean onRead(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        if (!ServerReplay.getConfig().getAllowDownloadingReplays()) {
            return super.onRead(ctx, buf);
        }
        HttpRequest request = HttpRequest.parse((ByteBuf)buf);
        String string = URLDecoder.decode(request.getRequestURI(), StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        String path = StringsKt.removePrefix((String)string, (CharSequence)"/replay/download");
        boolean success = StringsKt.startsWith$default((String)path, (String)PLAYER, (boolean)false, (int)2, null) ? this.download(ctx, path, PLAYER, ServerReplay.getConfig().getPlayerRecordingPath()) : (StringsKt.startsWith$default((String)path, (String)CHUNK, (boolean)false, (int)2, null) ? this.download(ctx, path, CHUNK, ServerReplay.getConfig().getChunkRecordingPath()) : false);
        return success || super.onRead(ctx, buf);
    }

    @NotNull
    public HttpByteBuf intercept(@NotNull ChannelHandlerContext ctx, @NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HttpByteBuf buf = HttpByteBuf.httpBuf((ChannelHandlerContext)ctx);
        if (!ServerReplay.getConfig().getAllowDownloadingReplays()) {
            buf.writeStatusLine("1.1", 403, "Forbidden");
        } else {
            buf.writeStatusLine("1.1", 404, "Not Found");
        }
        Intrinsics.checkNotNull((Object)buf);
        return buf;
    }

    private final boolean download(ChannelHandlerContext ctx, String path, String prefix, Path recordings) {
        Path recording;
        String name = StringsKt.removePrefix((String)path, (CharSequence)prefix);
        Path path2 = recording = recordings.resolve(name).normalize();
        Intrinsics.checkNotNull((Object)path2);
        ReplayFormat format = ReplayFormat.Companion.formatOf(path2);
        if (format == null) {
            path2 = recording = recordings.resolve(ReplayModIO.INSTANCE.addFileExtension(name)).normalize();
            Intrinsics.checkNotNull((Object)path2);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                recording = recordings.resolve(FlashbackIO.INSTANCE.addFileExtension(name)).normalize();
            }
        }
        path2 = recording;
        Intrinsics.checkNotNull((Object)path2);
        if (!Files.isReadable(path2)) {
            return false;
        }
        Path path3 = recording;
        Intrinsics.checkNotNull((Object)path3);
        long size = Files.size(path3);
        HttpByteBuf buf = HttpByteBuf.httpBuf((ChannelHandlerContext)ctx);
        buf.writeStatusLine("1.1", 200, "OK");
        buf.writeHeader("user-agent", "kotlin/replay-download-host");
        buf.writeHeader("content-length", String.valueOf(size));
        buf.writeHeader("content-type", "application/octet-stream");
        Path path4 = recording;
        Intrinsics.checkNotNull((Object)path4);
        buf.writeHeader("content-disposition", "attachment; filename=\"" + PathsKt.getName((Path)path4) + "\"");
        buf.writeText("");
        ctx.writeAndFlush((Object)buf.inner());
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ};
        FileChannel channel = FileChannel.open(recording, openOptionArray);
        DefaultFileRegion region = new DefaultFileRegion(channel, 0L, size);
        ctx.writeAndFlush((Object)region).addListener(arg_0 -> DownloadReplaysHttpInjector.download$lambda$0(channel, arg_0));
        return true;
    }

    private static final void download$lambda$0(FileChannel $channel, Future it) {
        $channel.close();
    }
}

