/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.replay.processor;

import com.replaymod.replaystudio.PacketData;
import com.replaymod.replaystudio.Studio;
import com.replaymod.replaystudio.io.ReplayInputStream;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.packet.State;
import com.replaymod.replaystudio.lib.viaversion.api.protocol.version.ProtocolVersion;
import com.replaymod.replaystudio.protocol.PacketTypeRegistry;
import com.replaymod.replaystudio.replay.ReplayMetaData;
import com.replaymod.replaystudio.replay.ZipReplayFile;
import com.replaymod.replaystudio.studio.ReplayStudio;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import me.senseiwells.replay.ServerReplay;
import me.senseiwells.replay.config.ReplayConfig;
import me.senseiwells.replay.config.serialization.PathSerializer;
import net.casual.arcade.events.GlobalEventHandler;
import net.casual.arcade.events.ListenerRegistry;
import net.casual.arcade.events.server.ServerStartEvent;
import net.casual.arcade.events.server.ServerStopEvent;
import net.casual.arcade.events.threading.ThreadingStrategy;
import net.casual.arcade.events.threading.ThreadingTarget;
import net.casual.arcade.replay.events.ReplayRecorderStartEvent;
import net.casual.arcade.replay.events.ReplayRecorderStopEvent;
import net.casual.arcade.replay.io.ReplayModIO;
import net.casual.arcade.replay.recorder.ReplayRecorder;
import net.minecraft.class_156;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u0015\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001e\u0010 \u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lme/senseiwells/replay/processor/RecorderRecoverer;", "", "<init>", "()V", "", "registerEvents$ServerReplay", "registerEvents", "Lnet/casual/arcade/replay/recorder/ReplayRecorder;", "recorder", "add", "(Lnet/casual/arcade/replay/recorder/ReplayRecorder;)V", "remove", "Lnet/minecraft/server/MinecraftServer;", "server", "tryRecover", "(Lnet/minecraft/server/MinecraftServer;)V", "waitForRecovering", "Ljava/nio/file/Path;", "recording", "recover", "(Ljava/nio/file/Path;)V", "recoverReplayModReplay", "write", "", "read", "()Ljava/util/Set;", "path", "Ljava/nio/file/Path;", "recordings", "Ljava/util/Set;", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "future", "Ljava/util/concurrent/CompletableFuture;", "ServerReplay"})
@SourceDebugExtension(value={"SMAP\nRecorderRecoverer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecorderRecoverer.kt\nme/senseiwells/replay/processor/RecorderRecoverer\n+ 2 ListenerRegistry.kt\nnet/casual/arcade/events/ListenerRegistry$Companion\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,172:1\n104#2,2:173\n84#2,8:175\n104#2,2:183\n104#2,2:185\n37#3:187\n36#3,3:188\n*S KotlinDebug\n*F\n+ 1 RecorderRecoverer.kt\nme/senseiwells/replay/processor/RecorderRecoverer\n*L\n40#1:173,2\n43#1:175,8\n46#1:183,2\n49#1:185,2\n81#1:187\n81#1:188,3\n*E\n"})
public final class RecorderRecoverer {
    @NotNull
    public static final RecorderRecoverer INSTANCE = new RecorderRecoverer();
    @NotNull
    private static final Path path = ReplayConfig.Companion.resolve("recordings.json");
    @NotNull
    private static final Set<Path> recordings = INSTANCE.read();
    @Nullable
    private static CompletableFuture<Void> future;

    private RecorderRecoverer() {
    }

    /*
     * WARNING - void declaration
     */
    public final void registerEvents$ServerReplay() {
        void phase$iv;
        ListenerRegistry $receiver$iv;
        ListenerRegistry $this$register$iv;
        ListenerRegistry.Companion companion = ListenerRegistry.Companion;
        ListenerRegistry listenerRegistry = (ListenerRegistry)GlobalEventHandler.Server;
        Consumer<ServerStartEvent> listener$iv = RecorderRecoverer::registerEvents$lambda$0;
        boolean $i$f$register22 = false;
        $this$register$iv.register(ServerStartEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv);
        ListenerRegistry.Companion this_$iv = ListenerRegistry.Companion;
        $this$register$iv = (ListenerRegistry)GlobalEventHandler.Server;
        String $i$f$register22 = "post";
        Consumer<ServerStopEvent> listener$iv2 = RecorderRecoverer::registerEvents$lambda$1;
        int priority$iv = 1000;
        ThreadingStrategy strategy$iv = (ThreadingStrategy)ThreadingTarget.Default;
        boolean $i$f$register = false;
        $receiver$iv.register(ServerStopEvent.class, priority$iv, (String)phase$iv, strategy$iv, listener$iv2);
        ListenerRegistry.Companion $this$iv = ListenerRegistry.Companion;
        $receiver$iv = (ListenerRegistry)GlobalEventHandler.Server;
        Consumer<ReplayRecorderStartEvent> listener$iv22 = RecorderRecoverer::registerEvents$lambda$2;
        boolean $i$f$register3 = false;
        $this$register$iv.register(ReplayRecorderStartEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv22);
        this_$iv = ListenerRegistry.Companion;
        $this$register$iv = (ListenerRegistry)GlobalEventHandler.Server;
        listener$iv22 = RecorderRecoverer::registerEvents$lambda$3;
        $i$f$register3 = false;
        $this$register$iv.register(ReplayRecorderStopEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv22);
    }

    private final void add(ReplayRecorder recorder) {
        recordings.add(recorder.getLocation());
        this.write();
    }

    private final void remove(ReplayRecorder recorder) {
        recordings.remove(recorder.getLocation());
        this.write();
    }

    private final void tryRecover(MinecraftServer server) {
        Set<Path> recorders = recordings;
        if (!ServerReplay.getConfig().getRecoverUnsavedReplays() || recorders.isEmpty()) {
            return;
        }
        String recordings = recorders.size() > 1 ? "recordings" : "recording";
        ServerReplay.logger.info("Detected unfinished replay " + recordings + " that ended abruptly...");
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (Path recording : RecorderRecoverer.recordings) {
            ServerReplay.logger.info("Attempting to recover recording: " + recording + ", please do not stop the server");
            futures.add(CompletableFuture.runAsync(() -> RecorderRecoverer.tryRecover$lambda$4(recording), (Executor)class_156.method_27958()).thenRunAsync(() -> RecorderRecoverer.tryRecover$lambda$5(recording), (Executor)server));
        }
        Collection $this$toTypedArray$iv = futures;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletableFuture<Void> future = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length));
        RecorderRecoverer.future = future;
        future.thenRun(RecorderRecoverer::tryRecover$lambda$6);
    }

    private final void waitForRecovering() {
        CompletableFuture<Void> completableFuture = future;
        if (completableFuture == null) {
            return;
        }
        CompletableFuture<Void> future = completableFuture;
        ServerReplay.logger.warn("Waiting for recordings to be recovered, please do NOT kill the server");
        future.join();
        ServerReplay.logger.info("Finished recovering recordings");
    }

    private final void recover(Path recording) {
        Path temp = recording.getParent().resolve(PathsKt.getName((Path)recording) + ".tmp");
        Intrinsics.checkNotNull((Object)temp);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(temp, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.recoverReplayModReplay(recording);
            return;
        }
        ServerReplay.logger.warn("Failed to recover replay at path: " + recording);
    }

    private final void recoverReplayModReplay(Path recording) {
        ZipReplayFile replay = new ZipReplayFile((Studio)new ReplayStudio(), recording.toFile());
        try {
            ReplayMetaData meta = replay.getMetaData();
            ProtocolVersion protocol = meta.getProtocolVersion();
            PacketTypeRegistry registry = PacketTypeRegistry.get((ProtocolVersion)protocol, (State)State.LOGIN);
            ReplayInputStream data = replay.getPacketData(registry);
            PacketData first = data.readPacket();
            if (first != null) {
                first.release();
                PacketData packet = first;
                while (true) {
                    try {
                        PacketData next = data.readPacket();
                        if (next == null) break;
                        next.release();
                        packet = next;
                    }
                    catch (EOFException e) {
                        // empty catch block
                        break;
                    }
                }
                meta.setDuration((int)packet.getTime());
                replay.writeMetaData(registry, meta);
            }
        }
        catch (IOException e) {
            ServerReplay.logger.error("Failed to update meta for unfinished replay " + recording + ", your recording may be corrupted...", (Throwable)e);
        }
        try {
            replay.saveTo(recording.getParent().resolve(PathsKt.getName((Path)recording) + ".mcpr").toFile());
            replay.close();
            ReplayModIO.INSTANCE.deleteCaches(recording);
            ServerReplay.logger.info("Successfully recovered recording " + recording);
        }
        catch (IOException e) {
            ServerReplay.logger.error("Failed to write unfinished replay " + recording);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void write() {
        try {
            PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable = outputStream;
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                JvmStreamsKt.encodeToStream((Json)((Json)Json.Default), (SerializationStrategy)((SerializationStrategy)BuiltinSerializersKt.SetSerializer((KSerializer)PathSerializer.INSTANCE)), recordings, (OutputStream)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            ServerReplay.logger.error("Failed to write unfinished recorders", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<Path> read() {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return new HashSet();
        }
        try {
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Set set = new HashSet((Collection)JvmStreamsKt.decodeFromStream((Json)((Json)Json.Default), (DeserializationStrategy)((DeserializationStrategy)BuiltinSerializersKt.SetSerializer((KSerializer)PathSerializer.INSTANCE)), (InputStream)it));
                return set;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            ServerReplay.logger.error("Failed to read replay recordings", (Throwable)e);
            return new HashSet();
        }
    }

    private static final void registerEvents$lambda$0(ServerStartEvent serverStartEvent) {
        Intrinsics.checkNotNullParameter((Object)serverStartEvent, (String)"<destruct>");
        MinecraftServer server = serverStartEvent.component1();
        INSTANCE.tryRecover(server);
    }

    private static final void registerEvents$lambda$1(ServerStopEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.waitForRecovering();
    }

    private static final void registerEvents$lambda$2(ReplayRecorderStartEvent replayRecorderStartEvent) {
        Intrinsics.checkNotNullParameter((Object)replayRecorderStartEvent, (String)"<destruct>");
        ReplayRecorder recorder = replayRecorderStartEvent.component1();
        INSTANCE.add(recorder);
    }

    private static final void registerEvents$lambda$3(ReplayRecorderStopEvent replayRecorderStopEvent) {
        Intrinsics.checkNotNullParameter((Object)replayRecorderStopEvent, (String)"<destruct>");
        ReplayRecorder recorder = replayRecorderStopEvent.component1();
        INSTANCE.remove(recorder);
    }

    private static final void tryRecover$lambda$4(Path $recording) {
        INSTANCE.recover($recording);
    }

    private static final void tryRecover$lambda$5(Path $recording) {
        recordings.remove($recording);
        INSTANCE.write();
    }

    private static final void tryRecover$lambda$6() {
        future = null;
    }
}

