/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common.loot.table;

import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.Mekanism;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.block.BlockRadioactiveWasteBarrel;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.item.block.ItemBlockPersonalStorage;
import mekanism.common.lib.frequency.IFrequencyHandler;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.resource.ore.OreBlockType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.util.RegistryUtils;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public abstract class BaseBlockLootTables
extends BlockLootSubProvider {
    private final Set<Block> knownBlocks = new ReferenceOpenHashSet();
    private final Set<Block> toSkip = new ReferenceArraySet();

    protected BaseBlockLootTables(HolderLookup.Provider provider) {
        super(Collections.emptySet(), FeatureFlags.VANILLA_SET, provider);
    }

    protected void add(@NotNull Block block, @NotNull LootTable.Builder table) {
        super.add(block, table);
        this.knownBlocks.add(block);
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    protected void skip(Holder<Block> ... blockProviders) {
        for (Holder<Block> blockProvider : blockProviders) {
            this.toSkip.add((Block)blockProvider.value());
        }
    }

    protected boolean skipBlock(Block block) {
        return this.knownBlocks.contains(block) || this.toSkip.contains(block);
    }

    protected LootTable.Builder createOreDrop(Block block, ItemLike item) {
        return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item.asItem()).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder droppingWithFortuneOrRandomly(Block block, ItemLike item, UniformGenerator range) {
        return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item.asItem()).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)range)).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE)))));
    }

    protected void dropSelf(Collection<? extends Holder<Block>> blockProviders) {
        for (Holder<Block> holder : blockProviders) {
            Block block = (Block)holder.value();
            if (this.skipBlock(block)) continue;
            this.dropSelf(block);
        }
    }

    protected void add(Function<Block, LootTable.Builder> factory, Collection<? extends Holder<Block>> blockProviders) {
        for (Holder<Block> holder : blockProviders) {
            this.add((Block)holder.value(), factory);
        }
    }

    protected void add(Function<Block, LootTable.Builder> factory, Holder<Block> ... blockProviders) {
        for (Holder<Block> blockProvider : blockProviders) {
            this.add((Block)blockProvider.value(), factory);
        }
    }

    protected void add(Function<Block, LootTable.Builder> factory, OreBlockType ... oreTypes) {
        for (OreBlockType oreType : oreTypes) {
            this.add((Block)oreType.stone().value(), factory);
            this.add((Block)oreType.deepslate().value(), factory);
        }
    }

    protected void dropSelfWithContents(Collection<? extends Holder<Block>> blockProviders) {
        for (Holder<Block> holder : blockProviders) {
            Attributes.AttributeInventory attributeInventory;
            TileEntityUpdateable tileEntity;
            List components;
            IFrequencyItem frequencyItem;
            Object frequencyType;
            Item item;
            IFrequencyHandler frequencyHandler;
            Set customFrequencies;
            Block block = (Block)holder.value();
            if (this.skipBlock(block)) continue;
            boolean hasComponents = false;
            CopyComponentsFunction.Builder componentsBuilder = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY);
            boolean hasContents = false;
            ItemStack stack = new ItemStack((ItemLike)block);
            LootPoolSingletonContainer.Builder itemLootPool = LootItem.lootTableItem((ItemLike)block);
            DelayedLootItemBuilder delayedPool = new DelayedLootItemBuilder();
            BlockEntity tile = null;
            if (block instanceof EntityBlock) {
                EntityBlock entityBlock = (EntityBlock)block;
                tile = entityBlock.newBlockEntity(BlockPos.ZERO, block.defaultBlockState());
            }
            if (tile instanceof IFrequencyHandler && !(customFrequencies = (frequencyHandler = (IFrequencyHandler)tile).getFrequencyComponent().getCustomFrequencies()).isEmpty() && (item = stack.getItem()) instanceof IFrequencyItem && !customFrequencies.contains(frequencyType = (frequencyItem = (IFrequencyItem)item).getFrequencyType())) {
                Mekanism.logger.warn("Block missing frequency type '{}' expected by item: {}", (Object)frequencyType.getName(), (Object)RegistryUtils.getName((Holder)block.builtInRegistryHolder()));
            }
            if (tile instanceof TileEntityUpdateable && !(components = (tileEntity = (TileEntityUpdateable)tile).getRemapEntries()).isEmpty()) {
                Set skipTypes = ContainerType.TYPES.stream().map(type -> (DataComponentType)type.getComponentType().get()).collect(Collectors.toSet());
                hasComponents = true;
                components.sort(Comparator.comparing(arg_0 -> ((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE).getKey(arg_0), ResourceLocation::compareNamespaced));
                frequencyType = components.iterator();
                while (frequencyType.hasNext()) {
                    DataComponentType remapEntry = (DataComponentType)frequencyType.next();
                    if (skipTypes.contains(remapEntry)) continue;
                    componentsBuilder.include(remapEntry);
                }
            }
            if (tile instanceof TileEntityMekanism) {
                tileEntity = (TileEntityMekanism)tile;
                if (tileEntity.isNameable()) {
                    itemLootPool.apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY));
                }
                for (ContainerType type2 : ContainerType.TYPES) {
                    List containers = tileEntity.persists(type2) ? type2.getContainers((TileEntityMekanism)tileEntity) : Collections.emptyList();
                    int attachmentContainers = type2.getContainerCount(stack);
                    if (containers.size() == attachmentContainers) {
                        if (containers.isEmpty()) continue;
                        componentsBuilder.include((DataComponentType)type2.getComponentType().get());
                        hasComponents = true;
                        if (type2 == ContainerType.ENERGY || type2 == ContainerType.HEAT) continue;
                        hasContents = true;
                        continue;
                    }
                    if (attachmentContainers == 0) {
                        if (type2 == ContainerType.ITEM && block.asItem() instanceof ItemBlockPersonalStorage) {
                            hasContents = true;
                            continue;
                        }
                        if (type2 == ContainerType.CHEMICAL && block instanceof BlockRadioactiveWasteBarrel) continue;
                        Mekanism.logger.warn("Container type: {}, item missing attachments: {}", (Object)type2.getComponentName(), (Object)RegistryUtils.getName((Holder)block.builtInRegistryHolder()));
                        continue;
                    }
                    if (containers.isEmpty()) {
                        Mekanism.logger.warn("Container type: {}, item has attachments but block doesn't have containers: {}", (Object)type2.getComponentName(), (Object)RegistryUtils.getName((Holder)block.builtInRegistryHolder()));
                        continue;
                    }
                    Mekanism.logger.warn("Container type: {}, has {} item attachments and block has {} containers: {}", new Object[]{type2.getComponentName(), attachmentContainers, containers.size(), RegistryUtils.getName((Holder)block.builtInRegistryHolder())});
                }
            }
            if ((attributeInventory = (Attributes.AttributeInventory)Attribute.get((Block)block, Attributes.AttributeInventory.class)) != null) {
                hasContents |= attributeInventory.applyLoot((ConditionUserBuilder)delayedPool);
            }
            if (hasComponents) {
                itemLootPool.apply((LootItemFunction.Builder)componentsBuilder);
            }
            for (LootItemFunction.Builder function : delayedPool.functions) {
                itemLootPool.apply(function);
            }
            for (LootItemCondition.Builder condition : delayedPool.conditions) {
                itemLootPool.when(condition);
            }
            this.add(block, LootTable.lootTable().withPool((LootPool.Builder)BaseBlockLootTables.applyExplosionCondition(hasContents, LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)itemLootPool))));
        }
    }

    private static <T extends ConditionUserBuilder<T>> T applyExplosionCondition(boolean explosionResistant, ConditionUserBuilder<T> condition) {
        return (T)(explosionResistant ? condition.unwrap() : condition.when(ExplosionCondition.survivesExplosion()));
    }

    @NotNull
    protected LootTable.Builder createSlabItemTable(@NotNull Block slab) {
        return LootTable.lootTable().withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)slab, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)slab).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)slab).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE)))))));
    }

    public void dropOther(@NotNull Block block, @NotNull ItemLike drop) {
        this.add(block, this.createSingleItemTable(drop));
    }

    @NotNull
    public LootTable.Builder createSingleItemTable(@NotNull ItemLike item) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition(item, (ConditionUserBuilder)LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item))));
    }

    @NotNull
    protected LootTable.Builder createSingleItemTableWithSilkTouch(@NotNull Block block, @NotNull ItemLike item, @NotNull NumberProvider range) {
        return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)range))));
    }

    @NotNull
    protected LootTable.Builder createSilkTouchDispatchTable(@NotNull Block block, @NotNull LootPoolEntryContainer.Builder<?> builder) {
        return BaseBlockLootTables.createSelfDropDispatchTable(block, this.hasSilkTouch(), builder);
    }

    @NotNull
    protected static LootTable.Builder createSelfDropDispatchTable(@NotNull Block block, @NotNull LootItemCondition.Builder conditionBuilder, @NotNull LootPoolEntryContainer.Builder<?> entry) {
        return LootTable.lootTable().withPool(LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(conditionBuilder)).otherwise(entry)));
    }

    @NothingNullByDefault
    public static class DelayedLootItemBuilder
    implements ConditionUserBuilder<DelayedLootItemBuilder>,
    FunctionUserBuilder<DelayedLootItemBuilder> {
        private final List<LootItemFunction.Builder> functions = new ArrayList<LootItemFunction.Builder>();
        private final List<LootItemCondition.Builder> conditions = new ArrayList<LootItemCondition.Builder>();

        public DelayedLootItemBuilder apply(LootItemFunction.Builder pFunctionBuilder) {
            this.functions.add(pFunctionBuilder);
            return this;
        }

        public DelayedLootItemBuilder when(LootItemCondition.Builder pConditionBuilder) {
            this.conditions.add(pConditionBuilder);
            return this;
        }

        public DelayedLootItemBuilder unwrap() {
            return this;
        }
    }
}

