/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common.recipe.compat;

import com.jerry.datagen.common.recipe.ISubRecipeProvider;
import java.util.ArrayList;
import mekanism.api.annotations.NothingNullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.conditions.AndCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

@NothingNullByDefault
public abstract class CompatRecipeProvider
implements ISubRecipeProvider {
    protected final String modid;
    protected final ICondition modLoaded;
    protected final ICondition allModsLoaded;

    protected CompatRecipeProvider(String modid, String ... secondaryMods) {
        this.modid = modid;
        this.modLoaded = new ModLoadedCondition(modid);
        if (secondaryMods.length == 0) {
            this.allModsLoaded = this.modLoaded;
        } else {
            ArrayList<Object> combined = new ArrayList<Object>();
            combined.add(this.modLoaded);
            for (String secondaryMod : secondaryMods) {
                combined.add(new ModLoadedCondition(secondaryMod));
            }
            this.allModsLoaded = new AndCondition(combined);
        }
    }

    @Override
    public final void addRecipes(RecipeOutput consumer, HolderLookup.Provider registries) {
        String basePath = this.getBasePath();
        this.registerRecipes(consumer, basePath, registries);
    }

    protected abstract void registerRecipes(RecipeOutput var1, String var2, HolderLookup.Provider var3);

    protected String getBasePath() {
        return "compat/" + this.modid + "/";
    }

    protected ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path);
    }

    protected TagKey<Item> tag(String path) {
        return ItemTags.create((ResourceLocation)this.rl(path));
    }

    protected Holder<Item> foreignItem(HolderLookup.Provider registries, ResourceLocation id) {
        return registries.lookupOrThrow(Registries.ITEM).getOrThrow(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id));
    }

    protected ItemStack foreignItemStack(HolderLookup.Provider registries, ResourceLocation id, int count) {
        return new ItemStack(this.foreignItem(registries, id), count);
    }

    protected ItemStack foreignItemStack(HolderLookup.Provider registries, ResourceLocation id) {
        return this.foreignItemStack(registries, id, 1);
    }
}

