/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common.recipe.imp;

import com.jerry.datagen.common.recipe.BaseRecipeProvider;
import com.jerry.datagen.common.recipe.ISubRecipeProvider;
import com.jerry.datagen.common.recipe.builder.ExtendedShapedRecipeBuilder;
import com.jerry.datagen.common.recipe.builder.MekMMDataShapedRecipeBuilder;
import com.jerry.datagen.common.recipe.compat.IERecipeProvider;
import com.jerry.datagen.common.recipe.compat.MysticalRecipeProvider;
import com.jerry.datagen.common.recipe.imp.AdvancedFactoryRecipeProvider;
import com.jerry.datagen.common.recipe.imp.MMFactoryRecipeProvider;
import com.jerry.datagen.common.recipe.imp.PlantingRecipeProvider;
import com.jerry.datagen.common.recipe.pattern.RecipePattern;
import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.common.registries.MMBlocks;
import com.jerry.mekmm.common.registries.MMItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.tags.MekanismTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

@NothingNullByDefault
public class MoreMachineRecipeProvider
extends BaseRecipeProvider {
    static final char DIAMOND_CHAR = 'D';
    static final char GLASS_CHAR = 'G';
    static final char PERSONAL_STORAGE_CHAR = 'P';
    static final char MIXING_CHAR = 'M';
    static final char ROBIT_CHAR = 'R';
    static final char SORTER_CHAR = 'S';
    static final char TELEPORTATION_CORE_CHAR = 'T';
    static final RecipePattern TIER_PATTERN = RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('I', 'P', 'I'), RecipePattern.TripleLine.of('A', 'C', 'A'));
    static final RecipePattern STORAGE_PATTERN = RecipePattern.createPattern(RecipePattern.TripleLine.of('#', '#', '#'), RecipePattern.TripleLine.of('#', '#', '#'), RecipePattern.TripleLine.of('#', '#', '#'));
    static final RecipePattern TYPED_STORAGE_PATTERN = RecipePattern.createPattern(RecipePattern.TripleLine.of('#', '#', '#'), RecipePattern.TripleLine.of('#', 'P', '#'), RecipePattern.TripleLine.of('#', '#', '#'));
    public static final RecipePattern BASIC_MODULE = RecipePattern.createPattern(RecipePattern.TripleLine.of('A', '#', 'A'), RecipePattern.TripleLine.of('A', 'P', 'A'), RecipePattern.TripleLine.of('H', 'H', 'H'));
    private final List<ISubRecipeProvider> compatProviders = new ArrayList<ISubRecipeProvider>();
    private final Set<String> disabledCompats = new HashSet<String>();

    public MoreMachineRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper existingFileHelper) {
        super(output, provider, existingFileHelper);
        this.checkCompat("mysticalagriculture", MysticalRecipeProvider::new);
        this.checkCompat("immersiveengineering", IERecipeProvider::new);
    }

    private void checkCompat(String modid, Function<String, ISubRecipeProvider> providerCreator) {
        if (ModList.get().isLoaded(modid)) {
            this.compatProviders.add(providerCreator.apply(modid));
        } else {
            this.disabledCompats.add(modid);
        }
    }

    public Set<String> getDisabledCompats() {
        return Collections.unmodifiableSet(this.disabledCompats);
    }

    @Override
    protected void addRecipes(RecipeOutput consumer, HolderLookup.Provider registries) {
        this.addMiscRecipes(consumer);
        this.addGearModuleRecipes(consumer);
        this.addLateGameRecipes(consumer);
        for (ISubRecipeProvider compatProvider : this.compatProviders) {
            compatProvider.addRecipes(consumer, registries);
        }
    }

    @Override
    protected List<ISubRecipeProvider> getSubRecipeProviders() {
        return List.of(new MMFactoryRecipeProvider(), new AdvancedFactoryRecipeProvider(), new PlantingRecipeProvider());
    }

    private void addMiscRecipes(RecipeOutput consumer) {
        MekMMDataShapedRecipeBuilder.shapedRecipe(MMBlocks.RECYCLER).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('O', '#', 'O'), RecipePattern.TripleLine.of('A', 'C', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_ADVANCED).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ADVANCED).key('O', MoreMachineRecipeProvider.osmiumIngot()).key('#', (ItemLike)MekanismBlocks.CRUSHER).build(consumer, Mekmm.rl("recycler"));
        MekMMDataShapedRecipeBuilder.shapedRecipe(MMBlocks.PLANTING_STATION).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('#', 'X', '#'), RecipePattern.TripleLine.of('A', 'C', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_REINFORCED).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ELITE).key('#', (ItemLike)MekanismItems.BIO_FUEL).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("planting_station"));
        MekMMDataShapedRecipeBuilder.shapedRecipe(MMBlocks.CNC_STAMPER).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('#', 'X', '#'), RecipePattern.TripleLine.of('A', 'C', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_BASIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_BASIC).key('#', Ingredient.of((ItemLike[])new ItemLike[]{Items.PISTON, Items.STICKY_PISTON})).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("cnc_stamper"));
        MekMMDataShapedRecipeBuilder.shapedRecipe(MMBlocks.CNC_LATHE).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('#', 'X', '#'), RecipePattern.TripleLine.of('A', 'C', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_BASIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_BASIC).key('#', (ItemLike)MekanismItems.ROBIT).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("cnc_lathe"));
        MekMMDataShapedRecipeBuilder.shapedRecipe(MMBlocks.CNC_ROLLING_MILL).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('S', 'X', 'S'), RecipePattern.TripleLine.of('A', 'C', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_BASIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_BASIC).key('S', (TagKey<Item>)MekanismTags.Items.INGOTS_STEEL).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("cnc_rolling_mill"));
    }

    private void addGearModuleRecipes(RecipeOutput consumer) {
    }

    private void addLateGameRecipes(RecipeOutput consumer) {
        MekMMDataShapedRecipeBuilder.shapedRecipe(MMBlocks.REPLICATOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', '#', 'A'), RecipePattern.TripleLine.of('C', 'X', 'C'), RecipePattern.TripleLine.of('A', 'S', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_ATOMIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ULTIMATE).key('#', (ItemLike)MMItems.UU_MATTER).key('S', (TagKey<Item>)Tags.Items.CHESTS).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("replicator"));
        MekMMDataShapedRecipeBuilder.shapedRecipe(MMBlocks.FLUID_REPLICATOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', '#', 'A'), RecipePattern.TripleLine.of('C', 'X', 'C'), RecipePattern.TripleLine.of('A', 'B', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_ATOMIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ULTIMATE).key('#', (ItemLike)MMItems.UU_MATTER).key('B', (ItemLike)Items.BUCKET).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("fluid_replicator"));
        MekMMDataShapedRecipeBuilder.shapedRecipe(MMBlocks.CHEMICAL_REPLICATOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', '#', 'A'), RecipePattern.TripleLine.of('C', 'X', 'C'), RecipePattern.TripleLine.of('A', 'T', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_ATOMIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ULTIMATE).key('#', (ItemLike)MMItems.UU_MATTER).key('T', (ItemLike)MekanismBlocks.BASIC_CHEMICAL_TANK).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("chemical_replicator"));
        ExtendedShapedRecipeBuilder.shapedRecipe(MMBlocks.AMBIENT_GAS_COLLECTOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', '#', 'A'), RecipePattern.TripleLine.of('T', 'X', 'T'), RecipePattern.TripleLine.of('O', 'O', 'O'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_ATOMIC).key('#', (ItemLike)MekanismBlocks.ULTIMATE_PRESSURIZED_TUBE).key('T', (ItemLike)MekanismBlocks.ULTIMATE_CHEMICAL_TANK).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).key('O', (TagKey<Item>)((TagKey)MekanismTags.Items.PROCESSED_RESOURCE_BLOCKS.get(PrimaryResource.OSMIUM))).build(consumer, Mekmm.rl("ambient_gas_collector"));
    }
}

