/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactory;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactoryType;
import com.jerry.mekaf.common.registries.AFTileEntityTypes;
import com.jerry.mekmm.common.content.blocktype.MMMachine;
import com.jerry.mekmm.common.util.MMEnumUtils;
import java.util.function.LongSupplier;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeHasBounding;
import mekanism.common.block.attribute.AttributeSideConfig;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.blocktype.BlockShapes;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.machine.TileEntityChemicalCrystallizer;
import mekanism.common.tile.machine.TileEntityChemicalDissolutionChamber;
import mekanism.common.tile.machine.TileEntityChemicalInfuser;
import mekanism.common.tile.machine.TileEntityChemicalOxidizer;
import mekanism.common.tile.machine.TileEntityChemicalWasher;
import mekanism.common.tile.machine.TileEntityIsotopicCentrifuge;
import mekanism.common.tile.machine.TileEntityNutritionalLiquifier;
import mekanism.common.tile.machine.TileEntityPressurizedReactionChamber;
import mekanism.common.util.EnumUtils;

public class AFBlockTypes {
    private static final Table<FactoryTier, AdvancedFactoryType, AdvancedFactory<?>> AF_FACTORIES = HashBasedTable.create();
    public static final MMMachine.MMFactoryMachine<TileEntityChemicalOxidizer> CHEMICAL_OXIDIZER = (MMMachine.MMFactoryMachine)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)MMMachine.MMMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.CHEMICAL_OXIDIZER, (ILangEntry)MekanismLang.DESCRIPTION_CHEMICAL_OXIDIZER, AdvancedFactoryType.OXIDIZING).withGui(() -> MekanismContainerTypes.CHEMICAL_OXIDIZER)).withSound(MekanismSounds.CHEMICAL_OXIDIZER)).withEnergyConfig((LongSupplier)MekanismConfig.usage.chemicalOxidizer, (LongSupplier)MekanismConfig.storage.chemicalOxidizer)).with(new Attribute[]{AttributeSideConfig.ADVANCED_ELECTRIC_MACHINE})).withCustomShape(BlockShapes.CHEMICAL_OXIDIZER)).withComputerSupport("chemicalOxidizer")).build();
    public static final MMMachine.MMFactoryMachine<TileEntityChemicalDissolutionChamber> CHEMICAL_DISSOLUTION_CHAMBER = (MMMachine.MMFactoryMachine)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)MMMachine.MMMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.CHEMICAL_DISSOLUTION_CHAMBER, (ILangEntry)MekanismLang.DESCRIPTION_CHEMICAL_DISSOLUTION_CHAMBER, AdvancedFactoryType.DISSOLVING).withGui(() -> MekanismContainerTypes.CHEMICAL_DISSOLUTION_CHAMBER)).withSound(MekanismSounds.CHEMICAL_DISSOLUTION_CHAMBER)).withEnergyConfig((LongSupplier)MekanismConfig.usage.chemicalDissolutionChamber, (LongSupplier)MekanismConfig.storage.chemicalDissolutionChamber)).with(new Attribute[]{AttributeUpgradeSupport.DEFAULT_ADVANCED_MACHINE_UPGRADES})).with(new Attribute[]{AttributeSideConfig.ADVANCED_ELECTRIC_MACHINE})).withCustomShape(BlockShapes.CHEMICAL_DISSOLUTION_CHAMBER)).withComputerSupport("chemicalDissolutionChamber")).build();
    public static final MMMachine.MMFactoryMachine<TileEntityChemicalInfuser> CHEMICAL_INFUSER = (MMMachine.MMFactoryMachine)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)MMMachine.MMMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.CHEMICAL_INFUSER, (ILangEntry)MekanismLang.DESCRIPTION_CHEMICAL_INFUSER, AdvancedFactoryType.CHEMICAL_INFUSING).withGui(() -> MekanismContainerTypes.CHEMICAL_INFUSER)).withSound(MekanismSounds.CHEMICAL_INFUSER)).withEnergyConfig((LongSupplier)MekanismConfig.usage.chemicalInfuser, (LongSupplier)MekanismConfig.storage.chemicalInfuser)).withSideConfig(new TransmissionType[]{TransmissionType.CHEMICAL, TransmissionType.ITEM, TransmissionType.ENERGY})).withCustomShape(BlockShapes.CHEMICAL_INFUSER)).withComputerSupport("chemicalInfuser")).build();
    public static final MMMachine.MMFactoryMachine<TileEntityChemicalWasher> CHEMICAL_WASHER = (MMMachine.MMFactoryMachine)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)MMMachine.MMMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.CHEMICAL_WASHER, (ILangEntry)MekanismLang.DESCRIPTION_CHEMICAL_WASHER, AdvancedFactoryType.WASHING).withGui(() -> MekanismContainerTypes.CHEMICAL_WASHER)).withSound(MekanismSounds.CHEMICAL_WASHER)).withEnergyConfig((LongSupplier)MekanismConfig.usage.chemicalWasher, (LongSupplier)MekanismConfig.storage.chemicalWasher)).withSideConfig(new TransmissionType[]{TransmissionType.CHEMICAL, TransmissionType.FLUID, TransmissionType.ITEM, TransmissionType.ENERGY})).withCustomShape(BlockShapes.CHEMICAL_WASHER)).withComputerSupport("chemicalWasher")).build();
    public static final MMMachine.MMFactoryMachine<TileEntityPressurizedReactionChamber> PRESSURIZED_REACTION_CHAMBER = (MMMachine.MMFactoryMachine)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)MMMachine.MMMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.PRESSURIZED_REACTION_CHAMBER, (ILangEntry)MekanismLang.DESCRIPTION_PRESSURIZED_REACTION_CHAMBER, AdvancedFactoryType.PRESSURISED_REACTING).withGui(() -> MekanismContainerTypes.PRESSURIZED_REACTION_CHAMBER)).withSound(MekanismSounds.PRESSURIZED_REACTION_CHAMBER)).withEnergyConfig((LongSupplier)MekanismConfig.usage.pressurizedReactionBase, (LongSupplier)MekanismConfig.storage.pressurizedReactionBase)).withSideConfig(new TransmissionType[]{TransmissionType.ITEM, TransmissionType.CHEMICAL, TransmissionType.FLUID, TransmissionType.ENERGY})).withCustomShape(BlockShapes.PRESSURIZED_REACTION_CHAMBER)).withComputerSupport("pressurizedReactionChamber")).build();
    public static final MMMachine.MMFactoryMachine<TileEntityChemicalCrystallizer> CHEMICAL_CRYSTALLIZER = (MMMachine.MMFactoryMachine)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)MMMachine.MMMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.CHEMICAL_CRYSTALLIZER, (ILangEntry)MekanismLang.DESCRIPTION_CHEMICAL_CRYSTALLIZER, AdvancedFactoryType.CRYSTALLIZING).withGui(() -> MekanismContainerTypes.CHEMICAL_CRYSTALLIZER)).withSound(MekanismSounds.CHEMICAL_CRYSTALLIZER)).withEnergyConfig((LongSupplier)MekanismConfig.usage.chemicalCrystallizer, (LongSupplier)MekanismConfig.storage.chemicalCrystallizer)).with(new Attribute[]{AttributeSideConfig.ADVANCED_ELECTRIC_MACHINE})).withCustomShape(BlockShapes.CHEMICAL_CRYSTALLIZER)).withComputerSupport("chemicalCrystallizer")).build();
    public static final MMMachine.MMFactoryMachine<TileEntityIsotopicCentrifuge> ISOTOPIC_CENTRIFUGE = (MMMachine.MMFactoryMachine)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)MMMachine.MMMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.ISOTOPIC_CENTRIFUGE, (ILangEntry)MekanismLang.DESCRIPTION_ISOTOPIC_CENTRIFUGE, AdvancedFactoryType.CENTRIFUGING).withGui(() -> MekanismContainerTypes.ISOTOPIC_CENTRIFUGE)).withEnergyConfig((LongSupplier)MekanismConfig.usage.isotopicCentrifuge, (LongSupplier)MekanismConfig.storage.isotopicCentrifuge)).withSideConfig(new TransmissionType[]{TransmissionType.CHEMICAL, TransmissionType.ITEM, TransmissionType.ENERGY})).withSound(MekanismSounds.ISOTOPIC_CENTRIFUGE)).withCustomShape(BlockShapes.ISOTOPIC_CENTRIFUGE)).with(new Attribute[]{AttributeHasBounding.ABOVE_ONLY})).withComputerSupport("isotopicCentrifuge")).build();
    public static final MMMachine.MMFactoryMachine<TileEntityNutritionalLiquifier> NUTRITIONAL_LIQUIFIER = (MMMachine.MMFactoryMachine)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)((MMMachine.MMMachineBuilder)MMMachine.MMMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.NUTRITIONAL_LIQUIFIER, (ILangEntry)MekanismLang.DESCRIPTION_NUTRITIONAL_LIQUIFIER, AdvancedFactoryType.LIQUIFYING).withGui(() -> MekanismContainerTypes.NUTRITIONAL_LIQUIFIER)).withEnergyConfig((LongSupplier)MekanismConfig.usage.nutritionalLiquifier, (LongSupplier)MekanismConfig.storage.nutritionalLiquifier)).withSideConfig(new TransmissionType[]{TransmissionType.ITEM, TransmissionType.FLUID, TransmissionType.ENERGY})).withSound(MekanismSounds.NUTRITIONAL_LIQUIFIER)).withComputerSupport("nutritionalLiquifier")).build();

    private AFBlockTypes() {
    }

    public static AdvancedFactory<?> getAdvancedFactory(FactoryTier tier, AdvancedFactoryType type) {
        return (AdvancedFactory)((Object)AF_FACTORIES.get((Object)tier, (Object)type));
    }

    static {
        for (FactoryTier tier : EnumUtils.FACTORY_TIERS) {
            for (AdvancedFactoryType type : MMEnumUtils.ADVANCED_FACTORY_TYPES) {
                AF_FACTORIES.put((Object)tier, (Object)type, (Object)((AdvancedFactory)AdvancedFactory.AdvancedFactoryBuilder.createAdvancedFactory(() -> AFTileEntityTypes.getAdvancedFactoryTile(tier, type), type, tier).build()));
            }
        }
    }
}

