/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.recipe_viewer.emi;

import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.client.recipe_viewer.MMRecipeViewerRecipeType;
import com.jerry.mekmm.client.recipe_viewer.MMRecipeViewerUtils;
import com.jerry.mekmm.client.recipe_viewer.emi.recipe.ChemicalReplicatorEmiRecipe;
import com.jerry.mekmm.client.recipe_viewer.emi.recipe.FluidReplicatorEmiRecipe;
import com.jerry.mekmm.client.recipe_viewer.emi.recipe.PlantingEmiRecipe;
import com.jerry.mekmm.client.recipe_viewer.emi.recipe.RecyclerEmiRecipe;
import com.jerry.mekmm.client.recipe_viewer.emi.recipe.ReplicatorEmiRecipe;
import com.jerry.mekmm.client.recipe_viewer.emi.recipe.StamperEmiRecipe;
import com.jerry.mekmm.common.MMLang;
import com.jerry.mekmm.common.block.attribute.MMAttributeFactoryType;
import com.jerry.mekmm.common.registries.MMBlocks;
import com.jerry.mekmm.common.registries.MMChemicals;
import com.jerry.mekmm.common.registries.MMItems;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.client.recipe_viewer.emi.ChemicalEmiStack;
import mekanism.client.recipe_viewer.emi.MekanismEmi;
import mekanism.client.recipe_viewer.emi.MekanismEmiRecipeCategory;
import mekanism.client.recipe_viewer.emi.recipe.ItemStackToItemStackEmiRecipe;
import mekanism.client.recipe_viewer.emi.recipe.MekanismEmiRecipe;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.tier.FactoryTier;
import mekanism.common.util.EnumUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@EmiEntrypoint
public class MoreMachineEMI
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        this.addCategories(registry);
        MekanismEmi.registerItemSubtypes((EmiRegistry)registry, (Collection)MMItems.MM_ITEMS.getEntries());
        MekanismEmi.registerItemSubtypes((EmiRegistry)registry, (Collection)MMBlocks.MM_BLOCKS.getSecondaryEntries());
    }

    private void addCategories(EmiRegistry registry) {
        MoreMachineEMI.addCategoryAndRecipes(registry, MMRecipeViewerRecipeType.RECYCLER, RecyclerEmiRecipe::new);
        MoreMachineEMI.addCategoryAndRecipes(registry, MMRecipeViewerRecipeType.PLANTING_STATION, PlantingEmiRecipe::new);
        MoreMachineEMI.addCategoryAndRecipes(registry, MMRecipeViewerRecipeType.REPLICATOR, ReplicatorEmiRecipe::new, MMRecipeViewerUtils.getItemReplicatorRecipes());
        MoreMachineEMI.addCategoryAndRecipes(registry, MMRecipeViewerRecipeType.FLUID_REPLICATOR, FluidReplicatorEmiRecipe::new, MMRecipeViewerUtils.getFluidReplicatorRecipes());
        MoreMachineEMI.addCategoryAndRecipes(registry, MMRecipeViewerRecipeType.CHEMICAL_REPLICATOR, ChemicalReplicatorEmiRecipe::new, MMRecipeViewerUtils.getChemicalReplicatorRecipes());
        MoreMachineEMI.addCategoryAndRecipes(registry, MMRecipeViewerRecipeType.STAMPING, StamperEmiRecipe::new);
        MoreMachineEMI.addCategoryAndRecipes(registry, MMRecipeViewerRecipeType.LATHE, ItemStackToItemStackEmiRecipe::new);
        MoreMachineEMI.addCategoryAndRecipes(registry, MMRecipeViewerRecipeType.ROLLING_MILL, ItemStackToItemStackEmiRecipe::new);
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(new ChemicalEmiStack(MMChemicals.UNSTABLE_DIMENSIONAL_GAS.asStack(1000L))), List.of(MMLang.RECIPE_VIEWER_INFO_UNSTABLE_DIMENSIONAL_GAS.translate()), Mekmm.rl("info/unstable_dimensional_gas")));
    }

    public static <RECIPE extends MekanismRecipe<?>, TYPE extends IRecipeViewerRecipeType<RECIPE> & IMekanismRecipeTypeProvider<?, RECIPE, ?>> void addCategoryAndRecipes(EmiRegistry registry, TYPE recipeType, BiFunction<MekanismEmiRecipeCategory, RecipeHolder<RECIPE>, MekanismEmiRecipe<RECIPE>> recipeCreator) {
        MekanismEmiRecipeCategory category = MoreMachineEMI.addCategory(registry, recipeType);
        for (RecipeHolder recipe : ((IMekanismRecipeTypeProvider<?, RECIPE, ?>)recipeType).getRecipes(registry.getRecipeManager(), null)) {
            registry.addRecipe((EmiRecipe)recipeCreator.apply(category, recipe));
        }
    }

    public static <RECIPE> void addCategoryAndRecipes(EmiRegistry registry, IRecipeViewerRecipeType<RECIPE> recipeType, MekanismEmi.BasicRecipeCreator<RECIPE> recipeCreator, Map<ResourceLocation, RECIPE> recipes) {
        MekanismEmiRecipeCategory category = MoreMachineEMI.addCategory(registry, recipeType);
        for (Map.Entry<ResourceLocation, RECIPE> entry : recipes.entrySet()) {
            registry.addRecipe((EmiRecipe)recipeCreator.create(category, entry.getKey(), entry.getValue()));
        }
    }

    private static MekanismEmiRecipeCategory addCategory(EmiRegistry registry, IRecipeViewerRecipeType<?> recipeType) {
        MekanismEmiRecipeCategory category = MekanismEmiRecipeCategory.create(recipeType);
        registry.addCategory((EmiRecipeCategory)category);
        MoreMachineEMI.addWorkstations(registry, (EmiRecipeCategory)category, recipeType.workstations());
        return category;
    }

    private static void addWorkstations(EmiRegistry registry, EmiRecipeCategory category, List<ItemLike> workstations) {
        for (ItemLike workstation : workstations) {
            BlockItem blockItem;
            MMAttributeFactoryType factoryType;
            Item item = workstation.asItem();
            registry.addWorkstation(category, (EmiIngredient)EmiStack.of((ItemLike)item));
            if (!(item instanceof BlockItem) || (factoryType = (MMAttributeFactoryType)Attribute.get((Block)(blockItem = (BlockItem)item).getBlock(), MMAttributeFactoryType.class)) == null) continue;
            for (FactoryTier tier : EnumUtils.FACTORY_TIERS) {
                registry.addWorkstation(category, (EmiIngredient)EmiStack.of(MMBlocks.getMMFactory(tier, factoryType.getMMFactoryType())));
            }
        }
    }
}

