/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.machine;

import com.jerry.mekmm.api.recipes.basic.MMBasicChemicalChemicalToChemicalRecipe;
import com.jerry.mekmm.api.recipes.cache.ReplicatorCachedRecipe;
import com.jerry.mekmm.client.recipe_viewer.MMRecipeViewerRecipeType;
import com.jerry.mekmm.common.config.MoreMachineConfig;
import com.jerry.mekmm.common.recipe.impl.ChemicalReplicatorIRecipeSingle;
import com.jerry.mekmm.common.registries.MMBlocks;
import com.jerry.mekmm.common.registries.MMChemicals;
import com.jerry.mekmm.common.util.MMUtils;
import com.jerry.mekmm.common.util.ValidatorUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityChemicalReplicator
extends TileEntityProgressMachine<MMBasicChemicalChemicalToChemicalRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    public static final long MAX_GAS = 10000L;
    private static final int BASE_TICKS_REQUIRED = 200;
    public static HashMap<String, Integer> customRecipeMap = ValidatorUtils.getRecipeFromConfig((List)MoreMachineConfig.general.chemicalReplicatorRecipe.get());
    public IChemicalTank firstInputTank;
    public IChemicalTank chemicalOutputTank;
    public IChemicalTank secondaryInputTank;
    private MachineEnergyContainer<TileEntityChemicalReplicator> energyContainer;
    private final ILongInputHandler<@NotNull ChemicalStack> firstInputHandler;
    private final ILongInputHandler<ChemicalStack> secondaryInputHandler;
    private final IOutputHandler<@NotNull ChemicalStack> outputHandler;
    ChemicalInventorySlot firstSlot;
    ChemicalInventorySlot secondarySlot;
    ChemicalInventorySlot outputSlot;
    EnergyInventorySlot energySlot;

    public TileEntityChemicalReplicator(BlockPos pos, BlockState state) {
        super(MMBlocks.CHEMICAL_REPLICATOR, pos, state, TRACKED_ERROR_TYPES, 200);
        this.configComponent.setupItemIOExtraConfig((IInventorySlot)this.firstSlot, (IInventorySlot)this.outputSlot, (IInventorySlot)this.secondarySlot, (IInventorySlot)this.energySlot);
        ConfigInfo fluidConfig = this.configComponent.getConfig(TransmissionType.CHEMICAL);
        if (fluidConfig != null) {
            fluidConfig.addSlotInfo(DataType.INPUT_1, (ISlotInfo)new ChemicalSlotInfo(true, false, new IChemicalTank[]{this.firstInputTank}));
            fluidConfig.addSlotInfo(DataType.INPUT_2, (ISlotInfo)new ChemicalSlotInfo(true, false, new IChemicalTank[]{this.secondaryInputTank}));
            fluidConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new ChemicalSlotInfo(false, true, new IChemicalTank[]{this.chemicalOutputTank}));
        }
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.CHEMICAL, TransmissionType.ITEM}).setCanTankEject(tank -> tank == this.chemicalOutputTank);
        this.firstInputHandler = InputHelper.getInputHandler((IChemicalTank)this.firstInputTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.outputHandler = OutputHelper.getOutputHandler((IChemicalTank)this.chemicalOutputTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
        this.secondaryInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.secondaryInputTank);
    }

    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.firstInputTank = BasicChemicalTank.inputModern((long)10000L, TileEntityChemicalReplicator::isValidInputChemical, (IContentsListener)recipeCacheListener);
        builder.addTank(this.firstInputTank);
        this.secondaryInputTank = BasicChemicalTank.inputModern((long)10000L, TileEntityChemicalReplicator::isValidChemicalInput, (IContentsListener)recipeCacheListener);
        builder.addTank(this.secondaryInputTank);
        this.chemicalOutputTank = BasicChemicalTank.output((long)10000L, (IContentsListener)recipeCacheUnpauseListener);
        builder.addTank(this.chemicalOutputTank);
        return builder.build();
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig((ISideConfiguration)this);
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)recipeCacheUnpauseListener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig((ISideConfiguration)this);
        this.firstSlot = ChemicalInventorySlot.fillOrConvert((IChemicalTank)this.firstInputTank, () -> ((TileEntityChemicalReplicator)this).getLevel(), (IContentsListener)listener, (int)29, (int)65);
        builder.addSlot((IInventorySlot)this.firstSlot);
        this.secondarySlot = ChemicalInventorySlot.fillOrConvert((IChemicalTank)this.secondaryInputTank, () -> ((TileEntityChemicalReplicator)this).getLevel(), (IContentsListener)listener, (int)8, (int)65);
        builder.addSlot((IInventorySlot)this.secondarySlot);
        this.outputSlot = ChemicalInventorySlot.drain((IChemicalTank)this.chemicalOutputTank, (IContentsListener)listener, (int)132, (int)65);
        builder.addSlot((IInventorySlot)this.outputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityChemicalReplicator)this).getLevel(), (IContentsListener)listener, (int)152, (int)65);
        builder.addSlot((IInventorySlot)this.energySlot);
        this.firstSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.secondarySlot.setSlotOverlay(SlotOverlay.MINUS);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    public static boolean isValidInputChemical(ChemicalStack stack) {
        if (customRecipeMap != null) {
            return customRecipeMap.containsKey(Objects.requireNonNull(RegistryUtils.getName((Holder)stack.getChemicalHolder())).toString());
        }
        return false;
    }

    public static boolean isValidChemicalInput(ChemicalStack stack) {
        return stack.is(MMChemicals.UU_MATTER);
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.firstSlot.fillTankOrConvert();
        this.secondarySlot.fillTankOrConvert();
        this.recipeCacheLookupMonitor.updateAndProcess();
        return sendUpdatePacket;
    }

    @Nullable
    public MachineEnergyContainer<TileEntityChemicalReplicator> getEnergyContainer() {
        return this.energyContainer;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<?, MMBasicChemicalChemicalToChemicalRecipe, ?> getRecipeType() {
        return null;
    }

    @Nullable
    public MMBasicChemicalChemicalToChemicalRecipe getRecipe(int cacheIndex) {
        return TileEntityChemicalReplicator.getRecipe((ChemicalStack)this.firstInputHandler.getInput(), (ChemicalStack)this.secondaryInputHandler.getInput());
    }

    @NotNull
    public CachedRecipe<MMBasicChemicalChemicalToChemicalRecipe> createNewCachedRecipe(@NotNull MMBasicChemicalChemicalToChemicalRecipe recipe, int cacheIndex) {
        return ReplicatorCachedRecipe.createChemicalReplicator(recipe, this.recheckAllRecipeErrors, this.firstInputHandler, this.secondaryInputHandler, this.outputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set)x$0)).setCanHolderFunction(() -> ((TileEntityChemicalReplicator)this).canFunction()).setActive(arg_0 -> ((TileEntityChemicalReplicator)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setRequiredTicks(() -> ((TileEntityChemicalReplicator)this).getTicksRequired()).setOnFinish(() -> ((TileEntityChemicalReplicator)this).markForSave()).setOperatingTicksChanged(x$0 -> this.setOperatingTicks(x$0)).setBaselineMaxOperations(() -> ((TileEntityChemicalReplicator)this).getOperationsPerTick());
    }

    @Nullable
    public IRecipeViewerRecipeType<MMBasicChemicalChemicalToChemicalRecipe> recipeViewerType() {
        return MMRecipeViewerRecipeType.CHEMICAL_REPLICATOR;
    }

    public static MMBasicChemicalChemicalToChemicalRecipe getRecipe(ChemicalStack chemicalStack, ChemicalStack UUStack) {
        if (chemicalStack.isEmpty() || UUStack.isEmpty()) {
            return null;
        }
        if (customRecipeMap != null) {
            Holder chemicalHolder = chemicalStack.getChemicalHolder();
            int amount = customRecipeMap.getOrDefault(RegistryUtils.getName((Holder)chemicalHolder).toString(), 0);
            if (amount == 0) {
                return null;
            }
            return new ChemicalReplicatorIRecipeSingle(IngredientCreatorAccess.chemicalStack().fromHolder(chemicalHolder, 1000), IngredientCreatorAccess.chemicalStack().fromHolder(MMChemicals.UU_MATTER, amount), new ChemicalStack(chemicalHolder, 1000L));
        }
        return null;
    }

    public boolean isConfigurationDataCompatible(Block type) {
        return super.isConfigurationDataCompatible(type) || MMUtils.isSameMMTypeFactory((Holder<Block>)this.getBlockHolder(), type);
    }
}

