/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.jerry.datagen.common.loot.MoreMachineLootProvider;
import com.jerry.datagen.common.recipe.impl.MoreMachineRecipeProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="mekmm", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MoreMachineDataGenerator {
    private MoreMachineDataGenerator() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        MoreMachineDataGenerator.bootstrapConfigs("mekanism");
        MoreMachineDataGenerator.bootstrapConfigs("mekmm");
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        MoreMachineDataGenerator.addProvider(gen, event.includeServer(), MoreMachineLootProvider::new);
        MoreMachineRecipeProvider recipeProvider = new MoreMachineRecipeProvider(output, existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)recipeProvider);
    }

    public static <PROVIDER extends DataProvider> void addProvider(DataGenerator gen, boolean run, DataProvider.Factory<PROVIDER> factory) {
        gen.addProvider(run, factory);
    }

    public static void bootstrapConfigs(String modId) {
        ConfigTracker.INSTANCE.configSets().forEach((type, configs) -> {
            for (ModConfig config : configs) {
                if (!config.getModId().equals(modId)) continue;
                CommentedConfig commentedConfig = CommentedConfig.inMemory();
                config.getSpec().correct(commentedConfig);
                config.getSpec().acceptConfig(commentedConfig);
            }
        });
    }

    public static CompletableFuture<?> save(CachedOutput cache, IOConsumer<OutputStream> osConsumer, Path path) {
        return CompletableFuture.runAsync(() -> {
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                 HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)outputStream);){
                osConsumer.accept((OutputStream)hashingOutputStream);
                cache.m_213871_(path, outputStream.toByteArray(), hashingOutputStream.hash());
            }
            catch (IOException ioexception) {
                DataProvider.f_252483_.error("Failed to save file to {}", (Object)path, (Object)ioexception);
            }
        }, Util.m_183991_());
    }

    @FunctionalInterface
    public static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }
}

