/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common.recipe;

import com.jerry.datagen.common.recipe.ISubRecipeProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.DifferenceIngredient;
import net.minecraftforge.common.data.ExistingFileHelper;

@NothingNullByDefault
public abstract class BaseRecipeProvider
extends RecipeProvider {
    private final ExistingFileHelper existingFileHelper;

    protected BaseRecipeProvider(PackOutput output, ExistingFileHelper existingFileHelper, String modId) {
        super(output);
        this.existingFileHelper = existingFileHelper;
    }

    protected final void m_245200_(Consumer<FinishedRecipe> consumer) {
        Consumer<FinishedRecipe> trackingConsumer = consumer.andThen(recipe -> this.existingFileHelper.trackGenerated(recipe.m_6445_(), PackType.SERVER_DATA, ".json", "recipes"));
        this.addRecipes(trackingConsumer);
        this.getSubRecipeProviders().forEach(subRecipeProvider -> subRecipeProvider.addRecipes(trackingConsumer));
    }

    protected abstract void addRecipes(Consumer<FinishedRecipe> var1);

    protected List<ISubRecipeProvider> getSubRecipeProviders() {
        return Collections.emptyList();
    }

    public static Ingredient createIngredient(TagKey<Item> itemTag, ItemLike ... items) {
        return BaseRecipeProvider.createIngredient(Collections.singleton(itemTag), items);
    }

    public static Ingredient createIngredient(Collection<TagKey<Item>> itemTags, ItemLike ... items) {
        return Ingredient.m_43938_(Stream.concat(itemTags.stream().map(Ingredient.TagValue::new), Arrays.stream(items).map(item -> new Ingredient.ItemValue(new ItemStack(item)))));
    }

    @SafeVarargs
    public static Ingredient createIngredient(TagKey<Item> ... tags) {
        return Ingredient.m_43938_(Arrays.stream(tags).map(Ingredient.TagValue::new));
    }

    public static Ingredient difference(TagKey<Item> base, ItemLike subtracted) {
        return DifferenceIngredient.of((Ingredient)Ingredient.m_204132_(base), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{subtracted}));
    }
}

