/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.common.util.RegistryUtils;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class BaseRecipeBuilder<BUILDER extends BaseRecipeBuilder<BUILDER>>
extends MekanismRecipeBuilder<BUILDER> {
    protected final Item result;
    protected final int count;
    private RecipeCategory category = RecipeCategory.MISC;
    @Nullable
    private String group;

    protected BaseRecipeBuilder(RecipeSerializer<?> serializer, ItemLike result, int count) {
        super(RegistryUtils.getName(serializer));
        this.result = result.m_5456_();
        this.count = count;
    }

    private BUILDER self() {
        return (BUILDER)((Object)this);
    }

    public BUILDER group(String group) {
        this.group = group;
        return this.self();
    }

    public BUILDER category(RecipeCategory category) {
        this.category = category;
        return this.self();
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, (ItemLike)this.result);
    }

    protected StringRepresentable determineBookCategory() {
        return switch (this.category) {
            case RecipeCategory.BUILDING_BLOCKS -> CraftingBookCategory.BUILDING;
            case RecipeCategory.TOOLS, RecipeCategory.COMBAT -> CraftingBookCategory.EQUIPMENT;
            case RecipeCategory.REDSTONE -> CraftingBookCategory.REDSTONE;
            default -> CraftingBookCategory.MISC;
        };
    }

    protected abstract class BaseRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected BaseRecipeResult(ResourceLocation id) {
            super((MekanismRecipeBuilder)BaseRecipeBuilder.this, id);
        }

        public void m_7917_(JsonObject json) {
            if (BaseRecipeBuilder.this.group != null && !BaseRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", BaseRecipeBuilder.this.group);
            }
            this.serializeResult(json);
        }

        protected void serializeResult(JsonObject json) {
            StringRepresentable category = BaseRecipeBuilder.this.determineBookCategory();
            if (category != CraftingBookCategory.MISC && category != CookingBookCategory.MISC) {
                json.addProperty("category", category.m_7912_());
            }
            JsonObject jsonResult = new JsonObject();
            jsonResult.addProperty("item", RegistryUtils.getName((Item)BaseRecipeBuilder.this.result).toString());
            if (BaseRecipeBuilder.this.count > 1) {
                jsonResult.addProperty("count", (Number)BaseRecipeBuilder.this.count);
            }
            json.add("result", (JsonElement)jsonResult);
        }
    }
}

