/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jerry.datagen.common.recipe.builder.BaseRecipeBuilder;
import com.jerry.datagen.common.recipe.pattern.RecipePattern;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

@NothingNullByDefault
public class ExtendedShapedRecipeBuilder
extends BaseRecipeBuilder<ExtendedShapedRecipeBuilder> {
    private final Char2ObjectMap<Ingredient> key = new Char2ObjectArrayMap(9);
    private final List<String> pattern = new ArrayList<String>();

    protected ExtendedShapedRecipeBuilder(RecipeSerializer<?> serializer, ItemLike result, int count) {
        super(serializer, result, count);
    }

    private ExtendedShapedRecipeBuilder(ItemLike result, int count) {
        this(RecipeSerializer.f_44076_, result, count);
    }

    public static ExtendedShapedRecipeBuilder shapedRecipe(ItemLike result) {
        return ExtendedShapedRecipeBuilder.shapedRecipe(result, 1);
    }

    public static ExtendedShapedRecipeBuilder shapedRecipe(ItemLike result, int count) {
        return new ExtendedShapedRecipeBuilder(result, count);
    }

    public ExtendedShapedRecipeBuilder pattern(RecipePattern pattern) {
        if (!this.pattern.isEmpty()) {
            throw new IllegalArgumentException("Recipe pattern has already been set!");
        }
        this.pattern.add(pattern.row1);
        if (pattern.row2 != null) {
            this.pattern.add(pattern.row2);
            if (pattern.row3 != null) {
                this.pattern.add(pattern.row3);
            }
        }
        return this;
    }

    public ExtendedShapedRecipeBuilder key(char symbol, TagKey<Item> tag) {
        return this.key(symbol, Ingredient.m_204132_(tag));
    }

    public ExtendedShapedRecipeBuilder key(char symbol, ItemLike item) {
        return this.key(symbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public ExtendedShapedRecipeBuilder key(char symbol, Ingredient ingredient) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, (Object)ingredient);
        return this;
    }

    protected void validate(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        CharOpenHashSet set = new CharOpenHashSet((CharCollection)this.key.keySet());
        set.remove(' ');
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (!this.key.containsKey(c) && c != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c + "'");
                }
                set.remove(c);
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        if (this.pattern.size() == 1 && this.pattern.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + id + " only takes in a single item, and should probably be a shapeless recipe instead");
        }
    }

    protected MekanismRecipeBuilder.RecipeResult getResult(ResourceLocation id) {
        return new Result(id);
    }

    public class Result
    extends BaseRecipeBuilder.BaseRecipeResult {
        protected Result(ResourceLocation id) {
            super(id);
        }

        @Override
        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            JsonArray jsonPattern = new JsonArray();
            for (String s : ExtendedShapedRecipeBuilder.this.pattern) {
                jsonPattern.add(s);
            }
            json.add("pattern", (JsonElement)jsonPattern);
            JsonObject jsonobject = new JsonObject();
            for (Char2ObjectMap.Entry entry : ExtendedShapedRecipeBuilder.this.key.char2ObjectEntrySet()) {
                jsonobject.add(String.valueOf(entry.getCharKey()), ((Ingredient)entry.getValue()).m_43942_());
            }
            json.add("key", (JsonElement)jsonobject);
        }
    }
}

