/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common.recipe.compat;

import com.jerry.datagen.common.recipe.ISubRecipeProvider;
import java.util.function.Consumer;
import mekanism.api.annotations.NothingNullByDefault;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;

@NothingNullByDefault
public abstract class CompatRecipeProvider
implements ISubRecipeProvider {
    protected final String modid;
    protected final ICondition modLoaded;
    protected final ICondition allModsLoaded;

    protected CompatRecipeProvider(String modid, String ... secondaryMods) {
        this.modid = modid;
        this.modLoaded = new ModLoadedCondition(modid);
        if (secondaryMods.length == 0) {
            this.allModsLoaded = this.modLoaded;
        } else {
            ICondition combined = this.modLoaded;
            for (String secondaryMod : secondaryMods) {
                combined = new AndCondition(new ICondition[]{combined, new ModLoadedCondition(secondaryMod)});
            }
            this.allModsLoaded = combined;
        }
    }

    @Override
    public final void addRecipes(Consumer<FinishedRecipe> consumer) {
        this.registerRecipes(consumer, this.getBasePath());
    }

    protected abstract void registerRecipes(Consumer<FinishedRecipe> var1, String var2);

    protected String getBasePath() {
        return "compat/" + this.modid + "/";
    }

    protected ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path);
    }

    protected TagKey<Item> tag(String path) {
        return ItemTags.create((ResourceLocation)this.rl(path));
    }
}

