/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common.recipe.compat;

import com.jerry.datagen.common.recipe.builder.ExtendedShapedRecipeBuilder;
import com.jerry.datagen.common.recipe.builder.MoreMachineDataShapedRecipeBuilder;
import com.jerry.datagen.common.recipe.compat.CompatRecipeProvider;
import com.jerry.datagen.common.recipe.impl.MoreMachineRecipeProvider;
import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.common.block.attribute.AttributeMoreMachineFactoryType;
import com.jerry.mekmm.common.block.prefab.BlockMoreMachineFactoryMachine;
import com.jerry.mekmm.common.content.blocktype.MoreMachineFactoryType;
import com.jerry.mekmm.common.item.block.machine.ItemBlockMoreMachineFactory;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.util.MoreMachineEnumUtils;
import fr.iglee42.evolvedmekanism.registries.EMTags;
import fr.iglee42.evolvedmekanism.tiers.EMFactoryTier;
import java.util.function.Consumer;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.providers.IItemProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ResourceType;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tier.FactoryTier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

@ParametersAreNotNullByDefault
public class EMMoreMachineFactoryRecipeProvider
extends CompatRecipeProvider {
    public EMMoreMachineFactoryRecipeProvider(String modId) {
        super(modId, new String[0]);
    }

    @Override
    protected void registerRecipes(Consumer<FinishedRecipe> consumer, String basePath) {
        basePath = (String)basePath + "factory/";
        String overclockedPath = (String)basePath + "overclocked/";
        String quantumPath = (String)basePath + "quantum/";
        String densePath = (String)basePath + "dense/";
        String multiversalPath = (String)basePath + "multiversal/";
        String creativePath = (String)basePath + "creative/";
        TagKey uraniumIngot = (TagKey)MekanismTags.Items.PROCESSED_RESOURCES.get((Object)ResourceType.INGOT, (Object)PrimaryResource.URANIUM);
        TagKey tinIngot = (TagKey)MekanismTags.Items.PROCESSED_RESOURCES.get((Object)ResourceType.INGOT, (Object)PrimaryResource.TIN);
        for (MoreMachineFactoryType type : MoreMachineEnumUtils.MM_FACTORY_TYPES) {
            BlockRegistryObject<BlockMoreMachineFactoryMachine.BlockMoreMachineFactory<?>, ItemBlockMoreMachineFactory> ultimateFactory = MoreMachineBlocks.getMoreMachineFactory(FactoryTier.ULTIMATE, type);
            BlockRegistryObject<BlockMoreMachineFactoryMachine.BlockMoreMachineFactory<?>, ItemBlockMoreMachineFactory> overclockedFactory = MoreMachineBlocks.getMoreMachineFactory(EMFactoryTier.OVERCLOCKED, type);
            BlockRegistryObject<BlockMoreMachineFactoryMachine.BlockMoreMachineFactory<?>, ItemBlockMoreMachineFactory> quantumFactory = MoreMachineBlocks.getMoreMachineFactory(EMFactoryTier.QUANTUM, type);
            BlockRegistryObject<BlockMoreMachineFactoryMachine.BlockMoreMachineFactory<?>, ItemBlockMoreMachineFactory> denseFactory = MoreMachineBlocks.getMoreMachineFactory(EMFactoryTier.DENSE, type);
            BlockRegistryObject<BlockMoreMachineFactoryMachine.BlockMoreMachineFactory<?>, ItemBlockMoreMachineFactory> multiversalFactory = MoreMachineBlocks.getMoreMachineFactory(EMFactoryTier.MULTIVERSAL, type);
            this.addFactoryRecipe(consumer, overclockedPath, overclockedFactory, (IItemProvider)ultimateFactory, (TagKey<Item>)uraniumIngot, (TagKey<Item>)EMTags.Items.ALLOYS_OVERCLOCKED, (TagKey<Item>)EMTags.Items.CIRCUITS_OVERCLOCKED);
            this.addFactoryRecipe(consumer, quantumPath, quantumFactory, (IItemProvider)overclockedFactory, (TagKey<Item>)tinIngot, (TagKey<Item>)EMTags.Items.ALLOYS_QUANTUM, (TagKey<Item>)EMTags.Items.CIRCUITS_QUANTUM);
            this.addFactoryRecipe(consumer, densePath, denseFactory, (IItemProvider)quantumFactory, (TagKey<Item>)MekanismTags.Items.INGOTS_BRONZE, (TagKey<Item>)EMTags.Items.ALLOYS_DENSE, (TagKey<Item>)EMTags.Items.CIRCUITS_DENSE);
            this.addFactoryRecipe(consumer, multiversalPath, multiversalFactory, (IItemProvider)denseFactory, (TagKey<Item>)Tags.Items.INGOTS_NETHERITE, (TagKey<Item>)EMTags.Items.ALLOYS_MULTIVERSAL, (TagKey<Item>)EMTags.Items.CIRCUITS_MULTIVERSAL);
            this.addFactoryRecipe(consumer, creativePath, MoreMachineBlocks.getMoreMachineFactory(EMFactoryTier.CREATIVE, type), (IItemProvider)multiversalFactory, (TagKey<Item>)Tags.Items.NETHER_STARS, (TagKey<Item>)EMTags.Items.ALLOYS_CREATIVE, (TagKey<Item>)EMTags.Items.CIRCUITS_CREATIVE_FORGE);
        }
    }

    private void addFactoryRecipe(Consumer<FinishedRecipe> consumer, String basePath, BlockRegistryObject<BlockMoreMachineFactoryMachine.BlockMoreMachineFactory<?>, ?> factory, IItemProvider toUpgrade, TagKey<Item> ingotTag, TagKey<Item> alloyTag, TagKey<Item> circuitTag) {
        ((ExtendedShapedRecipeBuilder)MoreMachineDataShapedRecipeBuilder.shapedRecipe(factory).pattern(MoreMachineRecipeProvider.TIER_PATTERN).key('P', (ItemLike)toUpgrade).key('C', circuitTag).key('I', ingotTag).key('A', alloyTag).addCondition(this.modLoaded)).build(consumer, Mekmm.rl(basePath + ((AttributeMoreMachineFactoryType)Attribute.get(factory, AttributeMoreMachineFactoryType.class)).getMoreMachineFactoryType().getRegistryNameComponent()));
    }
}

