/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.common.recipe.impl;

import com.jerry.datagen.common.recipe.BaseRecipeProvider;
import com.jerry.datagen.common.recipe.ISubRecipeProvider;
import com.jerry.datagen.common.recipe.builder.ExtendedShapedRecipeBuilder;
import com.jerry.datagen.common.recipe.builder.MoreMachineDataShapedRecipeBuilder;
import com.jerry.datagen.common.recipe.compat.EMAdvancedFactoryRecipeProvider;
import com.jerry.datagen.common.recipe.compat.EMMoreMachineFactoryRecipeProvider;
import com.jerry.datagen.common.recipe.compat.IERecipeProvider;
import com.jerry.datagen.common.recipe.compat.MysticalRecipeProvider;
import com.jerry.datagen.common.recipe.impl.AdvancedFactoryRecipeProvider;
import com.jerry.datagen.common.recipe.impl.MoreMachineFactoryRecipeProvider;
import com.jerry.datagen.common.recipe.impl.PlantingRecipeProvider;
import com.jerry.datagen.common.recipe.pattern.RecipePattern;
import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.registries.MoreMachineItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ResourceType;
import mekanism.common.tags.MekanismTags;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.ModList;

@NothingNullByDefault
public class MoreMachineRecipeProvider
extends BaseRecipeProvider {
    static final char DIAMOND_CHAR = 'D';
    static final char GLASS_CHAR = 'G';
    static final char PERSONAL_STORAGE_CHAR = 'P';
    static final char MIXING_CHAR = 'M';
    static final char ROBIT_CHAR = 'R';
    static final char SORTER_CHAR = 'S';
    static final char TELEPORTATION_CORE_CHAR = 'T';
    public static final RecipePattern TIER_PATTERN = RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('I', 'P', 'I'), RecipePattern.TripleLine.of('A', 'C', 'A'));
    static final RecipePattern STORAGE_PATTERN = RecipePattern.createPattern(RecipePattern.TripleLine.of('#', '#', '#'), RecipePattern.TripleLine.of('#', '#', '#'), RecipePattern.TripleLine.of('#', '#', '#'));
    static final RecipePattern TYPED_STORAGE_PATTERN = RecipePattern.createPattern(RecipePattern.TripleLine.of('#', '#', '#'), RecipePattern.TripleLine.of('#', 'P', '#'), RecipePattern.TripleLine.of('#', '#', '#'));
    public static final RecipePattern BASIC_MODULE = RecipePattern.createPattern(RecipePattern.TripleLine.of('A', '#', 'A'), RecipePattern.TripleLine.of('A', 'P', 'A'), RecipePattern.TripleLine.of('H', 'H', 'H'));
    private final List<ISubRecipeProvider> compatProviders = new ArrayList<ISubRecipeProvider>();
    private final Set<String> disabledCompats = new HashSet<String>();

    public MoreMachineRecipeProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, existingFileHelper, "mekmm");
        this.checkCompat("mysticalagriculture", MysticalRecipeProvider::new);
        this.checkCompat("immersiveengineering", IERecipeProvider::new);
        this.checkCompat("evolvedmekanism", EMAdvancedFactoryRecipeProvider::new);
        this.checkCompat("evolvedmekanism", EMMoreMachineFactoryRecipeProvider::new);
    }

    private void checkCompat(String modid, Function<String, ISubRecipeProvider> providerCreator) {
        if (ModList.get().isLoaded(modid)) {
            this.compatProviders.add(providerCreator.apply(modid));
        } else {
            this.disabledCompats.add(modid);
        }
    }

    public Set<String> getDisabledCompats() {
        return Collections.unmodifiableSet(this.disabledCompats);
    }

    @Override
    protected void addRecipes(Consumer<FinishedRecipe> consumer) {
        this.addMiscRecipes(consumer);
        this.addGearModuleRecipes(consumer);
        this.addLateGameRecipes(consumer);
        this.compatProviders.forEach(compatProvider -> compatProvider.addRecipes(consumer));
    }

    @Override
    protected List<ISubRecipeProvider> getSubRecipeProviders() {
        return List.of(new MoreMachineFactoryRecipeProvider(), new AdvancedFactoryRecipeProvider(), new PlantingRecipeProvider());
    }

    private void addMiscRecipes(Consumer<FinishedRecipe> consumer) {
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.RECYCLER).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('O', '#', 'O'), RecipePattern.TripleLine.of('A', 'C', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_ADVANCED).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ADVANCED).key('O', (TagKey<Item>)Objects.requireNonNull((TagKey)MekanismTags.Items.PROCESSED_RESOURCES.get((Object)ResourceType.INGOT, (Object)PrimaryResource.OSMIUM))).key('#', (ItemLike)MekanismBlocks.CRUSHER).build(consumer, Mekmm.rl("recycler"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.PLANTING_STATION).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('#', 'X', '#'), RecipePattern.TripleLine.of('A', 'C', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_REINFORCED).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ELITE).key('#', (ItemLike)MekanismItems.BIO_FUEL).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("planting_station"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.CNC_STAMPER).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('#', 'X', '#'), RecipePattern.TripleLine.of('A', 'C', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_BASIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_BASIC).key('#', Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41869_, Items.f_41862_})).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("cnc_stamper"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.CNC_LATHE).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('#', 'X', '#'), RecipePattern.TripleLine.of('A', 'C', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_BASIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_BASIC).key('#', (ItemLike)MekanismItems.ROBIT).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("cnc_lathe"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.CNC_ROLLING_MILL).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', 'C', 'A'), RecipePattern.TripleLine.of('S', 'X', 'S'), RecipePattern.TripleLine.of('A', 'C', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_BASIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_BASIC).key('S', (TagKey<Item>)MekanismTags.Items.INGOTS_STEEL).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("cnc_rolling_mill"));
    }

    private void addGearModuleRecipes(Consumer<FinishedRecipe> consumer) {
    }

    private void addLateGameRecipes(Consumer<FinishedRecipe> consumer) {
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.REPLICATOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', '#', 'A'), RecipePattern.TripleLine.of('C', 'X', 'C'), RecipePattern.TripleLine.of('A', 'S', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_ATOMIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ULTIMATE).key('#', (ItemLike)MoreMachineItems.UU_MATTER).key('S', (TagKey<Item>)Tags.Items.CHESTS).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("replicator"));
        MoreMachineDataShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.FLUID_REPLICATOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', '#', 'A'), RecipePattern.TripleLine.of('C', 'X', 'C'), RecipePattern.TripleLine.of('A', 'B', 'A'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_ATOMIC).key('C', (TagKey<Item>)MekanismTags.Items.CIRCUITS_ULTIMATE).key('#', (ItemLike)MoreMachineItems.UU_MATTER).key('B', (ItemLike)Items.f_42446_).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).build(consumer, Mekmm.rl("fluid_replicator"));
        ExtendedShapedRecipeBuilder.shapedRecipe(MoreMachineBlocks.AMBIENT_GAS_COLLECTOR).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', '#', 'A'), RecipePattern.TripleLine.of('T', 'X', 'T'), RecipePattern.TripleLine.of('O', 'O', 'O'))).key('A', (TagKey<Item>)MekanismTags.Items.ALLOYS_ATOMIC).key('#', (ItemLike)MekanismBlocks.ULTIMATE_PRESSURIZED_TUBE).key('T', (ItemLike)MekanismBlocks.ULTIMATE_CHEMICAL_TANK).key('X', (ItemLike)MekanismBlocks.STEEL_CASING).key('O', (TagKey<Item>)((TagKey)MekanismTags.Items.PROCESSED_RESOURCE_BLOCKS.get(PrimaryResource.OSMIUM))).build(consumer, Mekmm.rl("ambient_gas_collector"));
    }
}

