/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.content.blocktype;

import com.jerry.mekaf.common.block.attribute.AttributeAdvancedFactoryType;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactoryType;
import com.jerry.mekaf.common.registries.AdvancedFactoryBlocks;
import com.jerry.mekaf.common.registries.AdvancedFactoryContainerTypes;
import com.jerry.mekaf.common.tile.base.TileEntityAdvancedFactoryBase;
import com.jerry.mekmm.common.content.blocktype.MoreMachineBlockShapes;
import com.jerry.mekmm.common.content.blocktype.MoreMachineMachine;
import java.util.function.Supplier;
import mekanism.api.text.ILangEntry;
import mekanism.api.tier.ITier;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeParticleFX;
import mekanism.common.block.attribute.AttributeSound;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.AttributeUpgradeable;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tier.FactoryTier;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;

public class AdvancedFactory<TILE extends TileEntityAdvancedFactoryBase<?>>
extends MoreMachineMachine.MoreMachineFactoryMachine<TILE> {
    private final MoreMachineMachine.MoreMachineFactoryMachine<?> origMachine;

    public AdvancedFactory(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, Supplier<ContainerTypeRegistryObject<? extends MekanismContainer>> containerRegistrar, MoreMachineMachine.MoreMachineFactoryMachine<?> origMachine, FactoryTier tier) {
        super(tileEntityRegistrar, (ILangEntry)MekanismLang.DESCRIPTION_FACTORY, origMachine.getAdvancedFactoryType());
        this.origMachine = origMachine;
        this.setMachineData(tier);
        this.add(new Attribute[]{new AttributeGui(containerRegistrar, null), new AttributeTier((ITier)tier)});
        if (tier.ordinal() < EnumUtils.FACTORY_TIERS.length - 1) {
            this.add(new Attribute[]{new AttributeUpgradeable(() -> AdvancedFactoryBlocks.getAdvancedFactory(EnumUtils.FACTORY_TIERS[tier.ordinal() + 1], origMachine.getAdvancedFactoryType()))});
        }
    }

    private void setMachineData(FactoryTier tier) {
        this.setFrom(this.origMachine, new Class[]{AttributeSound.class, AttributeAdvancedFactoryType.class, AttributeUpgradeSupport.class});
        AttributeEnergy origEnergy = (AttributeEnergy)this.origMachine.get(AttributeEnergy.class);
        if (origEnergy != null) {
            Attribute[] attributeArray = new Attribute[1];
            attributeArray[0] = new AttributeEnergy(() -> ((AttributeEnergy)origEnergy).getUsage(), () -> origEnergy.getConfigStorage().max(origEnergy.getUsage()).multiply((long)tier.processes));
            this.add(attributeArray);
        }
    }

    public static class AdvancedFactoryBuilder<FACTORY extends AdvancedFactory<TILE>, TILE extends TileEntityAdvancedFactoryBase<?>, T extends MoreMachineMachine.MoreMachineMachineBuilder<FACTORY, TILE, T>>
    extends BlockTypeTile.BlockTileBuilder<FACTORY, TILE, T> {
        protected AdvancedFactoryBuilder(FACTORY holder) {
            super(holder);
        }

        public static <TILE extends TileEntityAdvancedFactoryBase<?>> AdvancedFactoryBuilder<AdvancedFactory<TILE>, TILE, ?> createAdvancedFactory(Supplier<?> tileEntityRegistrar, AdvancedFactoryType type, FactoryTier tier) {
            AdvancedFactoryBuilder builder = new AdvancedFactoryBuilder(new AdvancedFactory(tileEntityRegistrar, () -> AdvancedFactoryContainerTypes.ADVANCED_FACTORY, type.getBaseMachine(), tier));
            builder.withComputerSupport((ITier)tier, type.getRegistryNameComponentCapitalized() + "Factory");
            builder.withCustomShape(MoreMachineBlockShapes.getShape(tier, type));
            builder.replace(new Attribute[]{new AttributeParticleFX().addDense((ParticleOptions)ParticleTypes.f_123762_, 5, rand -> new Pos3D((double)(rand.m_188501_() * 0.7f - 0.3f), (double)(rand.m_188501_() * 0.1f + 0.7f), (double)(rand.m_188501_() * 0.7f - 0.3f)))});
            return builder;
        }
    }
}

