/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactory;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactoryType;
import com.jerry.mekaf.common.registries.AdvancedFactoryTileEntityTypes;
import com.jerry.mekmm.common.content.blocktype.MoreMachineMachine;
import com.jerry.mekmm.common.util.MoreMachineEnumUtils;
import java.util.EnumSet;
import mekanism.api.Upgrade;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.blocktype.BlockShapes;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.machine.TileEntityChemicalCrystallizer;
import mekanism.common.tile.machine.TileEntityChemicalDissolutionChamber;
import mekanism.common.tile.machine.TileEntityChemicalInfuser;
import mekanism.common.tile.machine.TileEntityChemicalOxidizer;
import mekanism.common.tile.machine.TileEntityChemicalWasher;
import mekanism.common.tile.machine.TileEntityIsotopicCentrifuge;
import mekanism.common.tile.machine.TileEntityNutritionalLiquifier;
import mekanism.common.tile.machine.TileEntityPressurizedReactionChamber;
import mekanism.common.util.EnumUtils;

public class AdvancedFactoryBlockTypes {
    private static final Table<FactoryTier, AdvancedFactoryType, AdvancedFactory<?>> AF_FACTORIES = HashBasedTable.create();
    public static final MoreMachineMachine.MoreMachineFactoryMachine<TileEntityChemicalOxidizer> CHEMICAL_OXIDIZER = (MoreMachineMachine.MoreMachineFactoryMachine)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)MoreMachineMachine.MoreMachineMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.CHEMICAL_OXIDIZER, (ILangEntry)MekanismLang.DESCRIPTION_CHEMICAL_OXIDIZER, AdvancedFactoryType.OXIDIZING).withGui(() -> MekanismContainerTypes.CHEMICAL_OXIDIZER)).withSound(MekanismSounds.CHEMICAL_OXIDIZER)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.oxidationChamber, (FloatingLongSupplier)MekanismConfig.storage.oxidationChamber)).withCustomShape(BlockShapes.CHEMICAL_OXIDIZER)).withComputerSupport("chemicalOxidizer")).build();
    public static final MoreMachineMachine.MoreMachineFactoryMachine<TileEntityChemicalInfuser> CHEMICAL_INFUSER = (MoreMachineMachine.MoreMachineFactoryMachine)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)MoreMachineMachine.MoreMachineMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.CHEMICAL_INFUSER, (ILangEntry)MekanismLang.DESCRIPTION_CHEMICAL_INFUSER, AdvancedFactoryType.CHEMICAL_INFUSING).withGui(() -> MekanismContainerTypes.CHEMICAL_INFUSER)).withSound(MekanismSounds.CHEMICAL_INFUSER)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.chemicalInfuser, (FloatingLongSupplier)MekanismConfig.storage.chemicalInfuser)).withCustomShape(BlockShapes.CHEMICAL_INFUSER)).withComputerSupport("chemicalInfuser")).build();
    public static final MoreMachineMachine.MoreMachineFactoryMachine<TileEntityChemicalDissolutionChamber> CHEMICAL_DISSOLUTION_CHAMBER = (MoreMachineMachine.MoreMachineFactoryMachine)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)MoreMachineMachine.MoreMachineMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.CHEMICAL_DISSOLUTION_CHAMBER, (ILangEntry)MekanismLang.DESCRIPTION_CHEMICAL_DISSOLUTION_CHAMBER, AdvancedFactoryType.DISSOLVING).withGui(() -> MekanismContainerTypes.CHEMICAL_DISSOLUTION_CHAMBER)).withSound(MekanismSounds.CHEMICAL_DISSOLUTION_CHAMBER)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.chemicalDissolutionChamber, (FloatingLongSupplier)MekanismConfig.storage.chemicalDissolutionChamber)).withSupportedUpgrades(EnumSet.of(Upgrade.SPEED, Upgrade.ENERGY, Upgrade.MUFFLING, Upgrade.GAS))).withCustomShape(BlockShapes.CHEMICAL_DISSOLUTION_CHAMBER)).withComputerSupport("chemicalDissolutionChamber")).build();
    public static final MoreMachineMachine.MoreMachineFactoryMachine<TileEntityChemicalWasher> CHEMICAL_WASHER = (MoreMachineMachine.MoreMachineFactoryMachine)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)MoreMachineMachine.MoreMachineMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.CHEMICAL_WASHER, (ILangEntry)MekanismLang.DESCRIPTION_CHEMICAL_WASHER, AdvancedFactoryType.WASHING).withGui(() -> MekanismContainerTypes.CHEMICAL_WASHER)).withSound(MekanismSounds.CHEMICAL_WASHER)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.chemicalWasher, (FloatingLongSupplier)MekanismConfig.storage.chemicalWasher)).withCustomShape(BlockShapes.CHEMICAL_WASHER)).withComputerSupport("chemicalWasher")).build();
    public static final MoreMachineMachine.MoreMachineFactoryMachine<TileEntityChemicalCrystallizer> CHEMICAL_CRYSTALLIZER = (MoreMachineMachine.MoreMachineFactoryMachine)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)MoreMachineMachine.MoreMachineMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.CHEMICAL_CRYSTALLIZER, (ILangEntry)MekanismLang.DESCRIPTION_CHEMICAL_CRYSTALLIZER, AdvancedFactoryType.CRYSTALLIZING).withGui(() -> MekanismContainerTypes.CHEMICAL_CRYSTALLIZER)).withSound(MekanismSounds.CHEMICAL_CRYSTALLIZER)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.chemicalCrystallizer, (FloatingLongSupplier)MekanismConfig.storage.chemicalCrystallizer)).withCustomShape(BlockShapes.CHEMICAL_CRYSTALLIZER)).withComputerSupport("chemicalCrystallizer")).build();
    public static final MoreMachineMachine.MoreMachineFactoryMachine<TileEntityPressurizedReactionChamber> PRESSURIZED_REACTION_CHAMBER = (MoreMachineMachine.MoreMachineFactoryMachine)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)MoreMachineMachine.MoreMachineMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.PRESSURIZED_REACTION_CHAMBER, (ILangEntry)MekanismLang.DESCRIPTION_PRESSURIZED_REACTION_CHAMBER, AdvancedFactoryType.PRESSURISED_REACTING).withGui(() -> MekanismContainerTypes.PRESSURIZED_REACTION_CHAMBER)).withSound(MekanismSounds.PRESSURIZED_REACTION_CHAMBER)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.pressurizedReactionBase, (FloatingLongSupplier)MekanismConfig.storage.pressurizedReactionBase)).withCustomShape(BlockShapes.PRESSURIZED_REACTION_CHAMBER)).withComputerSupport("pressurizedReactionChamber")).build();
    public static final MoreMachineMachine.MoreMachineFactoryMachine<TileEntityIsotopicCentrifuge> ISOTOPIC_CENTRIFUGE = (MoreMachineMachine.MoreMachineFactoryMachine)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)MoreMachineMachine.MoreMachineMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.ISOTOPIC_CENTRIFUGE, (ILangEntry)MekanismLang.DESCRIPTION_ISOTOPIC_CENTRIFUGE, AdvancedFactoryType.CENTRIFUGING).withGui(() -> MekanismContainerTypes.ISOTOPIC_CENTRIFUGE)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.isotopicCentrifuge, (FloatingLongSupplier)MekanismConfig.storage.isotopicCentrifuge)).withSound(MekanismSounds.ISOTOPIC_CENTRIFUGE)).withCustomShape(BlockShapes.ISOTOPIC_CENTRIFUGE)).withBounding((pos, state, builder) -> builder.add(pos.m_7494_()))).withComputerSupport("isotopicCentrifuge")).build();
    public static final MoreMachineMachine.MoreMachineFactoryMachine<TileEntityNutritionalLiquifier> NUTRITIONAL_LIQUIFIER = (MoreMachineMachine.MoreMachineFactoryMachine)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)((MoreMachineMachine.MoreMachineMachineBuilder)MoreMachineMachine.MoreMachineMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.NUTRITIONAL_LIQUIFIER, (ILangEntry)MekanismLang.DESCRIPTION_NUTRITIONAL_LIQUIFIER, AdvancedFactoryType.LIQUIFYING).withGui(() -> MekanismContainerTypes.NUTRITIONAL_LIQUIFIER)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.nutritionalLiquifier, (FloatingLongSupplier)MekanismConfig.storage.nutritionalLiquifier)).withSound(MekanismSounds.NUTRITIONAL_LIQUIFIER)).withComputerSupport("nutritionalLiquifier")).build();

    private AdvancedFactoryBlockTypes() {
    }

    public static AdvancedFactory<?> getAdvancedFactory(FactoryTier tier, AdvancedFactoryType type) {
        return (AdvancedFactory)((Object)AF_FACTORIES.get((Object)tier, (Object)type));
    }

    static {
        for (FactoryTier tier : EnumUtils.FACTORY_TIERS) {
            for (AdvancedFactoryType type : MoreMachineEnumUtils.ADVANCED_FACTORY_TYPES) {
                AF_FACTORIES.put((Object)tier, (Object)type, (Object)((AdvancedFactory)AdvancedFactory.AdvancedFactoryBuilder.createAdvancedFactory(() -> AdvancedFactoryTileEntityTypes.getAdvancedFactoryTile(tier, type), type, tier).build()));
            }
        }
    }
}

