/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactoryType;
import com.jerry.mekaf.common.registries.AdvancedFactoryBlocks;
import com.jerry.mekaf.common.tile.TileEntityCentrifugingFactory;
import com.jerry.mekaf.common.tile.TileEntityChemicalInfusingFactory;
import com.jerry.mekaf.common.tile.TileEntityCrystallizingFactory;
import com.jerry.mekaf.common.tile.TileEntityDissolvingFactory;
import com.jerry.mekaf.common.tile.TileEntityLiquifyingFactory;
import com.jerry.mekaf.common.tile.TileEntityOxidizingFactory;
import com.jerry.mekaf.common.tile.TileEntityPressurizedReactingFactory;
import com.jerry.mekaf.common.tile.TileEntityWashingFactory;
import com.jerry.mekaf.common.tile.base.TileEntityAdvancedFactoryBase;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.registration.impl.TileEntityTypeDeferredRegister;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.EnumUtils;

public class AdvancedFactoryTileEntityTypes {
    public static final TileEntityTypeDeferredRegister AF_TILE_ENTITY_TYPES = new TileEntityTypeDeferredRegister("mekmm");
    private static final Table<FactoryTier, AdvancedFactoryType, TileEntityTypeRegistryObject<? extends TileEntityAdvancedFactoryBase<?>>> FACTORIES = HashBasedTable.create();

    private AdvancedFactoryTileEntityTypes() {
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityAdvancedFactoryBase<?>> getAdvancedFactoryTile(FactoryTier tier, AdvancedFactoryType type) {
        return (TileEntityTypeRegistryObject)FACTORIES.get((Object)tier, (Object)type);
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityAdvancedFactoryBase<?>>[] getAdvancedFactoryTiles() {
        return FACTORIES.values().toArray(new TileEntityTypeRegistryObject[0]);
    }

    static {
        for (FactoryTier tier : EnumUtils.FACTORY_TIERS) {
            FACTORIES.put((Object)tier, (Object)AdvancedFactoryType.OXIDIZING, (Object)AF_TILE_ENTITY_TYPES.register(AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.OXIDIZING), (pos, state) -> new TileEntityOxidizingFactory((IBlockProvider)AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.OXIDIZING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
            FACTORIES.put((Object)tier, (Object)AdvancedFactoryType.CHEMICAL_INFUSING, (Object)AF_TILE_ENTITY_TYPES.register(AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.CHEMICAL_INFUSING), (pos, state) -> new TileEntityChemicalInfusingFactory((IBlockProvider)AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.CHEMICAL_INFUSING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
            FACTORIES.put((Object)tier, (Object)AdvancedFactoryType.DISSOLVING, (Object)AF_TILE_ENTITY_TYPES.register(AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.DISSOLVING), (pos, state) -> new TileEntityDissolvingFactory((IBlockProvider)AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.DISSOLVING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
            FACTORIES.put((Object)tier, (Object)AdvancedFactoryType.WASHING, (Object)AF_TILE_ENTITY_TYPES.register(AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.WASHING), (pos, state) -> new TileEntityWashingFactory((IBlockProvider)AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.WASHING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
            FACTORIES.put((Object)tier, (Object)AdvancedFactoryType.CRYSTALLIZING, (Object)AF_TILE_ENTITY_TYPES.register(AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.CRYSTALLIZING), (pos, state) -> new TileEntityCrystallizingFactory((IBlockProvider)AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.CRYSTALLIZING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
            FACTORIES.put((Object)tier, (Object)AdvancedFactoryType.PRESSURISED_REACTING, (Object)AF_TILE_ENTITY_TYPES.register(AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.PRESSURISED_REACTING), (pos, state) -> new TileEntityPressurizedReactingFactory((IBlockProvider)AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.PRESSURISED_REACTING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
            FACTORIES.put((Object)tier, (Object)AdvancedFactoryType.CENTRIFUGING, (Object)AF_TILE_ENTITY_TYPES.register(AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.CENTRIFUGING), (pos, state) -> new TileEntityCentrifugingFactory((IBlockProvider)AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.CENTRIFUGING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
            FACTORIES.put((Object)tier, (Object)AdvancedFactoryType.LIQUIFYING, (Object)AF_TILE_ENTITY_TYPES.register(AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.LIQUIFYING), (pos, state) -> new TileEntityLiquifyingFactory((IBlockProvider)AdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.LIQUIFYING), pos, state), TileEntityMekanism::tickServer, TileEntityMekanism::tickClient));
        }
    }
}

