/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile;

import com.jerry.mekaf.common.capabilities.energy.AdvancedFactoryEnergyContainer;
import com.jerry.mekaf.common.tile.base.TileEntityGasToGasFactory;
import com.jerry.mekaf.common.upgrade.GasToGasUpgradeData;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.OneInputCachedRecipe;
import mekanism.api.recipes.chemical.ChemicalToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityCentrifugingFactory
extends TileEntityGasToGasFactory<GasToGasRecipe>
implements IBoundingBlock,
ISingleRecipeLookupHandler.ChemicalRecipeLookupHandler<Gas, GasStack, GasToGasRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY);

    public TileEntityCentrifugingFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        ConfigInfo gasConfig = this.configComponent.getConfig(TransmissionType.GAS);
        if (gasConfig != null) {
            gasConfig.addSlotInfo(DataType.INPUT, (ISlotInfo)new ChemicalSlotInfo.GasSlotInfo(true, false, this.inputGasTanks));
            List ioTank = this.outputGasTanks;
            ioTank.addAll(this.inputGasTanks);
            gasConfig.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new ChemicalSlotInfo.GasSlotInfo(true, true, ioTank));
            gasConfig.fill(DataType.INPUT);
            gasConfig.setDataType(DataType.OUTPUT, new RelativeSide[]{RelativeSide.FRONT});
            gasConfig.setEjecting(true);
        }
        this.configComponent.addDisabledSides(new RelativeSide[]{RelativeSide.TOP});
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.GAS}).setCanTankEject(tank -> !this.inputGasTanks.contains(tank));
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<GasToGasRecipe> cached, @NotNull GasStack stack) {
        return cached != null && ((ChemicalStackIngredient.GasStackIngredient)((GasToGasRecipe)cached.getRecipe()).getInput()).testType((Object)stack);
    }

    @Override
    @Nullable
    protected GasToGasRecipe findRecipe(int process, @NotNull GasStack fallbackInput, @NotNull IGasTank outputTanks) {
        GasStack output = (GasStack)outputTanks.getStack();
        return (GasToGasRecipe)((InputRecipeCache.SingleChemical)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.f_58857_, (Object)fallbackInput, recipe -> output.isTypeEqual(recipe.getOutput((ChemicalStack)fallbackInput)));
    }

    @Override
    public boolean isChemicalValidForTank(@NotNull GasStack stack) {
        return this.containsRecipe(stack);
    }

    @Override
    public boolean isValidInputChemical(@NotNull GasStack stack) {
        return this.containsRecipe(stack);
    }

    @Override
    protected int getNeededInput(GasToGasRecipe recipe, GasStack inputStack) {
        return MathUtils.clampToInt((long)((ChemicalStackIngredient.GasStackIngredient)recipe.getInput()).getNeededAmount((Object)inputStack));
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
    }

    @NotNull
    public IMekanismRecipeTypeProvider<GasToGasRecipe, InputRecipeCache.SingleChemical<Gas, GasStack, GasToGasRecipe>> getRecipeType() {
        return MekanismRecipeType.CENTRIFUGING;
    }

    @Nullable
    public GasToGasRecipe getRecipe(int cacheIndex) {
        return (GasToGasRecipe)this.findFirstRecipe(this.gasInputHandlers[cacheIndex]);
    }

    @NotNull
    public CachedRecipe<GasToGasRecipe> createNewCachedRecipe(@NotNull GasToGasRecipe recipe, int cacheIndex) {
        return OneInputCachedRecipe.chemicalToChemical((ChemicalToChemicalRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors[cacheIndex], (IInputHandler)this.gasInputHandlers[cacheIndex], (IOutputHandler)this.gasOutputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(active -> this.setActiveState(active, cacheIndex)).setOnFinish(() -> ((TileEntityCentrifugingFactory)this).markForSave()).setEnergyRequirements(() -> ((AdvancedFactoryEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setBaselineMaxOperations(this::getBaselineMaxOperations);
    }

    protected boolean makesComparatorDirty(@Nullable SubstanceType type) {
        return type == SubstanceType.GAS;
    }

    @Nullable
    public IUpgradeData getUpgradeData() {
        return new GasToGasUpgradeData(this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, this.energySlot, this.inputGasTanks, this.outputGasTanks, this.isSorting(), this.getComponents());
    }
}

