/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile;

import com.jerry.mekaf.common.capabilities.energy.AdvancedFactoryEnergyContainer;
import com.jerry.mekaf.common.tile.base.TileEntityGasToGasFactory;
import com.jerry.mekaf.common.upgrade.GasGasToGasUpgradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.ChemicalInfuserRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ChemicalChemicalToChemicalCachedRecipe;
import mekanism.api.recipes.chemical.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IEitherSideRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityChemicalInfusingFactory
extends TileEntityGasToGasFactory<ChemicalInfuserRecipe>
implements IEitherSideRecipeLookupHandler.EitherSideChemicalRecipeLookupHandler<Gas, GasStack, ChemicalInfuserRecipe>,
IHasDumpButton {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_LEFT_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_RIGHT_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_RIGHT_INPUT);
    public static final long MAX_GAS = 10000L;
    public IGasTank rightTank;
    private final IInputHandler<@NotNull GasStack> rightInputHandler;
    GasInventorySlot rightInputSlot;

    public TileEntityChemicalInfusingFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        ConfigInfo chemicalConfig;
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.EXTRA, (ISlotInfo)new InventorySlotInfo(true, false, new IInventorySlot[]{this.rightInputSlot}));
            itemConfig.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.rightInputSlot}));
            itemConfig.setDataType(DataType.EXTRA, new RelativeSide[]{RelativeSide.BOTTOM});
            itemConfig.setDataType(DataType.ENERGY, new RelativeSide[]{RelativeSide.BACK});
        }
        if ((chemicalConfig = this.configComponent.getConfig(TransmissionType.GAS)) != null) {
            chemicalConfig.addSlotInfo(DataType.INPUT_2, (ISlotInfo)new ChemicalSlotInfo.GasSlotInfo(true, false, new IGasTank[]{this.rightTank}));
            chemicalConfig.addSlotInfo(DataType.INPUT_1, (ISlotInfo)new ChemicalSlotInfo.GasSlotInfo(true, false, this.inputGasTanks));
            ArrayList<IGasTank> ioTank = new ArrayList<IGasTank>(List.of(this.rightTank));
            ioTank.addAll(this.inputGasTanks);
            chemicalConfig.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new ChemicalSlotInfo.GasSlotInfo(true, true, ioTank));
            chemicalConfig.setDataType(DataType.INPUT_1, new RelativeSide[]{RelativeSide.LEFT});
            chemicalConfig.setDataType(DataType.INPUT_2, new RelativeSide[]{RelativeSide.RIGHT});
            chemicalConfig.setDataType(DataType.OUTPUT, new RelativeSide[]{RelativeSide.FRONT});
            chemicalConfig.setEjecting(true);
        }
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.GAS}).setCanTankEject(this.outputGasTanks::contains);
        this.rightInputHandler = InputHelper.getInputHandler((IChemicalTank)this.rightTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_RIGHT_INPUT);
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<ChemicalInfuserRecipe> cached, @NotNull GasStack stack) {
        if (cached != null) {
            ChemicalInfuserRecipe cachedRecipe = (ChemicalInfuserRecipe)cached.getRecipe();
            return ((ChemicalStackIngredient.GasStackIngredient)cachedRecipe.getLeftInput()).testType((Object)stack) && (this.rightTank.isEmpty() || ((ChemicalStackIngredient.GasStackIngredient)cachedRecipe.getRightInput()).testType((Object)((GasStack)this.rightTank.getStack())));
        }
        return false;
    }

    @Override
    @Nullable
    protected ChemicalInfuserRecipe findRecipe(int process, @NotNull GasStack fallbackInput, @NotNull IGasTank outputTank) {
        return (ChemicalInfuserRecipe)((InputRecipeCache.EitherSideChemical)this.getRecipeType().getInputCache()).findFirstRecipe(this.f_58857_, (Object)fallbackInput, (Object)((GasStack)outputTank.getStack()));
    }

    @Override
    public boolean isChemicalValidForTank(@NotNull GasStack stack) {
        return this.containsRecipe((GasStack)this.rightTank.getStack(), stack) || this.containsRecipe(stack, (GasStack)this.rightTank.getStack());
    }

    @Override
    public boolean isValidInputChemical(@NotNull GasStack stack) {
        return this.containsRecipe(stack, (GasStack)this.rightTank.getStack()) || this.containsRecipe((GasStack)this.rightTank.getStack(), stack);
    }

    @Override
    protected int getNeededInput(ChemicalInfuserRecipe recipe, GasStack inputStack) {
        return MathUtils.clampToInt((long)((ChemicalStackIngredient.GasStackIngredient)recipe.getLeftInput()).getNeededAmount((Object)inputStack));
    }

    @Override
    protected void addGasTanks(ChemicalTankHelper<Gas, GasStack, IGasTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
        super.addGasTanks(builder, listener, updateSortingListener);
        this.rightTank = (IGasTank)ChemicalTankBuilder.GAS.create(10000L * (long)this.tier.processes, arg_0 -> ((TileEntityChemicalInfusingFactory)this).containsRecipe(arg_0), this.markAllMonitorsChanged(listener));
        builder.addTank((IChemicalTank)this.rightTank);
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.rightInputSlot = GasInventorySlot.fill((IGasTank)this.rightTank, (IContentsListener)listener, (int)7, (int)83);
        builder.addSlot((IInventorySlot)this.rightInputSlot);
        this.rightInputSlot.setSlotType(ContainerSlotType.INPUT);
        this.rightInputSlot.setSlotOverlay(SlotOverlay.MINUS);
    }

    @Override
    public IGasTank getGasTankBar() {
        return this.rightTank;
    }

    @Override
    protected void handleExtrasFuel() {
        this.rightInputSlot.fillTank();
    }

    @Override
    public boolean hasExtrasResourceBar() {
        return true;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<ChemicalInfuserRecipe, InputRecipeCache.EitherSideChemical<Gas, GasStack, ChemicalInfuserRecipe>> getRecipeType() {
        return MekanismRecipeType.CHEMICAL_INFUSING;
    }

    @Nullable
    public ChemicalInfuserRecipe getRecipe(int cacheIndex) {
        return (ChemicalInfuserRecipe)this.findFirstRecipe(this.gasInputHandlers[cacheIndex], this.rightInputHandler);
    }

    @NotNull
    public CachedRecipe<ChemicalInfuserRecipe> createNewCachedRecipe(@NotNull ChemicalInfuserRecipe recipe, int cacheIndex) {
        return new ChemicalChemicalToChemicalCachedRecipe((ChemicalChemicalToChemicalRecipe)recipe, this.recheckAllRecipeErrors[cacheIndex], this.gasInputHandlers[cacheIndex], this.rightInputHandler, this.gasOutputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((AdvancedFactoryEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setBaselineMaxOperations(this::getBaselineMaxOperations).setOnFinish(() -> ((TileEntityChemicalInfusingFactory)this).markForSave());
    }

    @Override
    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof GasGasToGasUpgradeData) {
            GasGasToGasUpgradeData data = (GasGasToGasUpgradeData)upgradeData;
            super.parseUpgradeData(upgradeData);
            this.rightTank.deserializeNBT(data.inputTank.serializeNBT());
            this.rightInputSlot.deserializeNBT(data.chemicalSlot.serializeNBT());
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @Nullable
    public IUpgradeData getUpgradeData() {
        return new GasGasToGasUpgradeData(this.redstone, this.getControlType(), (IEnergyContainer)this.energyContainer, this.progress, null, this.energySlot, this.rightInputSlot, this.inputGasTanks, this.rightTank, this.outputGasTanks, this.isSorting(), this.getComponents());
    }

    public void dump() {
        this.rightTank.setEmpty();
    }
}

