/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile;

import com.jerry.mekaf.common.capabilities.energy.AdvancedFactoryEnergyContainer;
import com.jerry.mekaf.common.tile.base.TileEntityMergedToItemFactory;
import com.jerry.mekaf.common.upgrade.MergedToItemUpgradeData;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ChemicalCrystallizerCachedRecipe;
import mekanism.api.recipes.inputs.BoxedChemicalInputHandler;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.ChemicalCrystallizerInputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityCrystallizingFactory
extends TileEntityMergedToItemFactory<ChemicalCrystallizerRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY);
    private static final long MAX_CHEMICAL = 10000L;
    @Nullable
    private IContentsListener recipeCacheSaveOnlyListener;

    public TileEntityCrystallizingFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM});
        this.recipeCacheSaveOnlyListener = null;
    }

    @Override
    protected void presetVariables() {
        super.presetVariables();
        this.inputTank = new MergedChemicalTank[this.tier.processes];
        this.mergedInputHandlers = new BoxedChemicalInputHandler[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            this.inputTank[i] = MergedChemicalTank.create((IGasTank)((IGasTank)ChemicalTankBuilder.GAS.input(10000L * (long)this.tier.processes, gas -> ((ChemicalCrystallizerInputRecipeCache)this.getRecipeType().getInputCache()).containsInput(this.f_58857_, (Chemical)gas), this.getRecipeCacheSaveOnlyListener(i))), (IInfusionTank)((IInfusionTank)ChemicalTankBuilder.INFUSION.input(10000L * (long)this.tier.processes, infuseType -> ((ChemicalCrystallizerInputRecipeCache)this.getRecipeType().getInputCache()).containsInput(this.f_58857_, (Chemical)infuseType), this.getRecipeCacheSaveOnlyListener(i))), (IPigmentTank)((IPigmentTank)ChemicalTankBuilder.PIGMENT.input(10000L * (long)this.tier.processes, pigment -> ((ChemicalCrystallizerInputRecipeCache)this.getRecipeType().getInputCache()).containsInput(this.f_58857_, (Chemical)pigment), this.getRecipeCacheSaveOnlyListener(i))), (ISlurryTank)((ISlurryTank)ChemicalTankBuilder.SLURRY.input(10000L * (long)this.tier.processes, slurry -> ((ChemicalCrystallizerInputRecipeCache)this.getRecipeType().getInputCache()).containsInput(this.f_58857_, (Chemical)slurry), this.getRecipeCacheSaveOnlyListener(i))));
            this.mergedInputHandlers[i] = new BoxedChemicalInputHandler(this.inputTank[i], CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        }
    }

    protected IContentsListener getRecipeCacheSaveOnlyListener(int index) {
        if (this.supportsComparator()) {
            if (this.recipeCacheSaveOnlyListener == null) {
                this.recipeCacheSaveOnlyListener = () -> {
                    this.markForSave();
                    this.recipeCacheLookupMonitors[index].onChange();
                };
            }
            return this.recipeCacheSaveOnlyListener;
        }
        return this.recipeCacheLookupMonitors[index];
    }

    @NotNull
    public IMekanismRecipeTypeProvider<ChemicalCrystallizerRecipe, ChemicalCrystallizerInputRecipeCache> getRecipeType() {
        return MekanismRecipeType.CRYSTALLIZING;
    }

    @Nullable
    public ChemicalCrystallizerRecipe getRecipe(int cacheIndex) {
        return ((ChemicalCrystallizerInputRecipeCache)this.getRecipeType().getInputCache()).findFirstRecipe(this.f_58857_, this.mergedInputHandlers[cacheIndex].getInput());
    }

    @NotNull
    public CachedRecipe<ChemicalCrystallizerRecipe> createNewCachedRecipe(@NotNull ChemicalCrystallizerRecipe recipe, int cacheIndex) {
        return new ChemicalCrystallizerCachedRecipe(recipe, this.recheckAllRecipeErrors[cacheIndex], this.mergedInputHandlers[cacheIndex], this.itemOutputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((AdvancedFactoryEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityCrystallizingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Nullable
    public IUpgradeData getUpgradeData() {
        return new MergedToItemUpgradeData(this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, this.energySlot, this.inputChemicalTanks, this.outputItemSlots, this.isSorting(), this.getComponents());
    }
}

