/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile;

import com.jerry.mekaf.common.capabilities.energy.AdvancedFactoryEnergyContainer;
import com.jerry.mekaf.common.tile.base.TileEntityItemToMergedFactory;
import com.jerry.mekaf.common.upgrade.ItemGasToMergedUpgradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ChemicalDissolutionCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityDissolvingFactory
extends TileEntityItemToMergedFactory<ChemicalDissolutionRecipe>
implements IHasDumpButton,
IDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<Gas, GasStack, ChemicalDissolutionRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    private static final long MAX_CHEMICAL = 10000L;
    public IGasTank injectTank;
    public double injectUsage = 1.0;
    private final ILongInputHandler<@NotNull GasStack> gasInputHandler;
    GasInventorySlot gasInputSlot;

    public TileEntityDissolvingFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        ConfigInfo gasConfig;
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.EXTRA, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.gasInputSlot}));
            itemConfig.setDefaults();
        }
        if ((gasConfig = this.configComponent.getConfig(TransmissionType.GAS)) != null) {
            gasConfig.addSlotInfo(DataType.INPUT, (ISlotInfo)new ChemicalSlotInfo.GasSlotInfo(true, false, new IGasTank[]{this.injectTank}));
            ArrayList<IGasTank> ioTank = new ArrayList<IGasTank>(List.of(this.injectTank));
            ioTank.addAll(this.outputGasTanks);
            gasConfig.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new ChemicalSlotInfo.GasSlotInfo(true, true, ioTank));
        }
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.PIGMENT, TransmissionType.SLURRY}).setCanTankEject(tank -> tank != this.injectTank);
        this.gasInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.injectTank);
    }

    @Override
    protected void addGasTanks(ChemicalTankHelper<Gas, GasStack, IGasTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
        super.addGasTanks(builder, listener, updateSortingListener);
        this.injectTank = (IGasTank)ChemicalTankBuilder.GAS.input(10000L * (long)this.tier.processes, arg_0 -> ((TileEntityDissolvingFactory)this).containsRecipeB(arg_0), this.markAllMonitorsChanged(listener));
        builder.addTank((IChemicalTank)this.injectTank);
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        super.addSlots(builder, listener, updateSortingListener);
        this.gasInputSlot = GasInventorySlot.fillOrConvert((IGasTank)this.injectTank, () -> ((TileEntityDissolvingFactory)this).m_58904_(), (IContentsListener)listener, (int)7, (int)70);
        builder.addSlot((IInventorySlot)this.gasInputSlot);
    }

    @Override
    public IGasTank getGasTankBar() {
        return this.injectTank;
    }

    @Override
    protected void handleExtrasFuel() {
        this.gasInputSlot.fillTankOrConvert();
    }

    @Override
    public boolean hasExtrasResourceBar() {
        return true;
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<ChemicalDissolutionRecipe> cached, @NotNull ItemStack stack) {
        return cached != null && ((ChemicalDissolutionRecipe)cached.getRecipe()).getItemInput().testType((Object)stack);
    }

    @Override
    @Nullable
    protected ChemicalDissolutionRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull MergedChemicalTank outputTanks) {
        return (ChemicalDissolutionRecipe)((InputRecipeCache.ItemChemical)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.f_58857_, (Object)fallbackInput, (Object)((GasStack)this.injectTank.getStack()), recipe -> {
            ChemicalStack stack = recipe.getOutput(fallbackInput, (GasStack)this.injectTank.getStack()).getChemicalStack();
            if (stack instanceof GasStack) {
                GasStack output = (GasStack)stack;
                return output.isTypeEqual((ChemicalStack)output);
            }
            if (stack instanceof InfusionStack) {
                InfusionStack output = (InfusionStack)stack;
                return output.isTypeEqual((ChemicalStack)output);
            }
            if (stack instanceof PigmentStack) {
                PigmentStack output = (PigmentStack)stack;
                return output.isTypeEqual((ChemicalStack)output);
            }
            if (stack instanceof SlurryStack) {
                SlurryStack output = (SlurryStack)stack;
                return output.isTypeEqual((ChemicalStack)output);
            }
            return false;
        });
    }

    @Override
    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    @Override
    protected int getNeededInput(ChemicalDissolutionRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getItemInput().getNeededAmount((Object)inputStack));
    }

    @NotNull
    public IMekanismRecipeTypeProvider<ChemicalDissolutionRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ChemicalDissolutionRecipe>> getRecipeType() {
        return MekanismRecipeType.DISSOLUTION;
    }

    @Nullable
    public ChemicalDissolutionRecipe getRecipe(int cacheIndex) {
        return (ChemicalDissolutionRecipe)this.findFirstRecipe(this.itemInputHandlers[cacheIndex], (IInputHandler)this.gasInputHandler);
    }

    @NotNull
    public CachedRecipe<ChemicalDissolutionRecipe> createNewCachedRecipe(@NotNull ChemicalDissolutionRecipe recipe, int cacheIndex) {
        return new ChemicalDissolutionCachedRecipe(recipe, this.recheckAllRecipeErrors[cacheIndex], this.itemInputHandlers[cacheIndex], this.gasInputHandler, () -> StatUtils.inversePoisson((double)this.injectUsage), this.mergedOutputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((AdvancedFactoryEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityDissolvingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.GAS || upgrade == Upgrade.SPEED) {
            this.injectUsage = MekanismUtils.getGasPerTickMeanMultiplier((IUpgradeTile)this);
        }
    }

    @Override
    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof ItemGasToMergedUpgradeData) {
            ItemGasToMergedUpgradeData data = (ItemGasToMergedUpgradeData)upgradeData;
            super.parseUpgradeData(upgradeData);
            this.injectTank.deserializeNBT(data.inputTank.serializeNBT());
            this.gasInputSlot.deserializeNBT(data.gasSlot.serializeNBT());
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @Nullable
    public IUpgradeData getUpgradeData() {
        return new ItemGasToMergedUpgradeData(this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, this.energySlot, this.gasInputSlot, this.inputItemSlots, this.injectTank, this.outputChemicalTanks, this.isSorting(), this.getComponents());
    }

    public void dump() {
        this.injectTank.setEmpty();
    }
}

