/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile;

import com.jerry.mekaf.common.capabilities.energy.AdvancedFactoryEnergyContainer;
import com.jerry.mekaf.common.inventory.slot.AdvancedFactoryInputInventorySlot;
import com.jerry.mekaf.common.tile.base.TileEntityAdvancedFactoryBase;
import com.jerry.mekaf.common.upgrade.PRCUpgradeData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.PressurizedReactionCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ITripleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityPressurizedReactingFactory
extends TileEntityAdvancedFactoryBase<PressurizedReactionRecipe>
implements IHasDumpButton,
ITripleRecipeLookupHandler.ItemFluidChemicalRecipeLookupHandler<Gas, GasStack, PressurizedReactionRecipe> {
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_ITEM_INPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_FLUID_INPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_GAS_INPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_GAS_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, NOT_ENOUGH_ITEM_INPUT_ERROR, NOT_ENOUGH_FLUID_INPUT_ERROR, NOT_ENOUGH_GAS_INPUT_ERROR, NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR, NOT_ENOUGH_SPACE_GAS_OUTPUT_ERROR, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, NOT_ENOUGH_FLUID_INPUT_ERROR, NOT_ENOUGH_GAS_INPUT_ERROR, NOT_ENOUGH_SPACE_GAS_OUTPUT_ERROR);
    private static final int BASE_DURATION = 100;
    private static final long MAX_GAS = 10000L;
    public static final int MAX_FLUID = 10000;
    private PRCProcessInfo[] processInfoSlots;
    public BasicFluidTank inputFluidTank;
    public IGasTank inputGasTank;
    public IGasTank outputGasTank;
    private FloatingLong recipeEnergyRequired = FloatingLong.ZERO;
    private final IInputHandler<@NotNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NotNull GasStack> gasInputHandler;
    protected IOutputHandler<PressurizedReactionRecipe.PressurizedReactionRecipeOutput>[] reactionOutputHandlers;
    protected final List<IInventorySlot> inputItemSlots = new ArrayList<IInventorySlot>();
    protected final List<IInventorySlot> outputItemSlots = new ArrayList<IInventorySlot>();

    public TileEntityPressurizedReactingFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        for (PRCProcessInfo info : this.processInfoSlots) {
            this.inputItemSlots.add((IInventorySlot)info.inputSlot());
            this.outputItemSlots.add(info.outputSlot());
        }
        this.addSupported(TransmissionType.FLUID, TransmissionType.GAS);
        this.configComponent.setupItemIOConfig(this.inputItemSlots, this.outputItemSlots, (IInventorySlot)this.energySlot, false);
        this.configComponent.setupInputConfig(TransmissionType.FLUID, (Object)this.inputFluidTank);
        ConfigInfo gasConfig = this.configComponent.getConfig(TransmissionType.GAS);
        if (gasConfig != null) {
            gasConfig.addSlotInfo(DataType.INPUT, (ISlotInfo)new ChemicalSlotInfo.GasSlotInfo(true, true, new IGasTank[]{this.inputGasTank}));
            gasConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new ChemicalSlotInfo.GasSlotInfo(false, true, new IGasTank[]{this.outputGasTank}));
            gasConfig.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new ChemicalSlotInfo.GasSlotInfo(true, true, List.of(this.inputGasTank, this.outputGasTank)));
            gasConfig.fill(DataType.INPUT);
            gasConfig.setDataType(DataType.OUTPUT, new RelativeSide[]{RelativeSide.RIGHT});
            gasConfig.setEjecting(true);
        }
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.GAS}).setCanTankEject(tank -> tank != this.inputGasTank);
        this.fluidInputHandler = InputHelper.getInputHandler((IExtendedFluidTank)this.inputFluidTank, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_FLUID_INPUT_ERROR);
        this.gasInputHandler = InputHelper.getInputHandler((IChemicalTank)this.inputGasTank, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_GAS_INPUT_ERROR);
    }

    @Override
    protected void addGasTanks(ChemicalTankHelper<Gas, GasStack, IGasTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.inputGasTank = (IGasTank)ChemicalTankBuilder.GAS.create(10000L * (long)this.tier.processes, ChemicalTankHelper.radioactiveInputTankPredicate(() -> this.outputGasTank), ConstantPredicates.alwaysTrueBi(), arg_0 -> ((TileEntityPressurizedReactingFactory)this).containsRecipeC(arg_0), ChemicalAttributeValidator.ALWAYS_ALLOW, this.markAllMonitorsChanged(listener));
        builder.addTank((IChemicalTank)this.inputGasTank);
        this.outputGasTank = (IGasTank)ChemicalTankBuilder.GAS.output(10000L * (long)this.tier.processes, this.markAllMonitorsChanged(listener));
        builder.addTank((IChemicalTank)this.outputGasTank);
    }

    @Override
    protected void addFluidTanks(FluidTankHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.inputFluidTank = BasicFluidTank.input((int)(10000 * this.tier.processes), (Predicate)ConstantPredicates.alwaysTrue(), arg_0 -> ((TileEntityPressurizedReactingFactory)this).containsRecipeB(arg_0), (IContentsListener)this.markAllMonitorsChanged(listener));
        builder.addTank((IExtendedFluidTank)this.inputFluidTank);
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.itemInputHandlers = new IInputHandler[this.tier.processes];
        this.reactionOutputHandlers = new IOutputHandler[this.tier.processes];
        this.processInfoSlots = new PRCProcessInfo[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            OutputInventorySlot outputSlot = OutputInventorySlot.at((IContentsListener)this.recipeCacheLookupMonitors[i], (int)this.getXPos(i), (int)57);
            AdvancedFactoryInputInventorySlot inputSlot = AdvancedFactoryInputInventorySlot.create(this, i, (IInventorySlot)outputSlot, this.outputGasTank, (IContentsListener)this.recipeCacheLookupMonitors[i], this.getXPos(i), 13);
            int index = i;
            ((AdvancedFactoryInputInventorySlot)builder.addSlot((IInventorySlot)inputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(NOT_ENOUGH_ITEM_INPUT_ERROR, index)));
            ((OutputInventorySlot)builder.addSlot((IInventorySlot)outputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR, index)));
            this.itemInputHandlers[i] = InputHelper.getInputHandler((IInventorySlot)inputSlot, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_ITEM_INPUT_ERROR);
            this.reactionOutputHandlers[i] = OutputHelper.getOutputHandler((IInventorySlot)outputSlot, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR, (IGasTank)this.outputGasTank, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_SPACE_GAS_OUTPUT_ERROR);
            this.processInfoSlots[i] = new PRCProcessInfo(i, inputSlot, (IInventorySlot)outputSlot);
        }
    }

    public void onCachedRecipeChanged(@Nullable CachedRecipe<PressurizedReactionRecipe> cachedRecipe, int cacheIndex) {
        int recipeDuration;
        super.onCachedRecipeChanged(cachedRecipe, cacheIndex);
        if (cachedRecipe == null) {
            recipeDuration = 100;
            this.recipeEnergyRequired = FloatingLong.ZERO;
        } else {
            PressurizedReactionRecipe recipe = (PressurizedReactionRecipe)cachedRecipe.getRecipe();
            recipeDuration = recipe.getDuration();
            this.recipeEnergyRequired = recipe.getEnergyRequired();
        }
        boolean update = this.getTicksRequired() != recipeDuration;
        this.setTicksRequired(recipeDuration);
        if (update) {
            this.recalculateUpgrades(Upgrade.SPEED);
        }
        this.energyContainer.updateEnergyPerTick();
    }

    @Override
    public FloatingLong getRecipeEnergyRequired() {
        return this.recipeEnergyRequired;
    }

    @Override
    public IGasTank getGasTankBar() {
        return this.inputGasTank;
    }

    public BasicFluidTank getFluidTankBar() {
        return this.inputFluidTank;
    }

    @Override
    public boolean hasExtrasResourceBar() {
        return true;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<PressurizedReactionRecipe, InputRecipeCache.ItemFluidChemical<Gas, GasStack, PressurizedReactionRecipe>> getRecipeType() {
        return MekanismRecipeType.REACTION;
    }

    @Nullable
    public PressurizedReactionRecipe getRecipe(int cacheIndex) {
        return (PressurizedReactionRecipe)this.findFirstRecipe(this.itemInputHandlers[cacheIndex], this.fluidInputHandler, this.gasInputHandler);
    }

    @NotNull
    public CachedRecipe<PressurizedReactionRecipe> createNewCachedRecipe(@NotNull PressurizedReactionRecipe recipe, int cacheIndex) {
        return new PressurizedReactionCachedRecipe(recipe, this.recheckAllRecipeErrors[cacheIndex], this.itemInputHandlers[cacheIndex], this.fluidInputHandler, this.gasInputHandler, this.reactionOutputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((AdvancedFactoryEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityPressurizedReactingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        }).setBaselineMaxOperations(this::getBaselineMaxOperations);
    }

    public boolean inputProducesOutput(int process, @NotNull ItemStack fallbackInput, IInventorySlot outputSlot, @NotNull IGasTank outputTank, boolean updateCache) {
        return outputTank.isEmpty() || this.getRecipeForInput(process, fallbackInput, outputSlot, outputTank, updateCache) != null;
    }

    @Contract(value="null, _ -> false")
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<PressurizedReactionRecipe> cached, @NotNull ItemStack stack) {
        if (cached != null) {
            PressurizedReactionRecipe cachedRecipe = (PressurizedReactionRecipe)cached.getRecipe();
            return !(!cachedRecipe.getInputSolid().testType((Object)stack) || !this.inputFluidTank.isEmpty() && !cachedRecipe.getInputFluid().testType((Object)this.inputFluidTank.getFluid()) || !this.inputGasTank.isEmpty() && !cachedRecipe.getInputGas().testType((Object)((GasStack)this.inputGasTank.getStack())));
        }
        return false;
    }

    @Nullable
    protected PressurizedReactionRecipe getRecipeForInput(int process, @NotNull ItemStack fallbackInput, IInventorySlot outputSlot, @NotNull IGasTank outputTank, boolean updateCache) {
        CachedRecipe cached;
        if (!CommonWorldTickHandler.flushTagAndRecipeCaches && this.isCachedRecipeValid(cached = this.getCachedRecipe(process), fallbackInput)) {
            return (PressurizedReactionRecipe)cached.getRecipe();
        }
        PressurizedReactionRecipe foundRecipe = this.findRecipe(process, fallbackInput, outputTank);
        if (foundRecipe == null) {
            return null;
        }
        if (updateCache) {
            this.recipeCacheLookupMonitors[process].updateCachedRecipe((MekanismRecipe)foundRecipe);
        }
        return foundRecipe;
    }

    @Nullable
    protected PressurizedReactionRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IGasTank outputTanks) {
        return (PressurizedReactionRecipe)((InputRecipeCache.ItemFluidChemical)this.getRecipeType().getInputCache()).findFirstRecipe(this.f_58857_, (Object)fallbackInput, (Object)this.inputFluidTank.getFluid(), (Object)((GasStack)this.inputGasTank.getStack()));
    }

    public boolean isItemValidForSlot(@NotNull ItemStack stack) {
        return this.containsRecipeBAC(stack, this.inputFluidTank.getFluid(), (GasStack)this.inputGasTank.getStack()) || this.containsRecipeCAB(stack, this.inputFluidTank.getFluid(), (GasStack)this.inputGasTank.getStack());
    }

    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    protected int getNeededInput(PressurizedReactionRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getInputSolid().getNeededAmount((Object)inputStack));
    }

    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof PRCUpgradeData) {
            int i;
            PRCUpgradeData data = (PRCUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.energySlot.deserializeNBT(data.energySlot.serializeNBT());
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputSlots.size(); ++i) {
                this.inputItemSlots.get(i).deserializeNBT((Tag)((CompoundTag)data.inputSlots.get(i).serializeNBT()));
            }
            for (i = 0; i < data.outputSlots.size(); ++i) {
                this.outputItemSlots.get(i).setStack(data.outputSlots.get(i).getStack());
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
            this.inputGasTank.deserializeNBT(data.inputChemicalTank.serializeNBT());
            this.inputFluidTank.deserializeNBT(data.inputFluidTank.serializeNBT());
            this.outputGasTank.deserializeNBT(data.outputTank.serializeNBT());
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Nullable
    public IUpgradeData getUpgradeData() {
        return new PRCUpgradeData(this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, this.energySlot, this.inputGasTank, this.inputFluidTank, this.inputItemSlots, this.outputItemSlots, this.outputGasTank, this.isSorting(), this.getComponents());
    }

    public void dump() {
        this.inputFluidTank.setStack(FluidStack.EMPTY);
        if (!this.isRemote() && IRadiationManager.INSTANCE.isRadiationEnabled() && this.shouldDumpRadiation()) {
            IRadiationManager.INSTANCE.dumpRadiation(this.getTileCoord(), List.of(this.inputGasTank), false);
        }
        this.inputGasTank.setEmpty();
    }

    @Override
    protected void sortInventoryOrTank() {
        HashMap<HashedItem, PRCRecipeProcessInfo> processes = new HashMap<HashedItem, PRCRecipeProcessInfo>();
        ArrayList<PRCProcessInfo> emptyProcesses = new ArrayList<PRCProcessInfo>();
        for (PRCProcessInfo processInfo : this.processInfoSlots) {
            CachedRecipe cachedRecipe;
            AdvancedFactoryInputInventorySlot inputSlot = processInfo.inputSlot();
            if (inputSlot.isEmpty()) {
                emptyProcesses.add(processInfo);
                continue;
            }
            ItemStack inputStack = inputSlot.getStack();
            HashedItem item = HashedItem.raw((ItemStack)inputStack);
            PRCRecipeProcessInfo recipeProcessInfo = processes.computeIfAbsent(item, i -> new PRCRecipeProcessInfo());
            recipeProcessInfo.processes.add(processInfo);
            recipeProcessInfo.totalCount += inputStack.m_41613_();
            if (recipeProcessInfo.lazyMinPerSlot != null || CommonWorldTickHandler.flushTagAndRecipeCaches || !this.isCachedRecipeValid(cachedRecipe = this.getCachedRecipe(processInfo.process()), inputStack)) continue;
            recipeProcessInfo.lazyMinPerSlot = () -> Math.max(1, this.getNeededInput((PressurizedReactionRecipe)cachedRecipe.getRecipe(), inputStack));
        }
        if (processes.isEmpty()) {
            return;
        }
        for (Map.Entry entry : processes.entrySet()) {
            PRCRecipeProcessInfo recipeProcessInfo = (PRCRecipeProcessInfo)entry.getValue();
            if (recipeProcessInfo.lazyMinPerSlot != null) continue;
            recipeProcessInfo.lazyMinPerSlot = () -> {
                HashedItem item = (HashedItem)entry.getKey();
                ItemStack largerInput = item.createStack(Math.min(item.getMaxStackSize(), recipeProcessInfo.totalCount));
                PRCProcessInfo processInfo = recipeProcessInfo.processes.get(0);
                PressurizedReactionRecipe recipe = this.getRecipeForInput(processInfo.process(), largerInput, processInfo.outputSlot, this.outputGasTank, true);
                if (recipe != null) {
                    return Math.max(1, this.getNeededInput(recipe, largerInput));
                }
                return 1;
            };
        }
        if (!emptyProcesses.isEmpty()) {
            this.addEmptySlotsAsTargets(processes, emptyProcesses);
        }
        this.distributeItems(processes);
    }

    private void addEmptySlotsAsTargets(Map<HashedItem, PRCRecipeProcessInfo> processes, List<PRCProcessInfo> emptyProcesses) {
        for (Map.Entry<HashedItem, PRCRecipeProcessInfo> entry : processes.entrySet()) {
            int processCount;
            PRCRecipeProcessInfo recipeProcessInfo = entry.getValue();
            int minPerSlot = recipeProcessInfo.getMinPerSlot();
            int maxSlots = recipeProcessInfo.totalCount / minPerSlot;
            if (maxSlots <= 1 || maxSlots <= (processCount = recipeProcessInfo.processes.size())) continue;
            ItemStack sourceStack = entry.getKey().getInternalStack();
            int emptyToAdd = maxSlots - processCount;
            int added = 0;
            ArrayList<PRCProcessInfo> toRemove = new ArrayList<PRCProcessInfo>();
            for (PRCProcessInfo emptyProcess : emptyProcesses) {
                if (!this.inputProducesOutput(emptyProcess.process(), sourceStack, emptyProcess.outputSlot(), this.outputGasTank, true)) continue;
                recipeProcessInfo.processes.add(emptyProcess);
                toRemove.add(emptyProcess);
                if (++added < emptyToAdd) continue;
                break;
            }
            emptyProcesses.removeAll(toRemove);
            if (!emptyProcesses.isEmpty()) continue;
            break;
        }
    }

    private void distributeItems(Map<HashedItem, PRCRecipeProcessInfo> processes) {
        for (Map.Entry<HashedItem, PRCRecipeProcessInfo> entry : processes.entrySet()) {
            HashedItem item;
            int maxStackSize;
            int numberPerSlot;
            PRCRecipeProcessInfo recipeProcessInfo = entry.getValue();
            int processCount = recipeProcessInfo.processes.size();
            if (processCount == 1 || (numberPerSlot = recipeProcessInfo.totalCount / processCount) == (maxStackSize = (item = entry.getKey()).getMaxStackSize())) continue;
            int remainder = recipeProcessInfo.totalCount % processCount;
            int minPerSlot = recipeProcessInfo.getMinPerSlot();
            if (minPerSlot > 1) {
                int perSlotRemainder = numberPerSlot % minPerSlot;
                if (perSlotRemainder > 0) {
                    numberPerSlot -= perSlotRemainder;
                    remainder += perSlotRemainder * processCount;
                }
                if (numberPerSlot + minPerSlot > maxStackSize) {
                    minPerSlot = maxStackSize - numberPerSlot;
                }
            }
            for (int i = 0; i < processCount; ++i) {
                PRCProcessInfo processInfo = recipeProcessInfo.processes.get(i);
                AdvancedFactoryInputInventorySlot inputSlot = processInfo.inputSlot();
                int sizeForSlot = numberPerSlot;
                if (remainder > 0) {
                    if (remainder > minPerSlot) {
                        sizeForSlot += minPerSlot;
                        remainder -= minPerSlot;
                    } else {
                        sizeForSlot += remainder;
                        remainder = 0;
                    }
                }
                if (inputSlot.isEmpty()) {
                    if (sizeForSlot <= 0) continue;
                    inputSlot.setStackUnchecked(item.createStack(sizeForSlot));
                    continue;
                }
                if (sizeForSlot == 0) {
                    inputSlot.setEmpty();
                    continue;
                }
                if (inputSlot.getCount() == sizeForSlot) continue;
                MekanismUtils.logMismatchedStackSize((long)sizeForSlot, (long)inputSlot.setStackSize(sizeForSlot, Action.EXECUTE));
            }
        }
    }

    public record PRCProcessInfo(int process, @NotNull AdvancedFactoryInputInventorySlot inputSlot, @NotNull IInventorySlot outputSlot) {
    }

    public static class PRCRecipeProcessInfo {
        private final List<PRCProcessInfo> processes = new ArrayList<PRCProcessInfo>();
        @Nullable
        private IntSupplier lazyMinPerSlot;
        private int minPerSlot = 1;
        private int totalCount;

        public int getMinPerSlot() {
            if (this.lazyMinPerSlot != null) {
                this.minPerSlot = this.lazyMinPerSlot.getAsInt();
                this.lazyMinPerSlot = null;
            }
            return this.minPerSlot;
        }
    }
}

