/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile;

import com.jerry.mekaf.common.capabilities.energy.AdvancedFactoryEnergyContainer;
import com.jerry.mekaf.common.tile.base.TileEntitySlurryToSlurryFactory;
import com.jerry.mekaf.common.upgrade.FluidSlurryToSlurryUpgradeData;
import com.jerry.mekmm.Mekmm;
import fr.iglee42.evolvedmekanism.tiers.EMFactoryTier;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.FluidSlurryToSlurryRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.TwoInputCachedRecipe;
import mekanism.api.recipes.chemical.FluidChemicalToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityWashingFactory
extends TileEntitySlurryToSlurryFactory<FluidSlurryToSlurryRecipe>
implements IDoubleRecipeLookupHandler.FluidChemicalRecipeLookupHandler<Slurry, SlurryStack, FluidSlurryToSlurryRecipe>,
IHasDumpButton {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    private static final int MAX_FLUID = 10000;
    public BasicFluidTank fluidTank;
    private final IInputHandler<@NotNull FluidStack> fluidInputHandler;
    FluidInventorySlot fluidInputSlot;
    OutputInventorySlot fluidOutputSlot;

    public TileEntityWashingFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        ConfigInfo slurryConfig;
        this.addSupported(TransmissionType.FLUID);
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.INPUT, (ISlotInfo)new InventorySlotInfo(true, false, new IInventorySlot[]{this.fluidInputSlot}));
            itemConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new InventorySlotInfo(false, true, new IInventorySlot[]{this.fluidOutputSlot}));
            itemConfig.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.fluidInputSlot, this.fluidOutputSlot}));
            itemConfig.setDefaults();
        }
        if ((slurryConfig = this.configComponent.getConfig(TransmissionType.SLURRY)) != null) {
            slurryConfig.addSlotInfo(DataType.INPUT, (ISlotInfo)new ChemicalSlotInfo.SlurrySlotInfo(true, false, this.inputSlurryTanks));
            List ioTank = this.outputSlurryTanks;
            ioTank.addAll(this.inputSlurryTanks);
            slurryConfig.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new ChemicalSlotInfo.SlurrySlotInfo(true, true, ioTank));
        }
        this.configComponent.setupInputConfig(TransmissionType.FLUID, (Object)this.fluidTank);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.SLURRY}).setCanTankEject(tank -> !this.inputSlurryTanks.contains(tank));
        this.fluidInputHandler = InputHelper.getInputHandler((IExtendedFluidTank)this.fluidTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    }

    @Override
    @Nullable
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig(() -> ((TileEntityWashingFactory)this).getDirection(), () -> ((TileEntityWashingFactory)this).getConfig());
        this.fluidTank = BasicFluidTank.input((int)(10000 * this.tier.processes * this.tier.processes), arg_0 -> ((TileEntityWashingFactory)this).containsRecipeA(arg_0), (IContentsListener)this.markAllMonitorsChanged(listener));
        builder.addTank((IExtendedFluidTank)this.fluidTank);
        return builder.build();
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.fluidInputSlot = FluidInventorySlot.fill((IExtendedFluidTank)this.fluidTank, (IContentsListener)listener, (int)this.getFluidSlotX(), (int)71);
        builder.addSlot((IInventorySlot)this.fluidInputSlot);
        this.fluidOutputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)this.getFluidSlotX(), (int)102);
        builder.addSlot((IInventorySlot)this.fluidOutputSlot);
        this.fluidInputSlot.setSlotOverlay(SlotOverlay.MINUS);
    }

    private int getFluidSlotX() {
        if (Mekmm.hooks.EMLoaded && this.tier.ordinal() >= EMFactoryTier.OVERCLOCKED.ordinal()) {
            int index = this.tier.ordinal() - 4;
            return 180 + 36 * (index + 2) + 2 * index;
        }
        return this.tier == FactoryTier.ULTIMATE ? 214 : 180;
    }

    public BasicFluidTank getFluidTankBar() {
        return this.fluidTank;
    }

    @Override
    public boolean hasExtrasResourceBar() {
        return true;
    }

    @Override
    protected void handleExtrasFuel() {
        this.fluidInputSlot.fillTank((IInventorySlot)this.fluidOutputSlot);
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<FluidSlurryToSlurryRecipe> cached, @NotNull SlurryStack stack) {
        return false;
    }

    @Override
    @Nullable
    protected FluidSlurryToSlurryRecipe findRecipe(int process, @NotNull SlurryStack fallbackInput, @NotNull ISlurryTank outputTanks) {
        FluidStack inputA = this.fluidTank.getFluid();
        SlurryStack output = (SlurryStack)outputTanks.getStack();
        return (FluidSlurryToSlurryRecipe)((InputRecipeCache.FluidChemical)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.f_58857_, (Object)inputA, (Object)fallbackInput, recipe -> output.isTypeEqual(recipe.getOutput(inputA, (ChemicalStack)fallbackInput)));
    }

    @Override
    public boolean isChemicalValidForTank(@NotNull SlurryStack stack) {
        return this.containsRecipeAB(this.fluidTank.getFluid(), stack);
    }

    @Override
    public boolean isValidInputChemical(@NotNull SlurryStack stack) {
        return this.containsRecipeB(stack);
    }

    @Override
    protected int getNeededInput(FluidSlurryToSlurryRecipe recipe, SlurryStack inputStack) {
        return MathUtils.clampToInt((long)((ChemicalStackIngredient.SlurryStackIngredient)recipe.getChemicalInput()).getNeededAmount((Object)inputStack));
    }

    @NotNull
    public IMekanismRecipeTypeProvider<FluidSlurryToSlurryRecipe, InputRecipeCache.FluidChemical<Slurry, SlurryStack, FluidSlurryToSlurryRecipe>> getRecipeType() {
        return MekanismRecipeType.WASHING;
    }

    @Nullable
    public FluidSlurryToSlurryRecipe getRecipe(int cacheIndex) {
        return (FluidSlurryToSlurryRecipe)this.findFirstRecipe(this.fluidInputHandler, this.slurryInputHandlers[cacheIndex]);
    }

    @NotNull
    public CachedRecipe<FluidSlurryToSlurryRecipe> createNewCachedRecipe(@NotNull FluidSlurryToSlurryRecipe recipe, int cacheIndex) {
        return TwoInputCachedRecipe.fluidChemicalToChemical((FluidChemicalToChemicalRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors[cacheIndex], this.fluidInputHandler, (IInputHandler)this.slurryInputHandlers[cacheIndex], (IOutputHandler)this.slurryOutputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((AdvancedFactoryEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setBaselineMaxOperations(this::getBaselineMaxOperations).setOnFinish(() -> ((TileEntityWashingFactory)this).markForSave());
    }

    @Override
    protected void sortInventoryOrTank() {
    }

    @Override
    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof FluidSlurryToSlurryUpgradeData) {
            FluidSlurryToSlurryUpgradeData data = (FluidSlurryToSlurryUpgradeData)upgradeData;
            super.parseUpgradeData(upgradeData);
            this.fluidTank.deserializeNBT(data.inputTank.serializeNBT());
            this.fluidInputSlot.deserializeNBT(data.fluidInputSlot.serializeNBT());
            this.fluidOutputSlot.deserializeNBT(data.fluidOutputSlot.serializeNBT());
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @Nullable
    public IUpgradeData getUpgradeData() {
        return new FluidSlurryToSlurryUpgradeData(this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, null, this.energySlot, this.fluidInputSlot, this.fluidOutputSlot, this.inputSlurryTanks, this.fluidTank, this.outputSlurryTanks, this.isSorting(), this.getComponents());
    }

    public void dump() {
        this.fluidTank.setEmpty();
    }
}

