/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile.base;

import com.jerry.mekaf.common.block.attribute.AttributeAdvancedFactoryType;
import com.jerry.mekaf.common.capabilities.energy.AdvancedFactoryEnergyContainer;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactoryType;
import com.jerry.mekaf.common.registries.AdvancedFactoryTileEntityTypes;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.BoxedChemicalInputHandler;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.BoxedChemicalOutputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.monitor.FactoryRecipeCacheLookupMonitor;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityAdvancedFactoryBase<RECIPE extends MekanismRecipe>
extends TileEntityConfigurableMachine
implements IRecipeLookupHandler<RECIPE>,
ISustainedData {
    protected static final int BASE_TICKS_REQUIRED = 200;
    protected FactoryRecipeCacheLookupMonitor<RECIPE>[] recipeCacheLookupMonitors;
    protected BooleanSupplier[] recheckAllRecipeErrors;
    protected final ErrorTracker errorTracker;
    private final boolean[] activeStates;
    public FactoryTier tier;
    public final int[] progress;
    private int ticksRequired = 200;
    private int baselineMaxOperations = 1;
    protected boolean sorting;
    private boolean sortingNeeded = true;
    private FloatingLong lastUsage = FloatingLong.ZERO;
    @NotNull
    protected final AdvancedFactoryType type;
    protected AdvancedFactoryEnergyContainer energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    protected EnergyInventorySlot energySlot;
    protected IInputHandler<@NotNull ItemStack>[] itemInputHandlers;
    protected IOutputHandler<@NotNull ItemStack>[] itemOutputHandlers;
    protected IInputHandler<@NotNull GasStack>[] gasInputHandlers;
    protected IOutputHandler<@NotNull GasStack>[] gasOutputHandlers;
    protected IInputHandler<@NotNull InfusionStack>[] infusionInputHandlers;
    protected IOutputHandler<@NotNull InfusionStack>[] infusionOutputHandlers;
    protected IInputHandler<@NotNull PigmentStack>[] pigmentInputHandlers;
    protected IOutputHandler<@NotNull PigmentStack>[] pigmentOutputHandlers;
    protected IInputHandler<@NotNull SlurryStack>[] slurryInputHandlers;
    protected IOutputHandler<@NotNull SlurryStack>[] slurryOutputHandlers;
    protected BoxedChemicalInputHandler[] mergedInputHandlers;
    protected BoxedChemicalOutputHandler[] mergedOutputHandlers;
    protected IInputHandler<@NotNull FluidStack>[] fluidInputHandlers;
    protected IOutputHandler<@NotNull FluidStack>[] fluidOutputHandlers;

    protected TileEntityAdvancedFactoryBase(IBlockProvider blockProvider, BlockPos pos, BlockState state, List<CachedRecipe.OperationTracker.RecipeError> errorTypes, Set<CachedRecipe.OperationTracker.RecipeError> globalErrorTypes) {
        super(blockProvider, pos, state);
        this.type = Objects.requireNonNull((AttributeAdvancedFactoryType)Attribute.get((IBlockProvider)blockProvider, AttributeAdvancedFactoryType.class)).getAdvancedFactoryType();
        this.configComponent = new TileComponentConfig((TileEntityMekanism)this, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.ENERGY});
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, (Object)this.energyContainer);
        this.progress = new int[this.tier.processes];
        this.activeStates = new boolean[this.tier.processes];
        this.recheckAllRecipeErrors = new BooleanSupplier[this.tier.processes];
        for (int i = 0; i < this.recheckAllRecipeErrors.length; ++i) {
            this.recheckAllRecipeErrors[i] = TileEntityRecipeMachine.shouldRecheckAllErrors((TileEntityMekanism)this);
        }
        this.errorTracker = new ErrorTracker(errorTypes, globalErrorTypes, this.tier.processes);
    }

    protected void addSupported(TransmissionType ... types) {
        for (TransmissionType type : types) {
            this.configComponent.addSupported(type);
        }
    }

    protected IContentsListener markAllMonitorsChanged(IContentsListener listener) {
        return () -> {
            listener.onContentsChanged();
            for (FactoryRecipeCacheLookupMonitor<RECIPE> cacheLookupMonitor : this.recipeCacheLookupMonitors) {
                cacheLookupMonitor.onChange();
            }
        };
    }

    protected void presetVariables() {
        super.presetVariables();
        this.tier = (FactoryTier)Attribute.getTier((Block)this.getBlockType(), FactoryTier.class);
        Runnable setSortingNeeded = () -> {
            this.sortingNeeded = true;
        };
        this.recipeCacheLookupMonitors = new FactoryRecipeCacheLookupMonitor[this.tier.processes];
        for (int i = 0; i < this.recipeCacheLookupMonitors.length; ++i) {
            this.recipeCacheLookupMonitors[i] = new FactoryRecipeCacheLookupMonitor((IRecipeLookupHandler)this, i, setSortingNeeded);
        }
    }

    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideGasWithConfig(() -> ((TileEntityAdvancedFactoryBase)this).getDirection(), () -> ((TileEntityAdvancedFactoryBase)this).getConfig());
        this.addGasTanks((ChemicalTankHelper<Gas, GasStack, IGasTank>)builder, listener, () -> {
            listener.onContentsChanged();
            this.sortingNeeded = true;
        });
        return builder.build();
    }

    public IChemicalTankHolder<InfuseType, InfusionStack, IInfusionTank> getInitialInfusionTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideInfusionWithConfig(() -> ((TileEntityAdvancedFactoryBase)this).getDirection(), () -> ((TileEntityAdvancedFactoryBase)this).getConfig());
        this.addInfusionTanks((ChemicalTankHelper<InfuseType, InfusionStack, IInfusionTank>)builder, listener, () -> {
            listener.onContentsChanged();
            this.sortingNeeded = true;
        });
        return builder.build();
    }

    @Nullable
    public IChemicalTankHolder<Pigment, PigmentStack, IPigmentTank> getInitialPigmentTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSidePigmentWithConfig(() -> ((TileEntityAdvancedFactoryBase)this).getDirection(), () -> ((TileEntityAdvancedFactoryBase)this).getConfig());
        this.addPigmentTanks((ChemicalTankHelper<Pigment, PigmentStack, IPigmentTank>)builder, listener, () -> {
            listener.onContentsChanged();
            this.sortingNeeded = true;
        });
        return builder.build();
    }

    @Nullable
    public IChemicalTankHolder<Slurry, SlurryStack, ISlurryTank> getInitialSlurryTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideSlurryWithConfig(() -> ((TileEntityAdvancedFactoryBase)this).getDirection(), () -> ((TileEntityAdvancedFactoryBase)this).getConfig());
        this.addSlurryTanks((ChemicalTankHelper<Slurry, SlurryStack, ISlurryTank>)builder, listener, () -> {
            listener.onContentsChanged();
            this.sortingNeeded = true;
        });
        return builder.build();
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(() -> ((TileEntityAdvancedFactoryBase)this).getDirection(), () -> ((TileEntityAdvancedFactoryBase)this).getConfig());
        this.energyContainer = AdvancedFactoryEnergyContainer.input(this, listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Nullable
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig(() -> ((TileEntityAdvancedFactoryBase)this).getDirection(), () -> ((TileEntityAdvancedFactoryBase)this).getConfig());
        this.addFluidTanks(builder, listener, () -> {
            listener.onContentsChanged();
            this.sortingNeeded = true;
        });
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(() -> ((TileEntityAdvancedFactoryBase)this).getDirection(), () -> ((TileEntityAdvancedFactoryBase)this).getConfig());
        this.addSlots(builder, listener, () -> {
            listener.onContentsChanged();
            this.sortingNeeded = true;
        });
        this.energySlot = EnergyInventorySlot.fillOrConvert((IEnergyContainer)this.energyContainer, () -> ((TileEntityAdvancedFactoryBase)this).m_58904_(), (IContentsListener)listener, (int)7, (int)13);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    protected abstract void addSlots(InventorySlotHelper var1, IContentsListener var2, IContentsListener var3);

    protected void addFluidTanks(FluidTankHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
    }

    protected void addGasTanks(ChemicalTankHelper<Gas, GasStack, IGasTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
    }

    protected void addInfusionTanks(ChemicalTankHelper<InfuseType, InfusionStack, IInfusionTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
    }

    protected void addPigmentTanks(ChemicalTankHelper<Pigment, PigmentStack, IPigmentTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
    }

    protected void addSlurryTanks(ChemicalTankHelper<Slurry, SlurryStack, ISlurryTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
    }

    public IGasTank getGasTankBar() {
        return null;
    }

    public int getXPos(int index) {
        int baseX;
        int n = this.tier == FactoryTier.BASIC ? 55 : (this.tier == FactoryTier.ADVANCED ? 35 : (baseX = this.tier == FactoryTier.ELITE ? 29 : 27));
        int baseXMult = this.tier == FactoryTier.BASIC ? 38 : (this.tier == FactoryTier.ADVANCED ? 26 : 19);
        return baseX + index * baseXMult;
    }

    public AdvancedFactoryType getAdvancedFactoryType() {
        return this.type;
    }

    public FloatingLong getRecipeEnergyRequired() {
        return FloatingLong.ZERO;
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.handleExtrasFuel();
        if (this.sortingNeeded && this.isSorting()) {
            this.sortingNeeded = false;
            this.sortInventoryOrTank();
        } else if (!this.sortingNeeded && CommonWorldTickHandler.flushTagAndRecipeCaches) {
            this.sortingNeeded = true;
        }
        FloatingLong prev = this.energyContainer.getEnergy().copy();
        for (int i = 0; i < this.recipeCacheLookupMonitors.length; ++i) {
            if (this.recipeCacheLookupMonitors[i].updateAndProcess()) continue;
            this.activeStates[i] = false;
        }
        boolean isActive = false;
        for (boolean state : this.activeStates) {
            if (!state) continue;
            isActive = true;
            break;
        }
        this.setActive(isActive);
        this.lastUsage = isActive ? prev.minusEqual(this.energyContainer.getEnergy()) : FloatingLong.ZERO;
    }

    @Nullable
    protected CachedRecipe<RECIPE> getCachedRecipe(int cacheIndex) {
        return this.recipeCacheLookupMonitors[cacheIndex].getCachedRecipe(cacheIndex);
    }

    public BooleanSupplier getWarningCheck(CachedRecipe.OperationTracker.RecipeError error, int processIndex) {
        return this.errorTracker.getWarningCheck(error, processIndex);
    }

    public void clearRecipeErrors(int cacheIndex) {
        Arrays.fill(this.errorTracker.trackedErrors[cacheIndex], false);
    }

    protected void setActiveState(boolean state, int cacheIndex) {
        this.activeStates[cacheIndex] = state;
    }

    protected void handleExtrasFuel() {
    }

    public int getProgress(int cacheIndex) {
        return this.progress[cacheIndex];
    }

    public int getSavedOperatingTicks(int cacheIndex) {
        return this.getProgress(cacheIndex);
    }

    public double getScaledProgress(int i, int process) {
        return (double)this.getProgress(process) * (double)i / (double)this.ticksRequired;
    }

    public void toggleSorting() {
        this.sorting = !this.isSorting();
        this.markForSave();
    }

    @ComputerMethod(nameOverride="isAutoSortEnabled")
    public boolean isSorting() {
        return this.sorting;
    }

    @NotNull
    @ComputerMethod(nameOverride="getEnergyUsage", methodDescription="Get the energy used in the last tick by the machine")
    public FloatingLong getLastUsage() {
        return this.lastUsage;
    }

    @ComputerMethod(methodDescription="Total number of ticks it takes currently for the recipe to complete")
    public int getTicksRequired() {
        return this.ticksRequired;
    }

    public int getBaselineMaxOperations() {
        return this.baselineMaxOperations;
    }

    public void setTicksRequired(int value) {
        this.ticksRequired = value;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("progress", 11)) {
            int[] savedProgress = nbt.m_128465_("progress");
            if (this.tier.processes != savedProgress.length) {
                Arrays.fill(this.progress, 0);
            }
            for (int i = 0; i < this.tier.processes && i < savedProgress.length; ++i) {
                this.progress[i] = savedProgress[i];
            }
        }
    }

    public void m_183515_(@NotNull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        nbtTags.m_128365_("progress", (Tag)new IntArrayTag(Arrays.copyOf(this.progress, this.progress.length)));
    }

    public void writeSustainedData(CompoundTag data) {
        data.m_128379_("sorting", this.isSorting());
    }

    public void readSustainedData(CompoundTag data) {
        NBTUtils.setBooleanIfPresent((CompoundTag)data, (String)"sorting", value -> {
            this.sorting = value;
        });
    }

    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("sorting", "sorting");
        return remap;
    }

    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks((IUpgradeTile)this, (int)200);
            this.baselineMaxOperations = (int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        }
    }

    @NotNull
    public List<Component> getInfo(@NotNull Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo((IUpgradeTile)this, (Upgrade)upgrade);
    }

    public boolean isConfigurationDataCompatible(BlockEntityType<?> tileType) {
        if (super.isConfigurationDataCompatible(tileType)) {
            return true;
        }
        for (FactoryTier factoryTier : EnumUtils.FACTORY_TIERS) {
            if (factoryTier == this.tier || AdvancedFactoryTileEntityTypes.getAdvancedFactoryTile(factoryTier, this.type).get() != tileType) continue;
            return true;
        }
        return this.type.getBaseMachine().getTileType().get() == tileType;
    }

    public boolean hasExtrasResourceBar() {
        return false;
    }

    public AdvancedFactoryEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.trackArray(this.progress);
        this.errorTracker.track(container);
        container.track((ISyncableData)SyncableFloatingLong.create(this::getLastUsage, value -> {
            this.lastUsage = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::isSorting, value -> {
            this.sorting = value;
        }));
        container.track((ISyncableData)SyncableInt.create(this::getTicksRequired, value -> {
            this.ticksRequired = value;
        }));
    }

    protected abstract void sortInventoryOrTank();

    protected static class ErrorTracker {
        private final List<CachedRecipe.OperationTracker.RecipeError> errorTypes;
        private final IntSet globalTypes;
        private final boolean[][] trackedErrors;
        private final int processes;

        public ErrorTracker(List<CachedRecipe.OperationTracker.RecipeError> errorTypes, Set<CachedRecipe.OperationTracker.RecipeError> globalErrorTypes, int processes) {
            this.errorTypes = List.copyOf(errorTypes);
            this.globalTypes = new IntArraySet(globalErrorTypes.size());
            for (int i = 0; i < this.errorTypes.size(); ++i) {
                CachedRecipe.OperationTracker.RecipeError error = this.errorTypes.get(i);
                if (!globalErrorTypes.contains(error)) continue;
                this.globalTypes.add(i);
            }
            this.processes = processes;
            this.trackedErrors = new boolean[this.processes][];
            int errors = this.errorTypes.size();
            for (int i = 0; i < this.trackedErrors.length; ++i) {
                this.trackedErrors[i] = new boolean[errors];
            }
        }

        private void track(MekanismContainer container) {
            container.trackArray(this.trackedErrors);
        }

        public void onErrorsChanged(Set<CachedRecipe.OperationTracker.RecipeError> errors, int processIndex) {
            boolean[] processTrackedErrors = this.trackedErrors[processIndex];
            for (int i = 0; i < processTrackedErrors.length; ++i) {
                processTrackedErrors[i] = errors.contains(this.errorTypes.get(i));
            }
        }

        private BooleanSupplier getWarningCheck(CachedRecipe.OperationTracker.RecipeError error, int processIndex) {
            int errorIndex;
            if (processIndex >= 0 && processIndex < this.processes && (errorIndex = this.errorTypes.indexOf(error)) >= 0) {
                if (this.globalTypes.contains(errorIndex)) {
                    return () -> Arrays.stream(this.trackedErrors).anyMatch(processTrackedErrors -> processTrackedErrors[errorIndex]);
                }
                return () -> this.trackedErrors[processIndex][errorIndex];
            }
            return () -> false;
        }
    }
}

