/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile.base;

import com.jerry.mekaf.common.inventory.slot.AdvancedFactoryInputInventorySlot;
import com.jerry.mekaf.common.tile.base.TileEntityAdvancedFactoryBase;
import com.jerry.mekaf.common.upgrade.ItemToFluidUpgradeData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntSupplier;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.FluidSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityItemToFluidFactory<RECIPE extends MekanismRecipe>
extends TileEntityAdvancedFactoryBase<RECIPE> {
    private static final int MAX_FLUID = 10000;
    protected I2FProcessInfo[] processInfoSlots;
    AdvancedFactoryInputInventorySlot[] inputSlot;
    IExtendedFluidTank[] outputTank;
    protected final List<IInventorySlot> inputItemSlots = new ArrayList<IInventorySlot>();
    public final List<IExtendedFluidTank> outputFluidTanks = new ArrayList<IExtendedFluidTank>();

    protected TileEntityItemToFluidFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state, List<CachedRecipe.OperationTracker.RecipeError> errorTypes, Set<CachedRecipe.OperationTracker.RecipeError> globalErrorTypes) {
        super(blockProvider, pos, state, errorTypes, globalErrorTypes);
        this.processInfoSlots = new I2FProcessInfo[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            this.processInfoSlots[i] = new I2FProcessInfo(i, this.inputSlot[i], this.outputTank[i]);
        }
        for (I2FProcessInfo info : this.processInfoSlots) {
            this.inputItemSlots.add((IInventorySlot)info.inputSlot());
            this.outputFluidTanks.add(info.outputTank());
        }
        this.configComponent.addSupported(TransmissionType.FLUID);
        ConfigInfo gasConfig = this.configComponent.getConfig(TransmissionType.FLUID);
        if (gasConfig != null) {
            gasConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new FluidSlotInfo(false, true, this.outputFluidTanks));
            gasConfig.setDataType(DataType.OUTPUT, new RelativeSide[]{RelativeSide.RIGHT});
            gasConfig.setEjecting(true);
        }
        this.configComponent.setupItemIOConfig(this.inputItemSlots, Collections.emptyList(), (IInventorySlot)this.energySlot, false);
    }

    @Override
    protected void addFluidTanks(FluidTankHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.outputTank = new IExtendedFluidTank[this.tier.processes];
        this.fluidOutputHandlers = new IOutputHandler[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            this.outputTank[i] = BasicFluidTank.output((int)(10000 * this.tier.processes), (IContentsListener)listener);
            builder.addTank(this.outputTank[i]);
            this.fluidOutputHandlers[i] = OutputHelper.getOutputHandler((IExtendedFluidTank)this.outputTank[i], (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
        }
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.inputSlot = new AdvancedFactoryInputInventorySlot[this.tier.processes];
        this.itemInputHandlers = new IInputHandler[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            this.inputSlot[i] = AdvancedFactoryInputInventorySlot.create(this, i, this.outputTank[i], (IContentsListener)this.recipeCacheLookupMonitors[i], this.getXPos(i), 13);
            int index = i;
            ((AdvancedFactoryInputInventorySlot)builder.addSlot((IInventorySlot)this.inputSlot[i])).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, index)));
            this.itemInputHandlers[i] = InputHelper.getInputHandler((IInventorySlot)this.inputSlot[i], (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        }
    }

    public boolean inputProducesOutput(int process, @NotNull ItemStack fallbackInput, @NotNull IExtendedFluidTank outputTank, boolean updateCache) {
        return outputTank.getFluid().isEmpty() || this.getRecipeForInput(process, fallbackInput, outputTank, updateCache) != null;
    }

    @Contract(value="null, _ -> false")
    protected abstract boolean isCachedRecipeValid(@Nullable CachedRecipe<RECIPE> var1, @NotNull ItemStack var2);

    @Nullable
    protected RECIPE getRecipeForInput(int process, @NotNull ItemStack fallbackInput, @Nullable IExtendedFluidTank outputTank, boolean updateCache) {
        CachedRecipe cached;
        if (!CommonWorldTickHandler.flushTagAndRecipeCaches && (cached = this.getCachedRecipe(process)) != null && this.isCachedRecipeValid(cached, fallbackInput)) {
            return (RECIPE)cached.getRecipe();
        }
        RECIPE foundRecipe = this.findRecipe(process, fallbackInput, outputTank);
        if (foundRecipe == null) {
            return null;
        }
        if (updateCache) {
            this.recipeCacheLookupMonitors[process].updateCachedRecipe(foundRecipe);
        }
        return foundRecipe;
    }

    @Nullable
    protected abstract RECIPE findRecipe(int var1, @NotNull ItemStack var2, @NotNull IExtendedFluidTank var3);

    public abstract boolean isValidInputItem(@NotNull ItemStack var1);

    protected abstract int getNeededInput(RECIPE var1, ItemStack var2);

    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof ItemToFluidUpgradeData) {
            int i;
            ItemToFluidUpgradeData data = (ItemToFluidUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.energySlot.deserializeNBT(data.energySlot.serializeNBT());
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputSlots.size(); ++i) {
                this.inputItemSlots.get(i).deserializeNBT((Tag)((CompoundTag)data.inputSlots.get(i).serializeNBT()));
            }
            for (i = 0; i < data.outputTanks.size(); ++i) {
                this.outputFluidTanks.get(i).setStack(data.outputTanks.get(i).getFluid());
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    protected void sortInventoryOrTank() {
        HashMap<HashedItem, I2FRecipeProcessInfo> processes = new HashMap<HashedItem, I2FRecipeProcessInfo>();
        ArrayList<I2FProcessInfo> emptyProcesses = new ArrayList<I2FProcessInfo>();
        for (I2FProcessInfo processInfo : this.processInfoSlots) {
            CachedRecipe cachedRecipe;
            AdvancedFactoryInputInventorySlot inputSlot = processInfo.inputSlot();
            if (inputSlot.isEmpty()) {
                emptyProcesses.add(processInfo);
                continue;
            }
            ItemStack inputStack = inputSlot.getStack();
            HashedItem item = HashedItem.raw((ItemStack)inputStack);
            I2FRecipeProcessInfo recipeProcessInfo = processes.computeIfAbsent(item, i -> new I2FRecipeProcessInfo());
            recipeProcessInfo.processes.add(processInfo);
            recipeProcessInfo.totalCount += inputStack.m_41613_();
            if (recipeProcessInfo.lazyMinPerSlot != null || CommonWorldTickHandler.flushTagAndRecipeCaches || !this.isCachedRecipeValid(cachedRecipe = this.getCachedRecipe(processInfo.process()), inputStack)) continue;
            recipeProcessInfo.lazyMinPerSlot = () -> Math.max(1, this.getNeededInput(cachedRecipe.getRecipe(), inputStack));
        }
        if (processes.isEmpty()) {
            return;
        }
        for (Map.Entry entry : processes.entrySet()) {
            I2FRecipeProcessInfo recipeProcessInfo = (I2FRecipeProcessInfo)entry.getValue();
            if (recipeProcessInfo.lazyMinPerSlot != null) continue;
            recipeProcessInfo.lazyMinPerSlot = () -> {
                HashedItem item = (HashedItem)entry.getKey();
                ItemStack largerInput = item.createStack(Math.min(item.getMaxStackSize(), recipeProcessInfo.totalCount));
                I2FProcessInfo processInfo = recipeProcessInfo.processes.get(0);
                RECIPE recipe = this.getRecipeForInput(processInfo.process(), largerInput, processInfo.outputTank, true);
                if (recipe != null) {
                    return Math.max(1, this.getNeededInput(recipe, largerInput));
                }
                return 1;
            };
        }
        if (!emptyProcesses.isEmpty()) {
            this.addEmptySlotsAsTargets(processes, emptyProcesses);
        }
        this.distributeItems(processes);
    }

    private void addEmptySlotsAsTargets(Map<HashedItem, I2FRecipeProcessInfo> processes, List<I2FProcessInfo> emptyProcesses) {
        for (Map.Entry<HashedItem, I2FRecipeProcessInfo> entry : processes.entrySet()) {
            int processCount;
            I2FRecipeProcessInfo recipeProcessInfo = entry.getValue();
            int minPerSlot = recipeProcessInfo.getMinPerSlot();
            int maxSlots = recipeProcessInfo.totalCount / minPerSlot;
            if (maxSlots <= 1 || maxSlots <= (processCount = recipeProcessInfo.processes.size())) continue;
            ItemStack sourceStack = entry.getKey().getInternalStack();
            int emptyToAdd = maxSlots - processCount;
            int added = 0;
            ArrayList<I2FProcessInfo> toRemove = new ArrayList<I2FProcessInfo>();
            for (I2FProcessInfo emptyProcess : emptyProcesses) {
                if (!this.inputProducesOutput(emptyProcess.process(), sourceStack, emptyProcess.outputTank(), true)) continue;
                recipeProcessInfo.processes.add(emptyProcess);
                toRemove.add(emptyProcess);
                if (++added < emptyToAdd) continue;
                break;
            }
            emptyProcesses.removeAll(toRemove);
            if (!emptyProcesses.isEmpty()) continue;
            break;
        }
    }

    private void distributeItems(Map<HashedItem, I2FRecipeProcessInfo> processes) {
        for (Map.Entry<HashedItem, I2FRecipeProcessInfo> entry : processes.entrySet()) {
            HashedItem item;
            int maxStackSize;
            int numberPerSlot;
            I2FRecipeProcessInfo recipeProcessInfo = entry.getValue();
            int processCount = recipeProcessInfo.processes.size();
            if (processCount == 1 || (numberPerSlot = recipeProcessInfo.totalCount / processCount) == (maxStackSize = (item = entry.getKey()).getMaxStackSize())) continue;
            int remainder = recipeProcessInfo.totalCount % processCount;
            int minPerSlot = recipeProcessInfo.getMinPerSlot();
            if (minPerSlot > 1) {
                int perSlotRemainder = numberPerSlot % minPerSlot;
                if (perSlotRemainder > 0) {
                    numberPerSlot -= perSlotRemainder;
                    remainder += perSlotRemainder * processCount;
                }
                if (numberPerSlot + minPerSlot > maxStackSize) {
                    minPerSlot = maxStackSize - numberPerSlot;
                }
            }
            for (int i = 0; i < processCount; ++i) {
                I2FProcessInfo processInfo = recipeProcessInfo.processes.get(i);
                AdvancedFactoryInputInventorySlot inputSlot = processInfo.inputSlot();
                int sizeForSlot = numberPerSlot;
                if (remainder > 0) {
                    if (remainder > minPerSlot) {
                        sizeForSlot += minPerSlot;
                        remainder -= minPerSlot;
                    } else {
                        sizeForSlot += remainder;
                        remainder = 0;
                    }
                }
                if (inputSlot.isEmpty()) {
                    if (sizeForSlot <= 0) continue;
                    inputSlot.setStackUnchecked(item.createStack(sizeForSlot));
                    continue;
                }
                if (sizeForSlot == 0) {
                    inputSlot.setEmpty();
                    continue;
                }
                if (inputSlot.getCount() == sizeForSlot) continue;
                MekanismUtils.logMismatchedStackSize((long)sizeForSlot, (long)inputSlot.setStackSize(sizeForSlot, Action.EXECUTE));
            }
        }
    }

    public record I2FProcessInfo(int process, @NotNull AdvancedFactoryInputInventorySlot inputSlot, @NotNull IExtendedFluidTank outputTank) {
    }

    public static class I2FRecipeProcessInfo {
        private final List<I2FProcessInfo> processes = new ArrayList<I2FProcessInfo>();
        @Nullable
        private IntSupplier lazyMinPerSlot;
        private int minPerSlot = 1;
        private int totalCount;

        public int getMinPerSlot() {
            if (this.lazyMinPerSlot != null) {
                this.minPerSlot = this.lazyMinPerSlot.getAsInt();
                this.lazyMinPerSlot = null;
            }
            return this.minPerSlot;
        }
    }
}

