/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile.base;

import com.jerry.mekaf.common.inventory.slot.AdvancedFactoryInputInventorySlot;
import com.jerry.mekaf.common.tile.base.TileEntityAdvancedFactoryBase;
import com.jerry.mekaf.common.upgrade.ItemToMergedUpgradeData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntSupplier;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.BoxedChemicalOutputHandler;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityItemToMergedFactory<RECIPE extends MekanismRecipe>
extends TileEntityAdvancedFactoryBase<RECIPE> {
    private static final long MAX_CHEMICAL = 10000L;
    protected ItemToMergedProcessInfo[] processInfoSlots;
    AdvancedFactoryInputInventorySlot[] inputSlot;
    MergedChemicalTank[] outputTank;
    public final List<IInventorySlot> inputItemSlots = new ArrayList<IInventorySlot>();
    public final List<MergedChemicalTank> outputChemicalTanks = new ArrayList<MergedChemicalTank>();
    public final List<IGasTank> outputGasTanks;
    public final List<IInfusionTank> outputInfusionTanks;
    public final List<IPigmentTank> outputPigmentTanks;
    public final List<ISlurryTank> outputSlurryTanks;

    protected TileEntityItemToMergedFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state, List<CachedRecipe.OperationTracker.RecipeError> errorTypes, Set<CachedRecipe.OperationTracker.RecipeError> globalErrorTypes) {
        super(blockProvider, pos, state, errorTypes, globalErrorTypes);
        ConfigInfo slurryConfig;
        ConfigInfo pigmentConfig;
        ConfigInfo infusionConfig;
        this.processInfoSlots = new ItemToMergedProcessInfo[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            this.processInfoSlots[i] = new ItemToMergedProcessInfo(i, this.inputSlot[i], this.outputTank[i]);
        }
        for (ItemToMergedProcessInfo info : this.processInfoSlots) {
            this.inputItemSlots.add((IInventorySlot)info.inputSlot());
            this.outputChemicalTanks.add(info.outputTank());
        }
        this.addSupported(TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.PIGMENT, TransmissionType.SLURRY);
        this.outputGasTanks = new ArrayList<IGasTank>();
        this.outputInfusionTanks = new ArrayList<IInfusionTank>();
        this.outputPigmentTanks = new ArrayList<IPigmentTank>();
        this.outputSlurryTanks = new ArrayList<ISlurryTank>();
        for (MergedChemicalTank tank : this.outputChemicalTanks) {
            this.outputGasTanks.add(tank.getGasTank());
            this.outputInfusionTanks.add(tank.getInfusionTank());
            this.outputPigmentTanks.add(tank.getPigmentTank());
            this.outputSlurryTanks.add(tank.getSlurryTank());
        }
        ConfigInfo gasConfig = this.configComponent.getConfig(TransmissionType.GAS);
        if (gasConfig != null) {
            gasConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new ChemicalSlotInfo.GasSlotInfo(false, true, this.outputGasTanks));
            gasConfig.fill(DataType.INPUT);
            gasConfig.setDataType(DataType.OUTPUT, new RelativeSide[]{RelativeSide.RIGHT});
            gasConfig.setEjecting(true);
        }
        if ((infusionConfig = this.configComponent.getConfig(TransmissionType.INFUSION)) != null) {
            infusionConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new ChemicalSlotInfo.InfusionSlotInfo(false, true, this.outputInfusionTanks));
            infusionConfig.setDataType(DataType.OUTPUT, new RelativeSide[]{RelativeSide.RIGHT});
            infusionConfig.setEjecting(true);
        }
        if ((pigmentConfig = this.configComponent.getConfig(TransmissionType.PIGMENT)) != null) {
            pigmentConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new ChemicalSlotInfo.PigmentSlotInfo(false, true, this.outputPigmentTanks));
            pigmentConfig.setDataType(DataType.OUTPUT, new RelativeSide[]{RelativeSide.RIGHT});
            pigmentConfig.setEjecting(true);
        }
        if ((slurryConfig = this.configComponent.getConfig(TransmissionType.SLURRY)) != null) {
            slurryConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new ChemicalSlotInfo.SlurrySlotInfo(false, true, this.outputSlurryTanks));
            slurryConfig.setDataType(DataType.OUTPUT, new RelativeSide[]{RelativeSide.RIGHT});
            slurryConfig.setEjecting(true);
        }
        this.configComponent.setupItemIOConfig(this.inputItemSlots, Collections.emptyList(), (IInventorySlot)this.energySlot, false);
    }

    @Override
    protected void presetVariables() {
        super.presetVariables();
        this.outputTank = new MergedChemicalTank[this.tier.processes];
        this.mergedOutputHandlers = new BoxedChemicalOutputHandler[this.tier.processes];
        IContentsListener saveOnlyListener = () -> ((TileEntityItemToMergedFactory)this).markForSave();
        for (int i = 0; i < this.tier.processes; ++i) {
            this.outputTank[i] = MergedChemicalTank.create((IGasTank)((IGasTank)ChemicalTankBuilder.GAS.output(10000L * (long)this.tier.processes, this.getListener(SubstanceType.GAS, saveOnlyListener))), (IInfusionTank)((IInfusionTank)ChemicalTankBuilder.INFUSION.output(10000L * (long)this.tier.processes, this.getListener(SubstanceType.INFUSION, saveOnlyListener))), (IPigmentTank)((IPigmentTank)ChemicalTankBuilder.PIGMENT.output(10000L * (long)this.tier.processes, this.getListener(SubstanceType.PIGMENT, saveOnlyListener))), (ISlurryTank)((ISlurryTank)ChemicalTankBuilder.SLURRY.output(10000L * (long)this.tier.processes, this.getListener(SubstanceType.SLURRY, saveOnlyListener))));
            this.mergedOutputHandlers[i] = new BoxedChemicalOutputHandler(this.outputTank[i], CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
        }
    }

    @Override
    protected void addGasTanks(ChemicalTankHelper<Gas, GasStack, IGasTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
        for (int i = 0; i < this.tier.processes; ++i) {
            builder.addTank((IChemicalTank)this.outputTank[i].getGasTank());
        }
    }

    @Override
    protected void addInfusionTanks(ChemicalTankHelper<InfuseType, InfusionStack, IInfusionTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
        for (int i = 0; i < this.tier.processes; ++i) {
            builder.addTank((IChemicalTank)this.outputTank[i].getInfusionTank());
        }
    }

    @Override
    protected void addPigmentTanks(ChemicalTankHelper<Pigment, PigmentStack, IPigmentTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
        for (int i = 0; i < this.tier.processes; ++i) {
            builder.addTank((IChemicalTank)this.outputTank[i].getPigmentTank());
        }
    }

    @Override
    protected void addSlurryTanks(ChemicalTankHelper<Slurry, SlurryStack, ISlurryTank> builder, IContentsListener listener, IContentsListener updateSortingListener) {
        for (int i = 0; i < this.tier.processes; ++i) {
            builder.addTank((IChemicalTank)this.outputTank[i].getSlurryTank());
        }
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.inputSlot = new AdvancedFactoryInputInventorySlot[this.tier.processes];
        this.itemInputHandlers = new IInputHandler[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            this.inputSlot[i] = AdvancedFactoryInputInventorySlot.create(this, i, this.outputTank[i], (IContentsListener)this.recipeCacheLookupMonitors[i], this.getXPos(i), 13);
            int index = i;
            ((AdvancedFactoryInputInventorySlot)builder.addSlot((IInventorySlot)this.inputSlot[i])).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, index)));
            this.itemInputHandlers[i] = InputHelper.getInputHandler((IInventorySlot)this.inputSlot[i], (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        }
    }

    public boolean inputProducesOutput(int process, @NotNull ItemStack fallbackInput, @NotNull MergedChemicalTank outputTank, boolean updateCache) {
        return outputTank.getAllTanks().isEmpty() || this.getRecipeForInput(process, fallbackInput, outputTank, updateCache) != null;
    }

    @Contract(value="null, _ -> false")
    protected abstract boolean isCachedRecipeValid(@Nullable CachedRecipe<RECIPE> var1, @NotNull ItemStack var2);

    @Nullable
    protected RECIPE getRecipeForInput(int process, @NotNull ItemStack fallbackInput, @Nullable MergedChemicalTank outputTank, boolean updateCache) {
        CachedRecipe cached;
        if (!CommonWorldTickHandler.flushTagAndRecipeCaches && (cached = this.getCachedRecipe(process)) != null && this.isCachedRecipeValid(cached, fallbackInput)) {
            return (RECIPE)cached.getRecipe();
        }
        RECIPE foundRecipe = this.findRecipe(process, fallbackInput, outputTank);
        if (foundRecipe == null) {
            return null;
        }
        if (updateCache) {
            this.recipeCacheLookupMonitors[process].updateCachedRecipe(foundRecipe);
        }
        return foundRecipe;
    }

    @Nullable
    protected abstract RECIPE findRecipe(int var1, @NotNull ItemStack var2, @NotNull MergedChemicalTank var3);

    public abstract boolean isValidInputItem(@NotNull ItemStack var1);

    protected abstract int getNeededInput(RECIPE var1, ItemStack var2);

    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof ItemToMergedUpgradeData) {
            int i;
            ItemToMergedUpgradeData data = (ItemToMergedUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.energySlot.deserializeNBT(data.energySlot.serializeNBT());
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputSlots.size(); ++i) {
                this.inputItemSlots.get(i).deserializeNBT((Tag)((CompoundTag)data.inputSlots.get(i).serializeNBT()));
            }
            for (i = 0; i < data.outputTanks.size(); ++i) {
                this.outputChemicalTanks.get(i).getGasTank().setStack((ChemicalStack)((GasStack)data.outputTanks.get(i).getGasTank().getStack()));
                this.outputChemicalTanks.get(i).getInfusionTank().setStack((ChemicalStack)((InfusionStack)data.outputTanks.get(i).getInfusionTank().getStack()));
                this.outputChemicalTanks.get(i).getPigmentTank().setStack((ChemicalStack)((PigmentStack)data.outputTanks.get(i).getPigmentTank().getStack()));
                this.outputChemicalTanks.get(i).getSlurryTank().setStack((ChemicalStack)((SlurryStack)data.outputTanks.get(i).getSlurryTank().getStack()));
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    protected void sortInventoryOrTank() {
        HashMap<HashedItem, ItemToFourMergedRecipeProcessInfo> processes = new HashMap<HashedItem, ItemToFourMergedRecipeProcessInfo>();
        ArrayList<ItemToMergedProcessInfo> emptyProcesses = new ArrayList<ItemToMergedProcessInfo>();
        for (ItemToMergedProcessInfo processInfo : this.processInfoSlots) {
            CachedRecipe cachedRecipe;
            AdvancedFactoryInputInventorySlot inputSlot = processInfo.inputSlot();
            if (inputSlot.isEmpty()) {
                emptyProcesses.add(processInfo);
                continue;
            }
            ItemStack inputStack = inputSlot.getStack();
            HashedItem item = HashedItem.raw((ItemStack)inputStack);
            ItemToFourMergedRecipeProcessInfo recipeProcessInfo = processes.computeIfAbsent(item, i -> new ItemToFourMergedRecipeProcessInfo());
            recipeProcessInfo.processes.add(processInfo);
            recipeProcessInfo.totalCount += inputStack.m_41613_();
            if (recipeProcessInfo.lazyMinPerSlot != null || CommonWorldTickHandler.flushTagAndRecipeCaches || !this.isCachedRecipeValid(cachedRecipe = this.getCachedRecipe(processInfo.process()), inputStack)) continue;
            recipeProcessInfo.lazyMinPerSlot = () -> Math.max(1, this.getNeededInput(cachedRecipe.getRecipe(), inputStack));
        }
        if (processes.isEmpty()) {
            return;
        }
        for (Map.Entry entry : processes.entrySet()) {
            ItemToFourMergedRecipeProcessInfo recipeProcessInfo = (ItemToFourMergedRecipeProcessInfo)entry.getValue();
            if (recipeProcessInfo.lazyMinPerSlot != null) continue;
            recipeProcessInfo.lazyMinPerSlot = () -> {
                HashedItem item = (HashedItem)entry.getKey();
                ItemStack largerInput = item.createStack(Math.min(item.getMaxStackSize(), recipeProcessInfo.totalCount));
                ItemToMergedProcessInfo processInfo = recipeProcessInfo.processes.get(0);
                RECIPE recipe = this.getRecipeForInput(processInfo.process(), largerInput, processInfo.outputTank, true);
                if (recipe != null) {
                    return Math.max(1, this.getNeededInput(recipe, largerInput));
                }
                return 1;
            };
        }
        if (!emptyProcesses.isEmpty()) {
            this.addEmptySlotsAsTargets(processes, emptyProcesses);
        }
        this.distributeItems(processes);
    }

    private void addEmptySlotsAsTargets(Map<HashedItem, ItemToFourMergedRecipeProcessInfo> processes, List<ItemToMergedProcessInfo> emptyProcesses) {
        for (Map.Entry<HashedItem, ItemToFourMergedRecipeProcessInfo> entry : processes.entrySet()) {
            int processCount;
            ItemToFourMergedRecipeProcessInfo recipeProcessInfo = entry.getValue();
            int minPerSlot = recipeProcessInfo.getMinPerSlot();
            int maxSlots = recipeProcessInfo.totalCount / minPerSlot;
            if (maxSlots <= 1 || maxSlots <= (processCount = recipeProcessInfo.processes.size())) continue;
            ItemStack sourceStack = entry.getKey().getInternalStack();
            int emptyToAdd = maxSlots - processCount;
            int added = 0;
            ArrayList<ItemToMergedProcessInfo> toRemove = new ArrayList<ItemToMergedProcessInfo>();
            for (ItemToMergedProcessInfo emptyProcess : emptyProcesses) {
                if (!this.inputProducesOutput(emptyProcess.process(), sourceStack, emptyProcess.outputTank(), true)) continue;
                recipeProcessInfo.processes.add(emptyProcess);
                toRemove.add(emptyProcess);
                if (++added < emptyToAdd) continue;
                break;
            }
            emptyProcesses.removeAll(toRemove);
            if (!emptyProcesses.isEmpty()) continue;
            break;
        }
    }

    private void distributeItems(Map<HashedItem, ItemToFourMergedRecipeProcessInfo> processes) {
        for (Map.Entry<HashedItem, ItemToFourMergedRecipeProcessInfo> entry : processes.entrySet()) {
            HashedItem item;
            int maxStackSize;
            int numberPerSlot;
            ItemToFourMergedRecipeProcessInfo recipeProcessInfo = entry.getValue();
            int processCount = recipeProcessInfo.processes.size();
            if (processCount == 1 || (numberPerSlot = recipeProcessInfo.totalCount / processCount) == (maxStackSize = (item = entry.getKey()).getMaxStackSize())) continue;
            int remainder = recipeProcessInfo.totalCount % processCount;
            int minPerSlot = recipeProcessInfo.getMinPerSlot();
            if (minPerSlot > 1) {
                int perSlotRemainder = numberPerSlot % minPerSlot;
                if (perSlotRemainder > 0) {
                    numberPerSlot -= perSlotRemainder;
                    remainder += perSlotRemainder * processCount;
                }
                if (numberPerSlot + minPerSlot > maxStackSize) {
                    minPerSlot = maxStackSize - numberPerSlot;
                }
            }
            for (int i = 0; i < processCount; ++i) {
                ItemToMergedProcessInfo processInfo = recipeProcessInfo.processes.get(i);
                AdvancedFactoryInputInventorySlot inputSlot = processInfo.inputSlot();
                int sizeForSlot = numberPerSlot;
                if (remainder > 0) {
                    if (remainder > minPerSlot) {
                        sizeForSlot += minPerSlot;
                        remainder -= minPerSlot;
                    } else {
                        sizeForSlot += remainder;
                        remainder = 0;
                    }
                }
                if (inputSlot.isEmpty()) {
                    if (sizeForSlot <= 0) continue;
                    inputSlot.setStackUnchecked(item.createStack(sizeForSlot));
                    continue;
                }
                if (sizeForSlot == 0) {
                    inputSlot.setEmpty();
                    continue;
                }
                if (inputSlot.getCount() == sizeForSlot) continue;
                MekanismUtils.logMismatchedStackSize((long)sizeForSlot, (long)inputSlot.setStackSize(sizeForSlot, Action.EXECUTE));
            }
        }
    }

    public record ItemToMergedProcessInfo(int process, @NotNull AdvancedFactoryInputInventorySlot inputSlot, @NotNull MergedChemicalTank outputTank) {
    }

    public static class ItemToFourMergedRecipeProcessInfo {
        private final List<ItemToMergedProcessInfo> processes = new ArrayList<ItemToMergedProcessInfo>();
        @Nullable
        private IntSupplier lazyMinPerSlot;
        private int minPerSlot = 1;
        private int totalCount;

        public int getMinPerSlot() {
            if (this.lazyMinPerSlot != null) {
                this.minPerSlot = this.lazyMinPerSlot.getAsInt();
                this.lazyMinPerSlot = null;
            }
            return this.minPerSlot;
        }
    }
}

