/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public abstract class RecyclerRecipe
extends MekanismRecipe
implements Predicate<ItemStack> {
    protected static final RandomSource RANDOM = RandomSource.m_216327_();
    private final ItemStackIngredient input;
    private final ItemStack chanceOutput;
    private final double chance;

    public RecyclerRecipe(ResourceLocation id, ItemStackIngredient input, ItemStack chanceOutput, double chance) {
        super(id);
        this.input = Objects.requireNonNull(input, "Input cannot be null.");
        Objects.requireNonNull(chanceOutput, "Output cannot be null.");
        if (chanceOutput.m_41619_()) {
            throw new IllegalArgumentException("Output cannot be null.");
        }
        if (chance < 0.0 || chance > 1.0) {
            throw new IllegalArgumentException("Output chance must be at least zero and at most one.");
        }
        this.chanceOutput = chanceOutput.m_41777_();
        this.chance = chance;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.input.test((Object)stack);
    }

    @Contract(value="_ -> new")
    public ChanceOutput getOutput(ItemStack input) {
        return new ChanceOutput(this.chance > 0.0 ? RANDOM.m_188500_() : 0.0);
    }

    public List<ItemStack> getChanceOutputDefinition() {
        return this.chanceOutput.m_41619_() ? Collections.emptyList() : Collections.singletonList(this.chanceOutput);
    }

    public double getOutputChance() {
        return this.chance;
    }

    public ItemStackIngredient getInput() {
        return this.input;
    }

    public boolean m_142505_() {
        return this.getInput().hasNoMatchingInstances();
    }

    public void logMissingTags() {
        this.input.logMissingTags();
    }

    public void write(FriendlyByteBuf buffer) {
        this.input.write(buffer);
        buffer.m_130055_(this.chanceOutput);
        buffer.writeDouble(this.chance);
    }

    public class ChanceOutput {
        protected final double rand;

        protected ChanceOutput(double rand) {
            this.rand = rand;
        }

        public ItemStack getMaxChanceOutput() {
            return RecyclerRecipe.this.chance > 0.0 ? RecyclerRecipe.this.chanceOutput.m_41777_() : ItemStack.f_41583_;
        }

        public ItemStack getChanceOutput() {
            if (this.rand <= RecyclerRecipe.this.chance) {
                return RecyclerRecipe.this.chanceOutput.m_41777_();
            }
            return ItemStack.f_41583_;
        }

        public ItemStack nextChanceOutput() {
            double rand;
            if (RecyclerRecipe.this.chance > 0.0 && (rand = RANDOM.m_188500_()) <= RecyclerRecipe.this.chance) {
                return RecyclerRecipe.this.chanceOutput.m_41777_();
            }
            return ItemStack.f_41583_;
        }
    }
}

