/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.cache;

import com.jerry.mekmm.api.recipes.PlantingRecipe;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackConstantChemicalToItemStackCachedRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class PlantingCacheRecipe
extends CachedRecipe<PlantingRecipe> {
    private final Predicate<PlantingRecipe.PlantingStationRecipeOutput> outputEmptyCheck;
    private final IOutputHandler<@NotNull PlantingRecipe.PlantingStationRecipeOutput> outputHandler;
    private final IInputHandler<@NotNull ItemStack> itemInputHandler;
    private final ILongInputHandler<GasStack> gasInputHandler;
    private final ItemStackConstantChemicalToItemStackCachedRecipe.ChemicalUsageMultiplier gasUsage;
    private final LongConsumer gasUsedSoFarChanged;
    private long gasUsageMultiplier;
    private long gasUsedSoFar;
    private ItemStack recipeItem = ItemStack.f_41583_;
    @Nullable
    private GasStack recipeGas;
    @Nullable
    private PlantingRecipe.PlantingStationRecipeOutput output;

    public PlantingCacheRecipe(PlantingRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> itemInputHandler, ILongInputHandler<GasStack> gasInputHandler, ItemStackConstantChemicalToItemStackCachedRecipe.ChemicalUsageMultiplier gasUsage, LongConsumer gasUsedSoFarChanged, IOutputHandler<@NotNull PlantingRecipe.PlantingStationRecipeOutput> outputHandler, Predicate<PlantingRecipe.PlantingStationRecipeOutput> outputEmptyCheck) {
        super((MekanismRecipe)recipe, recheckAllErrors);
        this.itemInputHandler = Objects.requireNonNull(itemInputHandler, "Item input handler cannot be null.");
        this.gasInputHandler = Objects.requireNonNull(gasInputHandler, "Gas input handler cannot be null.");
        this.gasUsage = Objects.requireNonNull(gasUsage, "Gas usage cannot be null.");
        this.gasUsedSoFarChanged = Objects.requireNonNull(gasUsedSoFarChanged, "Gas used so far changed handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
        this.outputEmptyCheck = Objects.requireNonNull(outputEmptyCheck, "Output empty check cannot be null.");
    }

    public void loadSavedUsageSoFar(long gasUsedSoFar) {
        if (gasUsedSoFar > 0L) {
            this.gasUsedSoFar = gasUsedSoFar;
        }
    }

    protected void setupVariableValues() {
        this.gasUsageMultiplier = Math.max(this.gasUsage.getToUse(this.gasUsedSoFar, this.getOperatingTicks()), 0L);
    }

    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        if (tracker.shouldContinueChecking()) {
            this.recipeItem = (ItemStack)this.itemInputHandler.getRecipeInput((InputIngredient)((PlantingRecipe)this.recipe).getItemInput());
            if (this.recipeItem.m_41619_()) {
                tracker.mismatchedRecipe();
            } else {
                this.recipeGas = (GasStack)this.gasInputHandler.getRecipeInput((InputIngredient)((PlantingRecipe)this.recipe).getGasInput());
                if (this.recipeGas.isEmpty()) {
                    tracker.updateOperations(0);
                    if (!tracker.shouldContinueChecking()) {
                        return;
                    }
                }
                this.itemInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeItem);
                if (!this.recipeGas.isEmpty() && tracker.shouldContinueChecking()) {
                    this.gasInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeGas, this.gasUsageMultiplier);
                    if (tracker.shouldContinueChecking()) {
                        this.output = ((PlantingRecipe)this.recipe).getOutput(this.recipeItem, this.recipeGas);
                        this.outputHandler.calculateOperationsCanSupport(tracker, (Object)this.output);
                    }
                }
            }
        }
    }

    public boolean isInputValid() {
        GasStack gasStack;
        ItemStack itemInput = (ItemStack)this.itemInputHandler.getInput();
        if (!itemInput.m_41619_() && !(gasStack = (GasStack)this.gasInputHandler.getInput()).isEmpty() && ((PlantingRecipe)this.recipe).test(itemInput, gasStack)) {
            GasStack recipeGas = (GasStack)this.gasInputHandler.getRecipeInput((InputIngredient)((PlantingRecipe)this.recipe).getGasInput());
            return !recipeGas.isEmpty() && gasStack.getAmount() >= recipeGas.getAmount();
        }
        return false;
    }

    protected void useResources(int operations) {
        super.useResources(operations);
        if (this.gasUsageMultiplier <= 0L) {
            return;
        }
        if (this.recipeGas == null || this.recipeGas.isEmpty()) {
            return;
        }
        long toUse = (long)operations * this.gasUsageMultiplier;
        this.gasInputHandler.use((Object)this.recipeGas, toUse);
        this.gasUsedSoFar += toUse;
        this.gasUsedSoFarChanged.accept(this.gasUsedSoFar);
    }

    protected void resetCache() {
        super.resetCache();
        this.gasUsedSoFar = 0L;
        this.gasUsedSoFarChanged.accept(this.gasUsedSoFar);
    }

    protected void finishProcessing(int operations) {
        if (!(this.recipeGas == null || this.output == null || this.recipeItem.m_41619_() || this.recipeGas.isEmpty() || this.outputEmptyCheck.test(this.output))) {
            this.itemInputHandler.use((Object)this.recipeItem, operations);
            if (this.gasUsageMultiplier > 0L) {
                this.gasInputHandler.use((Object)this.recipeGas, (long)operations * this.gasUsageMultiplier);
            }
            this.outputHandler.handleOutput((Object)this.output, operations);
        }
    }

    public static PlantingCacheRecipe create(PlantingRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> itemInputHandler, ILongInputHandler<@NotNull GasStack> gasInputHandler, ItemStackConstantChemicalToItemStackCachedRecipe.ChemicalUsageMultiplier chemicalUsage, LongConsumer chemicalUsedSoFarChanged, IOutputHandler<PlantingRecipe.PlantingStationRecipeOutput> outputHandler) {
        return new PlantingCacheRecipe(recipe, recheckAllErrors, itemInputHandler, gasInputHandler, chemicalUsage, chemicalUsedSoFarChanged, outputHandler, ConstantPredicates.alwaysFalse());
    }
}

