/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.cache;

import com.jerry.mekmm.api.recipes.FluidStackGasToFluidStackRecipe;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.CachedRecipeHelper;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ReplicatorCachedRecipe<TYPE, RECIPE extends MekanismRecipe>
extends CachedRecipe<RECIPE> {
    private final IInputHandler<TYPE> inputHandler;
    private final IInputHandler<GasStack> secondaryInputHandler;
    private final IOutputHandler<TYPE> outputHandler;
    private final Predicate<TYPE> inputEmptyCheck;
    private final Predicate<GasStack> secondaryInputEmptyCheck;
    private final Supplier<? extends InputIngredient<TYPE>> inputSupplier;
    private final Supplier<? extends InputIngredient<GasStack>> secondaryInputSupplier;
    private final BiFunction<TYPE, GasStack, TYPE> outputGetter;
    private final Predicate<TYPE> outputEmptyCheck;
    private final BiConsumer<TYPE, GasStack> inputsSetter;
    private final Consumer<TYPE> outputSetter;
    @Nullable
    private TYPE input;
    @Nullable
    private GasStack secondaryInput;
    @Nullable
    private TYPE output;

    protected ReplicatorCachedRecipe(RECIPE recipe, BooleanSupplier recheckAllErrors, IInputHandler<TYPE> inputHandler, IInputHandler<GasStack> secondaryInputHandler, IOutputHandler<TYPE> outputHandler, Supplier<InputIngredient<TYPE>> inputSupplier, Supplier<InputIngredient<GasStack>> secondaryInputSupplier, BiFunction<TYPE, GasStack, TYPE> outputGetter, Predicate<TYPE> inputEmptyCheck, Predicate<GasStack> secondaryInputEmptyCheck, Predicate<TYPE> outputEmptyCheck) {
        super(recipe, recheckAllErrors);
        this.inputHandler = Objects.requireNonNull(inputHandler, "Input handler cannot be null.");
        this.secondaryInputHandler = Objects.requireNonNull(secondaryInputHandler, "Secondary input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
        this.inputSupplier = Objects.requireNonNull(inputSupplier, "Input ingredient supplier cannot be null.");
        this.secondaryInputSupplier = Objects.requireNonNull(secondaryInputSupplier, "Secondary input ingredient supplier cannot be null.");
        this.outputGetter = Objects.requireNonNull(outputGetter, "Output getter cannot be null.");
        this.inputEmptyCheck = Objects.requireNonNull(inputEmptyCheck, "Input empty check cannot be null.");
        this.secondaryInputEmptyCheck = Objects.requireNonNull(secondaryInputEmptyCheck, "Secondary input empty check cannot be null.");
        this.outputEmptyCheck = Objects.requireNonNull(outputEmptyCheck, "Output empty check cannot be null.");
        this.inputsSetter = (input, secondary) -> {
            this.input = input;
            this.secondaryInput = secondary;
        };
        this.outputSetter = output -> {
            this.output = output;
        };
    }

    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        CachedRecipeHelper.twoInputCalculateOperationsThisTick((CachedRecipe.OperationTracker)tracker, this.inputHandler, this.inputSupplier, this.secondaryInputHandler, this.secondaryInputSupplier, this.inputsSetter, this.outputHandler, this.outputGetter, this.outputSetter, this.inputEmptyCheck, this.secondaryInputEmptyCheck);
    }

    public boolean isInputValid() {
        Object input = this.inputHandler.getInput();
        if (this.inputEmptyCheck.test(input)) {
            return false;
        }
        GasStack secondaryInput = (GasStack)this.secondaryInputHandler.getInput();
        return !this.secondaryInputEmptyCheck.test(secondaryInput) && ((BiPredicate)this.recipe).test(input, secondaryInput);
    }

    protected void finishProcessing(int operations) {
        if (!(this.input == null || this.secondaryInput == null || this.output == null || this.inputEmptyCheck.test(this.input) || this.secondaryInputEmptyCheck.test(this.secondaryInput) || this.outputEmptyCheck.test(this.output))) {
            this.secondaryInputHandler.use((Object)this.secondaryInput, operations);
            this.outputHandler.handleOutput(this.output, operations);
        }
    }

    public static <RECIPE extends ItemStackGasToItemStackRecipe> ReplicatorCachedRecipe<ItemStack, RECIPE> itemReplicator(RECIPE recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> itemInputHandler, IInputHandler<@NotNull GasStack> chemicalInputHandler, IOutputHandler<@NotNull ItemStack> outputHandler) {
        return new ReplicatorCachedRecipe<ItemStack, RECIPE>(recipe, recheckAllErrors, itemInputHandler, chemicalInputHandler, outputHandler, () -> recipe.getItemInput(), () -> recipe.getChemicalInput(), (arg_0, arg_1) -> recipe.getOutput(arg_0, arg_1), ItemStack::m_41619_, ChemicalStack::isEmpty, ItemStack::m_41619_);
    }

    public static <RECIPE extends FluidStackGasToFluidStackRecipe> ReplicatorCachedRecipe<FluidStack, RECIPE> fluidReplicator(RECIPE recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull FluidStack> fluidInputHandler, IInputHandler<@NotNull GasStack> chemicalInputHandler, IOutputHandler<@NotNull FluidStack> outputHandler) {
        return new ReplicatorCachedRecipe<FluidStack, RECIPE>(recipe, recheckAllErrors, fluidInputHandler, chemicalInputHandler, outputHandler, recipe::getFluidInput, recipe::getChemicalInput, recipe::getOutput, FluidStack::isEmpty, ChemicalStack::isEmpty, FluidStack::isEmpty);
    }
}

