/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.chemical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public abstract class FluidStackChemicalToFluidStackRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>>
extends MekanismRecipe
implements BiPredicate<FluidStack, STACK> {
    private final FluidStackIngredient fluidInput;
    private final INGREDIENT chemicalInput;
    private final FluidStack output;

    public FluidStackChemicalToFluidStackRecipe(ResourceLocation id, FluidStackIngredient fluidInput, INGREDIENT chemicalInput, FluidStack output) {
        super(id);
        this.fluidInput = Objects.requireNonNull(fluidInput, "Fluid input cannot be null.");
        this.chemicalInput = (ChemicalStackIngredient)Objects.requireNonNull(chemicalInput, "Chemical input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
    }

    public FluidStackIngredient getFluidInput() {
        return this.fluidInput;
    }

    public INGREDIENT getChemicalInput() {
        return this.chemicalInput;
    }

    @Contract(value="_, _ -> new", pure=true)
    public FluidStack getOutput(FluidStack inputFluid, STACK inputChemical) {
        return this.output.copy();
    }

    @Override
    public boolean test(FluidStack fluidStack, STACK chemicalStack) {
        return this.fluidInput.test((Object)fluidStack) && this.chemicalInput.test(chemicalStack);
    }

    public List<@NotNull FluidStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    public boolean m_142505_() {
        return this.fluidInput.hasNoMatchingInstances() || this.chemicalInput.hasNoMatchingInstances();
    }

    public void logMissingTags() {
        this.fluidInput.logMissingTags();
        this.chemicalInput.logMissingTags();
    }

    public void write(FriendlyByteBuf buffer) {
        this.fluidInput.write(buffer);
        this.chemicalInput.write(buffer);
        buffer.writeFluidStack(this.output);
    }
}

