/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.jei.machine;

import com.jerry.mekmm.api.recipes.PlantingRecipe;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import java.util.ArrayList;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiEmptyBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.client.jei.MekanismJEIRecipeType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.world.item.ItemStack;

@NothingNullByDefault
public class PlantingRecipeCategory
extends BaseRecipeCategory<PlantingRecipe> {
    private final GuiBar<?> chemicalInput;
    private final GuiSlot input = this.addSlot(SlotType.INPUT, 56, 17);
    private final GuiSlot extra = this.addSlot(SlotType.EXTRA, 56, 53);
    private final GuiSlot output;

    public PlantingRecipeCategory(IGuiHelper helper, MekanismJEIRecipeType<PlantingRecipe> recipeType) {
        super(helper, recipeType, MoreMachineBlocks.PLANTING_STATION, 28, 16, 144, 54);
        this.addSlot(SlotType.POWER, 31, 35).with(SlotOverlay.POWER);
        this.output = this.addSlot(SlotType.OUTPUT_WIDE, 112, 31);
        this.addElement((GuiTexturedElement)new GuiVerticalPowerBar((IGuiWrapper)this, FULL_BAR, 164, 15));
        this.chemicalInput = (GuiBar)this.addElement((GuiTexturedElement)new GuiEmptyBar((IGuiWrapper)this, 60, 36, 6, 12));
        this.addSimpleProgress(ProgressType.BAR, 78, 38);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PlantingRecipe recipe, IFocusGroup focuses) {
        this.initItem(builder, RecipeIngredientRole.INPUT, this.input, recipe.getItemInput().getRepresentations());
        ArrayList gasItemProviders = new ArrayList();
        ArrayList<GasStack> scaledGases = new ArrayList<GasStack>();
        for (GasStack gas : recipe.getGasInput().getRepresentations()) {
            gasItemProviders.addAll(MekanismJEI.GAS_STACK_HELPER.getStacksFor((Chemical)((Gas)gas.getType()), true));
            scaledGases.add(new GasStack(gas, gas.getAmount() * 200L));
        }
        this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.INPUT, (GuiElement)this.chemicalInput, scaledGases);
        ArrayList<ItemStack> firstOutputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> secondOutputs = new ArrayList<ItemStack>();
        for (PlantingRecipe.PlantingStationRecipeOutput output : recipe.getOutputDefinition()) {
            firstOutputs.add(output.first());
            secondOutputs.add(output.second());
        }
        this.initItem(builder, RecipeIngredientRole.OUTPUT, this.output.m_252754_() + 32, this.output.m_252907_() + 20, firstOutputs);
        if (!secondOutputs.stream().allMatch(ItemStack::m_41619_)) {
            this.initItem(builder, RecipeIngredientRole.OUTPUT, this.output.m_252754_() + 48, this.output.m_252907_() + 20, secondOutputs);
        }
        this.initItem(builder, RecipeIngredientRole.CATALYST, this.extra, gasItemProviders);
    }
}

