/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.network.to_server;

import com.jerry.mekaf.common.tile.base.TileEntityAdvancedFactoryBase;
import com.jerry.mekmm.common.tile.factory.TileEntityMoreMachineFactory;
import mekanism.api.functions.TriConsumer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class MoreMachinePacketGuiInteract
implements IMekanismPacket {
    private final Type interactionType = Type.INT;
    private GuiInteraction interaction;
    private BlockPos tilePosition;
    private int extra;

    public MoreMachinePacketGuiInteract(GuiInteraction interaction, BlockEntity tile) {
        this(interaction, tile.m_58899_());
    }

    public MoreMachinePacketGuiInteract(GuiInteraction interaction, BlockEntity tile, int extra) {
        this(interaction, tile.m_58899_(), extra);
    }

    public MoreMachinePacketGuiInteract(GuiInteraction interaction, BlockPos tilePosition) {
        this(interaction, tilePosition, 0);
    }

    public MoreMachinePacketGuiInteract(GuiInteraction interaction, BlockPos tilePosition, int extra) {
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public void handle(NetworkEvent.Context context) {
        TileEntityMekanism tile;
        ServerPlayer player = context.getSender();
        if (player != null && (tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.m_9236_(), (BlockPos)this.tilePosition)) != null && this.interactionType == Type.INT) {
            this.interaction.consume(tile, (Player)player, this.extra);
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.interactionType);
        if (this.interactionType == Type.INT) {
            buffer.m_130068_((Enum)this.interaction);
            buffer.m_130064_(this.tilePosition);
            buffer.m_130130_(this.extra);
        }
    }

    public static MoreMachinePacketGuiInteract decode(FriendlyByteBuf buffer) {
        switch ((Type)buffer.m_130066_(Type.class)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INT: 
        }
        return new MoreMachinePacketGuiInteract((GuiInteraction)buffer.m_130066_(GuiInteraction.class), buffer.m_130135_(), buffer.m_130242_());
    }

    public static enum GuiInteraction {
        AUTO_SORT_BUTTON((TriConsumer<TileEntityMekanism, Player, Integer>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityAdvancedFactoryBase) {
                TileEntityAdvancedFactoryBase factory = (TileEntityAdvancedFactoryBase)((Object)tile);
                factory.toggleSorting();
            } else if (tile instanceof TileEntityMoreMachineFactory) {
                TileEntityMoreMachineFactory factory = (TileEntityMoreMachineFactory)((Object)tile);
                factory.toggleSorting();
            }
        }));

        private final TriConsumer<TileEntityMekanism, Player, Integer> consumerForTile;

        private GuiInteraction(TriConsumer<TileEntityMekanism, Player, Integer> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, int extra) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)extra);
        }
    }

    private static enum Type {
        INT;

    }
}

