/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.api.recipes.PlantingRecipe;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class PlantingRecipeSerializer<RECIPE extends PlantingRecipe>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public PlantingRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    public RECIPE fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonArray itemInput = GsonHelper.m_13885_((JsonObject)json, (String)"itemInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"itemInput") : GsonHelper.m_13930_((JsonObject)json, (String)"itemInput");
        ItemStackIngredient itemInputIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)itemInput);
        JsonArray gasInput = GsonHelper.m_13885_((JsonObject)json, (String)"gasInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"gasInput") : GsonHelper.m_13930_((JsonObject)json, (String)"gasInput");
        ChemicalStackIngredient.GasStackIngredient gasInputIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().deserialize((JsonElement)gasInput);
        ItemStack mainOutput = SerializerHelper.getItemStack((JsonObject)json, (String)"mainOutput");
        ItemStack secondaryOutput = ItemStack.f_41583_;
        if (json.has("secondaryOutput")) {
            if (mainOutput.m_41619_()) {
                throw new JsonSyntaxException("Planting main recipe output must not be empty, if it is defined.");
            }
            secondaryOutput = SerializerHelper.getItemStack((JsonObject)json, (String)"secondaryOutput");
        } else if (mainOutput.m_41619_()) {
            throw new JsonSyntaxException("Planting main recipe output must not be empty, if it is defined.");
        }
        return this.factory.create(recipeId, itemInputIngredient, gasInputIngredient, mainOutput, secondaryOutput);
    }

    @Nullable
    public RECIPE fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient itemInputIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            ChemicalStackIngredient.GasStackIngredient gasStackIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().read(buffer);
            ItemStack mainOutput = buffer.m_130267_();
            ItemStack secondaryOutput = buffer.m_130267_();
            return this.factory.create(recipeId, itemInputIngredient, gasStackIngredient, mainOutput, secondaryOutput);
        }
        catch (Exception e) {
            Mekmm.LOGGER.error("Error reading planting recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(FriendlyByteBuf buffer, RECIPE recipe) {
        try {
            ((PlantingRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekmm.LOGGER.error("Error writing planting recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends PlantingRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, ChemicalStackIngredient.GasStackIngredient var3, ItemStack var4, ItemStack var5);
    }
}

