/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.api.recipes.RecyclerRecipe;
import mekanism.api.SerializerHelper;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecyclerRecipeSerializer<RECIPE extends RecyclerRecipe>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public RecyclerRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        JsonArray input = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? GsonHelper.m_13933_((JsonObject)json, (String)"input") : GsonHelper.m_13930_((JsonObject)json, (String)"input");
        ItemStackIngredient inputIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)input);
        JsonElement chance = json.get("chance");
        if (!GsonHelper.m_13872_((JsonElement)chance)) {
            throw new JsonSyntaxException("Expected chance to be a number greater than zero.");
        }
        double getChance = chance.getAsJsonPrimitive().getAsDouble();
        if (getChance <= 0.0 || getChance > 1.0) {
            throw new JsonSyntaxException("Expected chance to be greater than zero, and less than or equal to  one.");
        }
        ItemStack output = SerializerHelper.getItemStack((JsonObject)json, (String)"output");
        if (output.m_41619_()) {
            throw new JsonSyntaxException("Recycler recipe output must not be empty, if it is defined.");
        }
        return this.factory.create(recipeId, inputIngredient, output, getChance);
    }

    @Nullable
    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient inputIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            ItemStack output = buffer.m_130267_();
            double chance = buffer.readDouble();
            return this.factory.create(recipeId, inputIngredient, output, chance);
        }
        catch (Exception e) {
            Mekmm.LOGGER.error("Error reading recycler recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        try {
            ((RecyclerRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekmm.LOGGER.error("Error writing recycler recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecyclerRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, ItemStack var3, double var4);
    }
}

