/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekmm.common.block.BlockDoll;
import com.jerry.mekmm.common.block.prefab.BlockMoreMachineFactoryMachine;
import com.jerry.mekmm.common.content.blocktype.MoreMachineFactory;
import com.jerry.mekmm.common.content.blocktype.MoreMachineFactoryType;
import com.jerry.mekmm.common.content.blocktype.MoreMachineMachine;
import com.jerry.mekmm.common.item.block.ItemBlockDoll;
import com.jerry.mekmm.common.item.block.machine.ItemBlockMoreMachineFactory;
import com.jerry.mekmm.common.registries.MoreMachineBlockTypes;
import com.jerry.mekmm.common.tile.factory.TileEntityMoreMachineFactory;
import com.jerry.mekmm.common.tile.machine.TileEntityAmbientGasCollector;
import com.jerry.mekmm.common.tile.machine.TileEntityFluidReplicator;
import com.jerry.mekmm.common.tile.machine.TileEntityLathe;
import com.jerry.mekmm.common.tile.machine.TileEntityPlantingStation;
import com.jerry.mekmm.common.tile.machine.TileEntityRecycler;
import com.jerry.mekmm.common.tile.machine.TileEntityReplicator;
import com.jerry.mekmm.common.tile.machine.TileEntityRollingMill;
import com.jerry.mekmm.common.tile.machine.TileEntityStamper;
import com.jerry.mekmm.common.util.MoreMachineEnumUtils;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.tier.ITier;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.item.block.machine.ItemBlockMachine;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.tier.FactoryTier;
import mekanism.common.util.EnumUtils;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.NotNull;

public class MoreMachineBlocks {
    public static final BlockDeferredRegister MM_BLOCKS = new BlockDeferredRegister("mekmm");
    private static final Table<FactoryTier, MoreMachineFactoryType, BlockRegistryObject<BlockMoreMachineFactoryMachine.BlockMoreMachineFactory<?>, ItemBlockMoreMachineFactory>> FACTORIES = HashBasedTable.create();
    public static final BlockRegistryObject<BlockMoreMachineFactoryMachine<TileEntityRecycler, MoreMachineMachine.MoreMachineFactoryMachine<TileEntityRecycler>>, ItemBlockMachine> RECYCLER;
    public static final BlockRegistryObject<BlockMoreMachineFactoryMachine<TileEntityPlantingStation, MoreMachineMachine.MoreMachineFactoryMachine<TileEntityPlantingStation>>, ItemBlockMachine> PLANTING_STATION;
    public static final BlockRegistryObject<BlockMoreMachineFactoryMachine<TileEntityStamper, MoreMachineMachine.MoreMachineFactoryMachine<TileEntityStamper>>, ItemBlockMachine> CNC_STAMPER;
    public static final BlockRegistryObject<BlockMoreMachineFactoryMachine<TileEntityLathe, MoreMachineMachine.MoreMachineFactoryMachine<TileEntityLathe>>, ItemBlockMachine> CNC_LATHE;
    public static final BlockRegistryObject<BlockMoreMachineFactoryMachine<TileEntityRollingMill, MoreMachineMachine.MoreMachineFactoryMachine<TileEntityRollingMill>>, ItemBlockMachine> CNC_ROLLING_MILL;
    public static final BlockRegistryObject<BlockMoreMachineFactoryMachine<TileEntityReplicator, MoreMachineMachine.MoreMachineFactoryMachine<TileEntityReplicator>>, ItemBlockMachine> REPLICATOR;
    public static final BlockRegistryObject<BlockMoreMachineFactoryMachine<TileEntityFluidReplicator, MoreMachineMachine.MoreMachineFactoryMachine<TileEntityFluidReplicator>>, ItemBlockMachine> FLUID_REPLICATOR;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityAmbientGasCollector, MoreMachineMachine<TileEntityAmbientGasCollector>>, ItemBlockMachine> AMBIENT_GAS_COLLECTOR;
    public static final BlockRegistryObject<BlockDoll, ItemBlockDoll> AUTHOR_DOLL;

    private MoreMachineBlocks() {
    }

    private static <TILE extends TileEntityMoreMachineFactory<?>> BlockRegistryObject<BlockMoreMachineFactoryMachine.BlockMoreMachineFactory<?>, ItemBlockMoreMachineFactory> registerFactory(MoreMachineFactory<TILE> type) {
        return MoreMachineBlocks.registerTieredBlock(type, "_" + type.getMMFactoryType().getRegistryNameComponent() + "_factory", () -> new BlockMoreMachineFactoryMachine.BlockMoreMachineFactory(type), ItemBlockMoreMachineFactory::new);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(BlockType type, String suffix, Supplier<? extends BLOCK> blockSupplier, Function<BLOCK, ITEM> itemCreator) {
        return MoreMachineBlocks.registerTieredBlock(((AttributeTier)type.get(AttributeTier.class)).tier(), suffix, blockSupplier, itemCreator);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(ITier tier, String suffix, Supplier<? extends BLOCK> blockSupplier, Function<BLOCK, ITEM> itemCreator) {
        return MM_BLOCKS.register(tier.getBaseTier().getLowerName() + suffix, blockSupplier, itemCreator);
    }

    public static BlockRegistryObject<BlockMoreMachineFactoryMachine.BlockMoreMachineFactory<?>, ItemBlockMoreMachineFactory> getMoreMachineFactory(@NotNull FactoryTier tier, @NotNull MoreMachineFactoryType type) {
        return (BlockRegistryObject)FACTORIES.get((Object)tier, (Object)type);
    }

    public static BlockRegistryObject<BlockMoreMachineFactoryMachine.BlockMoreMachineFactory<?>, ItemBlockMoreMachineFactory>[] getMoreMachineFactoryBlocks() {
        return FACTORIES.values().toArray(new BlockRegistryObject[0]);
    }

    static {
        for (FactoryTier tier : EnumUtils.FACTORY_TIERS) {
            for (MoreMachineFactoryType type : MoreMachineEnumUtils.MM_FACTORY_TYPES) {
                FACTORIES.put((Object)tier, (Object)type, MoreMachineBlocks.registerFactory(MoreMachineBlockTypes.getMoreMachineFactory(tier, type)));
            }
        }
        RECYCLER = MM_BLOCKS.register("recycler", () -> new BlockMoreMachineFactoryMachine(MoreMachineBlockTypes.RECYCLER, properties -> properties.m_284180_(BlockResourceInfo.STEEL.getMapColor())), ItemBlockMachine::new);
        PLANTING_STATION = MM_BLOCKS.register("planting_station", () -> new BlockMoreMachineFactoryMachine(MoreMachineBlockTypes.PLANTING_STATION, properties -> properties.m_284180_(BlockResourceInfo.STEEL.getMapColor())), ItemBlockMachine::new);
        CNC_STAMPER = MM_BLOCKS.register("cnc_stamper", () -> new BlockMoreMachineFactoryMachine(MoreMachineBlockTypes.CNC_STAMPER, properties -> properties.m_284180_(BlockResourceInfo.STEEL.getMapColor())), ItemBlockMachine::new);
        CNC_LATHE = MM_BLOCKS.register("cnc_lathe", () -> new BlockMoreMachineFactoryMachine(MoreMachineBlockTypes.CNC_LATHE, properties -> properties.m_284180_(BlockResourceInfo.STEEL.getMapColor())), ItemBlockMachine::new);
        CNC_ROLLING_MILL = MM_BLOCKS.register("cnc_rolling_mill", () -> new BlockMoreMachineFactoryMachine(MoreMachineBlockTypes.CNC_ROLLING_MILL, properties -> properties.m_284180_(BlockResourceInfo.STEEL.getMapColor())), ItemBlockMachine::new);
        REPLICATOR = MM_BLOCKS.register("replicator", () -> new BlockMoreMachineFactoryMachine(MoreMachineBlockTypes.REPLICATOR, properties -> properties.m_284180_(BlockResourceInfo.STEEL.getMapColor())), ItemBlockMachine::new);
        FLUID_REPLICATOR = MM_BLOCKS.register("fluid_replicator", () -> new BlockMoreMachineFactoryMachine(MoreMachineBlockTypes.FLUID_REPLICATOR, properties -> properties.m_284180_(BlockResourceInfo.STEEL.getMapColor())), ItemBlockMachine::new);
        AMBIENT_GAS_COLLECTOR = MM_BLOCKS.register("ambient_gas_collector", () -> new BlockTile.BlockTileModel(MoreMachineBlockTypes.AMBIENT_GAS_COLLECTOR, properties -> properties.m_284180_(BlockResourceInfo.STEEL.getMapColor())), ItemBlockMachine::new);
        AUTHOR_DOLL = MM_BLOCKS.register("author_doll", () -> new BlockDoll(MoreMachineBlockTypes.AUTHOR_DOLL, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56745_).m_155954_(0.0f).m_60978_(0.0f)), ItemBlockDoll::new);
    }
}

