/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.factory;

import com.jerry.mekmm.api.recipes.cache.ReplicatorCachedRecipe;
import com.jerry.mekmm.common.config.MoreMachineConfig;
import com.jerry.mekmm.common.recipe.impl.ReplicatorIRecipe;
import com.jerry.mekmm.common.registries.MoreMachineGas;
import com.jerry.mekmm.common.tile.factory.TileEntityItemToItemMoreMachineFactory;
import com.jerry.mekmm.common.util.ValidatorUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.upgrade.AdvancedMachineUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityReplicatingFactory
extends TileEntityItemToItemMoreMachineFactory<ItemStackGasToItemStackRecipe>
implements IHasDumpButton,
IDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<Gas, GasStack, ItemStackGasToItemStackRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    public static final long MAX_GAS = 10000L;
    public static HashMap<String, Integer> customRecipeMap = ValidatorUtils.getRecipeFromConfig((List)MoreMachineConfig.general.itemReplicatorRecipe.get());
    private final ILongInputHandler<GasStack> chemicalInputHandler;
    public IGasTank gasTank;
    GasInventorySlot gasSlot;

    public TileEntityReplicatingFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        this.configComponent.addSupported(TransmissionType.GAS);
        this.configComponent.setupInputConfig(TransmissionType.GAS, (Object)this.gasTank);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM});
        this.chemicalInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.gasTank);
    }

    public IGasTank getGasTank() {
        return this.gasTank;
    }

    @Nullable
    public GasInventorySlot getExtraSlot() {
        return this.gasSlot;
    }

    @Nullable
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideGasWithConfig(() -> ((TileEntityReplicatingFactory)this).getDirection(), () -> ((TileEntityReplicatingFactory)this).getConfig());
        this.gasTank = (IGasTank)ChemicalTankBuilder.GAS.create(10000L * (long)this.tier.processes, TileEntityReplicatingFactory::isValidChemicalInput, this.markAllMonitorsChanged(listener));
        builder.addTank((IChemicalTank)this.gasTank);
        return builder.build();
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        super.addSlots(builder, listener, updateSortingListener);
        this.gasSlot = GasInventorySlot.fillOrConvert((IGasTank)this.gasTank, () -> ((TileEntityReplicatingFactory)this).m_58904_(), (IContentsListener)listener, (int)7, (int)57);
        builder.addSlot((IInventorySlot)this.gasSlot);
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<ItemStackGasToItemStackRecipe> cached, @NotNull ItemStack stack) {
        return cached != null && TileEntityReplicatingFactory.isValidChemicalInput((Gas)this.gasTank.getType());
    }

    @Override
    @Nullable
    protected ItemStackGasToItemStackRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        return null;
    }

    @Override
    protected void handleSecondaryFuel() {
        this.gasSlot.fillTankOrConvert();
    }

    @Override
    protected int getNeededInput(ItemStackGasToItemStackRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getItemInput().getNeededAmount((Object)inputStack));
    }

    @Override
    public boolean isItemValidForSlot(@NotNull ItemStack stack) {
        return true;
    }

    public static boolean isValidChemicalInput(Gas gas) {
        return gas.equals(MoreMachineGas.UU_MATTER.getChemical());
    }

    @Override
    public boolean isValidInputItem(ItemStack stack) {
        Item item = stack.m_41720_();
        if (customRecipeMap != null) {
            return customRecipeMap.containsKey(Objects.requireNonNull(RegistryUtils.getName((Item)item)).toString());
        }
        return false;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<ItemStackGasToItemStackRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ItemStackGasToItemStackRecipe>> getRecipeType() {
        return null;
    }

    @Nullable
    public ItemStackGasToItemStackRecipe getRecipe(int cacheIndex) {
        return TileEntityReplicatingFactory.getRecipe((ItemStack)this.inputHandlers[cacheIndex].getInput(), (GasStack)this.chemicalInputHandler.getInput());
    }

    @NotNull
    public CachedRecipe<ItemStackGasToItemStackRecipe> createNewCachedRecipe(@NotNull ItemStackGasToItemStackRecipe recipe, int cacheIndex) {
        return ReplicatorCachedRecipe.itemReplicator(recipe, this.recheckAllRecipeErrors[cacheIndex], (IInputHandler<ItemStack>)this.inputHandlers[cacheIndex], this.chemicalInputHandler, (IOutputHandler<ItemStack>)this.outputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((MachineEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityReplicatingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    public static ItemStackGasToItemStackRecipe getRecipe(ItemStack itemStack, GasStack gasStack) {
        if (gasStack.isEmpty() || itemStack.m_41619_()) {
            return null;
        }
        if (customRecipeMap != null) {
            Item item = itemStack.m_41720_();
            int amount = customRecipeMap.getOrDefault(RegistryUtils.getName((Item)item).toString(), 0);
            if (amount == 0) {
                return null;
            }
            return new ReplicatorIRecipe(item, IngredientCreatorAccess.item().from(item, 1), (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from(MoreMachineGas.UU_MATTER, (long)amount), new ItemStack((ItemLike)item, 1));
        }
        return null;
    }

    @Override
    public boolean hasSecondaryResourceBar() {
        return true;
    }

    @Override
    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof AdvancedMachineUpgradeData) {
            AdvancedMachineUpgradeData data = (AdvancedMachineUpgradeData)upgradeData;
            super.parseUpgradeData(upgradeData);
            this.gasTank.deserializeNBT(data.stored.serializeNBT());
            this.gasSlot.deserializeNBT(data.gasSlot.serializeNBT());
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @Nullable
    public AdvancedMachineUpgradeData getUpgradeData() {
        return new AdvancedMachineUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, null, this.gasTank, this.gasSlot, this.energySlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }

    public void dump() {
        this.gasTank.setEmpty();
    }
}

