/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.machine;

import com.jerry.mekmm.api.recipes.FluidStackGasToFluidStackRecipe;
import com.jerry.mekmm.api.recipes.cache.ReplicatorCachedRecipe;
import com.jerry.mekmm.common.config.MoreMachineConfig;
import com.jerry.mekmm.common.recipe.impl.FluidReplicatorIRecipe;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.registries.MoreMachineGas;
import com.jerry.mekmm.common.util.ValidatorUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.FluidSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityFluidReplicator
extends TileEntityProgressMachine<FluidStackGasToFluidStackRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    public static final int MAX_FLUID = 10000;
    public static final long MAX_GAS = 10000L;
    private static final int BASE_TICKS_REQUIRED = 200;
    public static HashMap<String, Integer> customRecipeMap = ValidatorUtils.getRecipeFromConfig((List)MoreMachineConfig.general.fluidReplicatorRecipe.get());
    public BasicFluidTank fluidInputTank;
    public BasicFluidTank fluidOutputTank;
    public IGasTank gasTank;
    private MachineEnergyContainer<TileEntityFluidReplicator> energyContainer;
    private final IInputHandler<@NotNull FluidStack> fluidInputHandler;
    private final IOutputHandler<@NotNull FluidStack> fluidOutputHandler;
    private final ILongInputHandler<GasStack> chemicalInputHandler;
    FluidInventorySlot lFluidInputSlot;
    FluidInventorySlot rFluidInputSlot;
    FluidInventorySlot fluidInputSlot;
    OutputInventorySlot fluidOutputSlot;
    GasInventorySlot chemicalSlot;
    EnergyInventorySlot energySlot;

    public TileEntityFluidReplicator(BlockPos pos, BlockState state) {
        super(MoreMachineBlocks.FLUID_REPLICATOR, pos, state, TRACKED_ERROR_TYPES, 200);
        ConfigInfo fluidConfig;
        this.configComponent = new TileComponentConfig((TileEntityMekanism)this, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.FLUID, TransmissionType.GAS, TransmissionType.ENERGY});
        this.configComponent.setupItemIOConfig(List.of(this.fluidInputSlot, this.lFluidInputSlot), List.of(this.rFluidInputSlot, this.fluidOutputSlot), (IInventorySlot)this.energySlot, false);
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.EXTRA, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.chemicalSlot}));
        }
        if ((fluidConfig = this.configComponent.getConfig(TransmissionType.FLUID)) != null) {
            fluidConfig.addSlotInfo(DataType.INPUT, (ISlotInfo)new FluidSlotInfo(true, false, new IExtendedFluidTank[]{this.fluidInputTank}));
            fluidConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new FluidSlotInfo(false, true, new IExtendedFluidTank[]{this.fluidOutputTank}));
        }
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.configComponent.setupInputConfig(TransmissionType.GAS, (Object)this.gasTank);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.FLUID, TransmissionType.ITEM}).setCanTankEject(tank -> tank == this.fluidOutputTank);
        this.fluidInputHandler = InputHelper.getInputHandler((IExtendedFluidTank)this.fluidInputTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.fluidOutputHandler = OutputHelper.getOutputHandler((IExtendedFluidTank)this.fluidOutputTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
        this.chemicalInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.gasTank);
    }

    @Nullable
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig(() -> ((TileEntityFluidReplicator)this).getDirection(), () -> ((TileEntityFluidReplicator)this).getConfig());
        this.fluidInputTank = BasicFluidTank.input((int)1000, TileEntityFluidReplicator::isValidFluidInput, (IContentsListener)recipeCacheListener);
        builder.addTank((IExtendedFluidTank)this.fluidInputTank);
        this.fluidOutputTank = BasicFluidTank.output((int)10000, (IContentsListener)listener);
        builder.addTank((IExtendedFluidTank)this.fluidOutputTank);
        return builder.build();
    }

    @Nullable
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideGasWithConfig(() -> ((TileEntityFluidReplicator)this).getDirection(), () -> ((TileEntityFluidReplicator)this).getConfig());
        this.gasTank = (IGasTank)ChemicalTankBuilder.GAS.create(10000L, TileEntityFluidReplicator::isValidGasInput, recipeCacheListener);
        builder.addTank((IChemicalTank)this.gasTank);
        return builder.build();
    }

    @Nullable
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(() -> ((TileEntityFluidReplicator)this).getDirection(), () -> ((TileEntityFluidReplicator)this).getConfig());
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(() -> ((TileEntityFluidReplicator)this).getDirection(), () -> ((TileEntityFluidReplicator)this).getConfig());
        this.fluidInputSlot = FluidInventorySlot.fill((IExtendedFluidTank)this.fluidInputTank, (IContentsListener)listener, (int)180, (int)71);
        builder.addSlot((IInventorySlot)this.fluidInputSlot);
        this.fluidOutputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)180, (int)102);
        builder.addSlot((IInventorySlot)this.fluidOutputSlot);
        this.lFluidInputSlot = FluidInventorySlot.drain((IExtendedFluidTank)this.fluidInputTank, (IContentsListener)listener, (int)29, (int)65);
        builder.addSlot((IInventorySlot)this.lFluidInputSlot);
        this.rFluidInputSlot = FluidInventorySlot.drain((IExtendedFluidTank)this.fluidOutputTank, (IContentsListener)listener, (int)132, (int)65);
        builder.addSlot((IInventorySlot)this.rFluidInputSlot);
        this.chemicalSlot = GasInventorySlot.fillOrConvert((IGasTank)this.gasTank, () -> ((TileEntityFluidReplicator)this).m_58904_(), (IContentsListener)listener, (int)8, (int)65);
        builder.addSlot((IInventorySlot)this.chemicalSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityFluidReplicator)this).m_58904_(), (IContentsListener)listener, (int)152, (int)65);
        builder.addSlot((IInventorySlot)this.energySlot);
        this.chemicalSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.fluidInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.lFluidInputSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.rFluidInputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    public static boolean isValidFluidInput(FluidStack stack) {
        if (customRecipeMap != null) {
            return customRecipeMap.containsKey(Objects.requireNonNull(RegistryUtils.getName((Fluid)stack.getFluid())).toString());
        }
        return false;
    }

    public static boolean isValidGasInput(Gas gas) {
        return gas.equals(MoreMachineGas.UU_MATTER.getChemical());
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.fluidInputSlot.fillTank((IInventorySlot)this.fluidOutputSlot);
        this.chemicalSlot.fillTankOrConvert();
        this.lFluidInputSlot.drainTank((IInventorySlot)this.fluidOutputSlot);
        this.rFluidInputSlot.drainTank((IInventorySlot)this.fluidOutputSlot);
        this.recipeCacheLookupMonitor.updateAndProcess();
    }

    @Nullable
    public MachineEnergyContainer<TileEntityFluidReplicator> getEnergyContainer() {
        return this.energyContainer;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<FluidStackGasToFluidStackRecipe, ?> getRecipeType() {
        return null;
    }

    @Nullable
    public FluidStackGasToFluidStackRecipe getRecipe(int cacheIndex) {
        return TileEntityFluidReplicator.getRecipe((FluidStack)this.fluidInputHandler.getInput(), (GasStack)this.chemicalInputHandler.getInput());
    }

    @NotNull
    public CachedRecipe<FluidStackGasToFluidStackRecipe> createNewCachedRecipe(@NotNull FluidStackGasToFluidStackRecipe recipe, int cacheIndex) {
        return ReplicatorCachedRecipe.fluidReplicator(recipe, this.recheckAllRecipeErrors, this.fluidInputHandler, this.chemicalInputHandler, this.fluidOutputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set)x$0)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(arg_0 -> ((TileEntityFluidReplicator)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setRequiredTicks(() -> ((TileEntityFluidReplicator)this).getTicksRequired()).setOnFinish(() -> ((TileEntityFluidReplicator)this).markForSave()).setOperatingTicksChanged(x$0 -> this.setOperatingTicks(x$0));
    }

    public static FluidStackGasToFluidStackRecipe getRecipe(FluidStack fluidStack, GasStack chemicalStack) {
        if (chemicalStack.isEmpty() || fluidStack.isEmpty()) {
            return null;
        }
        if (customRecipeMap != null) {
            Fluid fluid = fluidStack.getFluid();
            int amount = customRecipeMap.getOrDefault(RegistryUtils.getName((Fluid)fluid).toString(), 0);
            if (amount == 0) {
                return null;
            }
            return new FluidReplicatorIRecipe(fluid, IngredientCreatorAccess.fluid().from(fluid, 1000), (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().from((Chemical)MoreMachineGas.UU_MATTER.getChemical(), amount), new FluidStack(fluid, 1000));
        }
        return null;
    }
}

